// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/operand.cpp,v 1.2 2001/08/13 10:00:42 xhshi Exp $
//


#include "defines.h"
#include "iostream.h"

#include "x86.h"

#include "stack.h"
#include "code_emitter.h"
#include "register_manager.h"
#include "operand.h"

#include "defines.h"
X86_Reg_No choose_a_callee_reg(X86_Reg_No r1) {
	if (r1 != esi_reg) return esi_reg;
	return edi_reg;
}
X86_Reg_No choose_a_callee_reg(X86_Reg_No r1, X86_Reg_No r2){
	if (r1 != esi_reg && r2 != esi_reg) return esi_reg;
	else if (r1 != edi_reg && r2 != edi_reg) return edi_reg;
	return ebx_reg;
}

int Reg_Operand::spill32(Code_Emitter& emitter,Register_Manager& reg_manager,
						 Frame& frame,unsigned depth) {
	assert(hold_local_reg(reg_manager.local_regs()));
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),&opnd);
	free_opnd(&reg_manager);
	return 1;
}
void Mem_Var_Operand::home32(Code_Emitter& emitter,Register_Manager& reg_manager,
							 Frame& frame,unsigned depth) {
	Reg_Operand *reg = reg_manager.get_reg();
	// 
	// mov ecx, var_off[esp]
	// mov off[esp], ecx
	//
	emitter.emit_mov(&reg->opnd,&opnd);
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),&reg->opnd);
	reg->free_opnd(&reg_manager);
}
//
// base_reg must be a scratch reg
//
int Field_Operand::spill32(Code_Emitter& emitter,Register_Manager& reg_manager, 
						   Frame& frame,unsigned depth) {
	assert(hold_local_reg(reg_manager.local_regs()));
	R_Opnd base(opnd.base_reg);
	// 
	// mov eax, [eax + 4]
	// mov [esp+off], eax
	//
#ifdef _CSE
	reg_manager.update_reg_info(opnd.base_reg);
#endif
	emitter.emit_mov(&base,&opnd);
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),&base);
	free_opnd(&reg_manager);
	return 1;
}
//
// update home location with the operand value
//
void Field_Operand::home32(Code_Emitter& emitter,Register_Manager& reg_manager, 
						   Frame& frame,unsigned depth) {
	Reg_Operand *reg = reg_manager.get_reg();
	// 
	// mov ecx, [eax + 4]
	// mov [esp+off], ecx
	//
	emitter.emit_mov(&reg->opnd,&opnd);
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),&reg->opnd);
	free_opnd(&reg_manager);
	reg->free_opnd(&reg_manager);
}
void Field_Operand::home64_hi(Code_Emitter& emitter,Register_Manager& reg_manager, 
							  Frame& frame,unsigned depth) {
	if (reg_manager.has_available_reg()) 
		home32(emitter,reg_manager,frame,depth);
	else {
		X86_Reg_No r = pick_a_callee_reg();
		R_Opnd callee(r);
		//
		// mov off+4[esp], esi  -- high 32 bit location as a spill area for callee
		// mov esi, [eax + 4]
		// mov off[esp], esi
		// mov esi, off+4[esp]
		//
		M_Spill_Opnd hi(frame,depth+1);
		emitter.emit_mov(&hi,&callee);
		emitter.emit_mov(&callee,&opnd);
		emitter.emit_mov(&M_Spill_Opnd(frame,depth),&callee);
		emitter.emit_mov(&callee,&hi);
		free_opnd(&reg_manager);
	}
}
//
// for 32 bit array access with 1 caller-save reg.  We can spill the array operand
// without any extra register.
//
int Array_Operand::spill32(Code_Emitter& emitter,Register_Manager& reg_manager,
						   Frame& frame,unsigned depth) {
	unsigned local_regs = reg_manager.local_regs();
	assert(hold_local_reg(local_regs));
	//
	// determine which register that we can overwrite
	//
	R_Opnd base_reg(opnd.base_reg), index_reg(opnd.index_reg);
	R_Opnd *tmp;
	if (local_regs & (1<<opnd.base_reg)) // base is a local reg
		tmp = &base_reg;
	else
		tmp = &index_reg;
	//
	// mov eax, [eax + ecx*s]
	// mov [esp+off], eax
	//
#ifdef _CSE
	reg_manager.update_reg_info(tmp->reg_no());
#endif
	emitter.emit_mov(tmp,&opnd);
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),tmp);
	free_opnd(&reg_manager);
	return 1;
}
//
// for 64 bit array access with 2 caller-save reg.  We can spill the array operand
// without any extra register, e.g.,
//
//		[eax + ecx*8]  ===>   lea eax, [eax + ecx*8]
//	                          mov ecx, [eax] 
//                            mov [esp+off], ecx      // spill lo 32 bits
//                            mov ecx, [eax+4]
//                            mov [esp+off+4], ecx    // spill hi 32 bits
//
int Array_Operand::spill64_hi(Code_Emitter& emitter,Register_Manager& reg_manager,
							  Frame& frame,unsigned depth) {
	unsigned local_regs = reg_manager.local_regs();
	if (!(local_regs & (1<<opnd.base_reg)) || // if one of them is not a local reg
		!(local_regs & (1<<opnd.index_reg)) )
		return 0;
	R_Opnd tmp1(opnd.base_reg), tmp2(opnd.index_reg);
	emitter.emit_lea(&tmp1,&opnd);
	emitter.emit_mov(&tmp2,&M_Base_Opnd(opnd.base_reg,0));
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),&tmp2);
	// we don't free_opnd until spill64_hi
	return 1;
}
int Array_Operand::spill64_lo(Code_Emitter& emitter,Register_Manager& reg_manager,
							  Frame& frame,unsigned depth){
	R_Opnd tmp(opnd.index_reg);
	emitter.emit_mov(&tmp,&M_Base_Opnd(opnd.base_reg,-4));
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),&tmp);
	free_opnd(&reg_manager);
	return 1;
}
void Array_Operand::home32(Code_Emitter& emitter,Register_Manager& reg_manager,
						   Frame& frame,unsigned depth){
	Reg_Operand *reg = reg_manager.get_reg();
	// 
	// mov ecx, [eax + 4]
	// mov [esp+off], ecx
	//
	emitter.emit_mov(&reg->opnd,&opnd);
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),&reg->opnd);
	free_opnd(&reg_manager);
	reg->free_opnd(&reg_manager);
}
void Array_Operand::home64_hi(Code_Emitter& emitter,Register_Manager& reg_manager,
							  Frame& frame,unsigned depth){
	if (reg_manager.has_available_reg()) 
		home32(emitter,reg_manager,frame,depth);
	else {
		//
		// The case that base and index regs are caller-saved can never happen here because
		// we will spill the operand to free up registers before homing the operand.
		//
		X86_Reg_No r = pick_a_callee_reg();
		R_Opnd callee(r);
		//
		// mov off+4[esp], esi  -- high 32 bit location as a spill area for callee
		// mov esi, [eax + 4]
		// mov off[esp], esi
		// mov esi, off+4[esp]
		//
		M_Spill_Opnd hi(frame,depth+1);
		emitter.emit_mov(&hi,&callee);
		emitter.emit_mov(&callee,&opnd);
		emitter.emit_mov(&M_Spill_Opnd(frame,depth),&callee);
		emitter.emit_mov(&callee,&hi);
		free_opnd(&reg_manager);
	}
}
void Static_Operand::home32(Code_Emitter& emitter,Register_Manager& reg_manager,
							Frame& frame,unsigned depth){
	Reg_Operand *reg = reg_manager.get_reg();
	emitter.emit_mov(&reg->opnd,&opnd);
	emitter.emit_mov(&M_Spill_Opnd(frame,depth),&reg->opnd);
	reg->free_opnd(&reg_manager);
}



