// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/fp_compatibility.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//


#ifndef _FP_COMPATIBILITY_H_
#define _FP_COMPATIBILITY_H_

class Stack;
class Code_Emitter;

void set_fpu_control_word(Code_Emitter& emitter,
                          Stack&        stack,
                          Pre_Alloc_Operand_Pool& op_pool,
                          bool          is_dbl);


void restore_old_fpu_control_word(Code_Emitter& emitter,
                                  Stack&        stack,
                                  Pre_Alloc_Operand_Pool& op_pool,
                                  bool          is_dbl);

void fp_strict_op(Code_Emitter& emitter,
                  X86_FP_Opcode opc,
                  Mem_Operand   *m_src1,
                  Mem_Operand   *m_src2,
                  bool          is_dbl);

void fp_remainder(Code_Emitter& emitter,
                  Stack&        stack,
			      Pre_Alloc_Operand_Pool& op_pool,
                  Mem_Operand   *m_src1,
                  Mem_Operand   *m_src2,
                  bool          is_dbl);

void fp_remainder_loop(Code_Emitter& emitter,
                       Stack&        stack);

void gen_fp(Code_Emitter&  emitter,
            X86_FP_Opcode  opc,
            bool           is_dbl,
            Stack&         stack,
            Mem_Manager&   mem_manager,
            Frame&         frame,
            Pre_Alloc_Operand_Pool& op_pool);

void load_onto_fp_stack(Stack&  stack, 
                        Operand *src,
                        bool    is_dbl);

void result_on_fp_stack(Mem_Manager& mem_manager, 
                        Stack&       stack, 
                        bool         is_dbl);

void store_double(Code_Emitter& emitter,
                  Frame&        frame,
                  Stack&        stack,
                  unsigned      index,
                  Operand       *src_lo,
                  Operand       *src_hi);

void load_double(Code_Emitter& emitter,
                 Frame&        frame,
                 Stack&        stack,
                 Mem_Manager&  mem,
                 unsigned      index);
//
// USE_FP_COMPATIBILITY should be removed (always true) later.  I keep it 
// purely for the sake of debugging so I can easily roll back to the 
// state where all results of fp operations are stored back to memory.
//
#define USE_FP_COMPATIBILITY true

#endif // _FP_COMPATIBILITY_H_

