// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_constant.cpp,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//

#include "defines.h"
#include "jit_intf.h"
#include "jit_runtime_support.h"
#include <iostream.h>
#include <stdarg.h>
#include "code_emitter.h"
#include "data_emitter.h"
#include "operand.h"
#include "register_manager.h"
#include "stack.h"
#include "lazy_code_selector.h"
#include "cg_constant.h"

// Given a CP index of a constant, return the constant type along
// with its value. 'valueBuffAddr' points to a buffer large enough
// to hold a double/long value (if the constant is a string, only
// the type JAVA_TYPE_STRING is returned).

static Java_Type getConstantValue (
                    Class_Handle  classHandle,    /* IN  */
                    unsigned      CPindex,        /* IN  */
                    void *        valueBuffAddr)  /* OUT */
{
    Java_Type t = class_get_const_type(classHandle, CPindex);

    if(t == JAVA_TYPE_STRING) {
        return JAVA_TYPE_STRING;
    } else {
        const uint32 *a = (const uint32 *)class_get_const_addr(classHandle, CPindex);
        uint32 *dst = (uint32 *)valueBuffAddr;
        *dst = *a;
        if(t == JAVA_TYPE_DOUBLE || t == JAVA_TYPE_LONG)
            *++dst = *++a;
        return t;
    }
}

void gen_ldc(Data_Emitter& data_emitter,
			 Code_Emitter& emitter,
			 Stack& stack,Mem_Manager& mem_manager,
			 Code_Patch *& code_patch_list,
			 Class_Handle class_handle,unsigned index,
			 Jit_Method_Info *method_info) {
	Value	val;
	Java_Type type = getConstantValue(class_handle,index,&val);
	switch (type) {
	case JAVA_TYPE_STRING:
		{
			stack.call_home(0); 
			Imm_Operand idx(index);
			Imm_Operand cls((int)class_handle);
			idx.emit_push(emitter,0);
			make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
			cls.emit_push(emitter,1);
			make_esp_record(emitter.get_offset(),2,method_info,mem_manager);
			void *addr = orp_get_rt_support_addr(ORP_RT_LDC_STRING);
			unsigned patch_offset = emitter.get_offset()+1;
            method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
            method_info->cs_info[method_info->cnt].returns_ref = 1;
			emitter.emit_call((char *)addr);
			method_info->cs_info[method_info->cnt].ret_IP = emitter.get_offset();
            method_info->cs_info[method_info->cnt].outarg_bv = 0;
            method_info->cs_info[method_info->cnt].m_handle = NULL;
			method_info->cs_info[method_info->cnt++].num_out_args = 2;
			code_patch_list = 
				new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
			stack.push(stack.reg_manager.get_reg(eax_reg));
		}
		break;
	case JAVA_TYPE_INT:
		stack.push(new(mem_manager) Imm_Operand(val.i));
		break;
	case JAVA_TYPE_FLOAT:
		{
			Data_Label *l = data_emitter.make_label();
			data_emitter.emit_float(val.f);
			stack.push(new(mem_manager) Static_Operand(l, &data_emitter));
			break;
		}
	case JAVA_TYPE_DOUBLE:
		{
			Data_Label *lo = data_emitter.make_label();
			Data_Label *hi = data_emitter.make_label();
			hi->offset += 4;
			data_emitter.emit_double(val.d);
			stack.push(new(mem_manager) Static_Operand(hi, &data_emitter));
			stack.push(new(mem_manager) Static_Operand(lo, &data_emitter));
			break;
		}
	case JAVA_TYPE_LONG:
		stack.push(new(mem_manager) Imm_Operand(val.l.hi));
		stack.push(new(mem_manager) Imm_Operand(val.l.lo));
		break;

	}
}

