// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/bounds_checking.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//


#ifndef _BOUNDS_CHECKING_H_
#define _BOUNDS_CHECKING_H_

#include <assert.h>

#define MAX_BOUNDS_ENTRY 16  // must be a power of 2
class Bounds_Checking {
	int _var_base[MAX_BOUNDS_ENTRY]; // var that hold array base
	int _bound[MAX_BOUNDS_ENTRY];
	int _scratch_bound[n_reg]; // for eax, ecx, edx, ...
public:
	Bounds_Checking() {reset();}
	void reset() {
		int i;
		for(i = 0; i < MAX_BOUNDS_ENTRY; i++) {
			_var_base[i] = _bound[i] = -1;
		}
		for(i = 0; i < n_reg; i++) 
			_scratch_bound[i] = -1;
	}
	void reset(int var_no) {
		int idx = var_no & (MAX_BOUNDS_ENTRY-1);
		if (_var_base[idx] == var_no) {
			_var_base[idx] = _bound[idx] = -1; 
		}
	}
	//
	// update var_no entry if bnd is greater than the current bound
	//
	void record(int var_no,int bnd) {
		if (var_no < 0) return;
		int idx = var_no & (MAX_BOUNDS_ENTRY-1);
		if (_var_base[idx] != var_no) {
			_var_base[idx] = var_no;
			_bound[idx] = bnd;
		} else if (_bound[idx] < bnd)
			_bound[idx] = bnd;
	}
	int array_bound(int var_no) {
		if (var_no < 0) return -1;
		int idx = var_no & (MAX_BOUNDS_ENTRY-1);
		if (_var_base[idx] == var_no)
			return _bound[idx];
		else 
			return -1;
	}
	void set_scratch_bound(X86_Reg_No no, unsigned bnd) {
		_scratch_bound[no] = bnd;
	}
	int  scratch_bound(X86_Reg_No no) {return _scratch_bound[no];}
	// propagate bound info from "from" to "to"
	void propagate(X86_Reg_No to, X86_Reg_No from) {
		assert(to < n_reg && from < n_reg);
		_scratch_bound[to] = _scratch_bound[from];
	}
};

#endif // _BOUNDS_CHECKING_H_
