#include <gtk/gtk.h>
#include "gui_tools.h"

#include <stdio.h>
#include <string.h>

extern GtkWidget *tl;

GtkWidget * guitl_tab_add_entry(table , label , col , row , passw)
GtkWidget *table;
char *label;
guint col;
guint row;
guint passw;
{
	GtkWidget *entry , *labelw;

	labelw = gtk_label_new(label);
	gtk_misc_set_alignment(GTK_MISC(labelw) , 0 , 0.5);
	gtk_table_attach(GTK_TABLE(table), labelw , col , col + 1 , row , row + 1 ,
			GTK_FILL | GTK_SHRINK , GTK_FILL,  2 , 5);
	gtk_widget_show(labelw);

	entry = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), entry , col + 1, col + 2 , row , row + 1 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL,  2 , 5);
	if (passw)
		gtk_entry_set_visibility(GTK_ENTRY(entry) , FALSE);
	gtk_widget_show(entry);

	return entry;
}

GtkWidget * guitl_tab_add_combo(table, label, entrys, col, row, edit)
GtkWidget *table;
char *label;
GList *entrys;
guint col;
guint row;
guint edit;
{
	GtkWidget *entry , *labelw;

	labelw = gtk_label_new(label);
	gtk_misc_set_alignment(GTK_MISC(labelw) , 0 , 0.5);
	gtk_table_attach(GTK_TABLE(table), labelw , col , col + 1 , row , row + 1 ,
			GTK_FILL | GTK_SHRINK , GTK_FILL,  2 , 5);
	gtk_widget_show(labelw);

	entry = gtk_combo_new();
	gtk_table_attach(GTK_TABLE(table), entry , col + 1, col + 2 , row , row + 1 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL,  2 , 5);
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(entry)->entry), edit);

	gtk_combo_set_popdown_strings(GTK_COMBO(entry), entrys);


	gtk_widget_show(entry);

	return entry;
}
GtkWidget *guitl_pixmap_button(pm, label)
char **pm;
char *label;
{
	GtkWidget *btn;

	if (pm)
	{
		GtkWidget *pixmap=NULL;
		GdkPixmap *pmp;
		GdkBitmap *mask;
		GtkWidget *box;
		GtkWidget *lbl;

		btn = gtk_button_new();

		pmp = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(tl)->window , &mask , NULL , pm);

		if (pmp)
			pixmap = gtk_pixmap_new(pmp , mask);

		box = gtk_hbox_new(FALSE , 1);
		gtk_container_add(GTK_CONTAINER(btn) , box);
		gtk_widget_show(box);

		gtk_box_pack_start(GTK_BOX(box) , pixmap , TRUE , TRUE , 0);
		gtk_misc_set_alignment(GTK_MISC(pixmap) , 1.0 , 0.5);
		gtk_widget_show(pixmap);

		lbl = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(lbl) , 0.0 , 0.5);
		gtk_box_pack_start(GTK_BOX(box) , lbl , TRUE , TRUE , 0);
		gtk_widget_show(lbl);
		
	}
	else
	{
		btn = gtk_button_new_with_label(label);
	}

	return btn;
}

void guitl_CloseWin(b ,w)
GtkWidget *b;
GtkWidget *w;
{
	gtk_widget_destroy(w);
}

static void guitl_clist_swap_col_widgets(clist, col1, col2)
GtkWidget *clist;
int col1;
int col2;
{
	GtkWidget *cw1,*cw2;
	GtkWidget *ch1,*ch2;
	GtkWidget *tmp;

	ch1 = gtk_clist_get_column_widget(GTK_CLIST(clist), col1);
	ch2 = gtk_clist_get_column_widget(GTK_CLIST(clist), col2);

	cw1 = GTK_WIDGET(ch1)->parent;
	cw2 = GTK_WIDGET(ch2)->parent;

	tmp = gtk_button_new();

	gtk_widget_reparent(ch1, tmp);
	gdk_flush();
	gtk_widget_reparent(ch2, cw1);
	gdk_flush();
	gtk_widget_reparent(ch1, cw2);
	gdk_flush();

	gtk_widget_destroy(tmp);
}

void guitl_clist_swap_cols(clist, col1, col2)
GtkWidget *clist;
int col1;
int col2;
{
	char *p1,*p2;
	int i;

	if (GTK_CLIST(clist)->columns <= col1 ||
	    GTK_CLIST(clist)->columns <= col2)
		return;

	gtk_clist_freeze(GTK_CLIST(clist));

	guitl_clist_swap_col_widgets(clist, col1, col2);

	for (i = 0; i < GTK_CLIST(clist)->rows; i++)
	{
		if (gtk_clist_get_text(GTK_CLIST(clist), i, col1, &p1))
			p1 = g_strdup(p1);
		else
			p1 = NULL;
		if (gtk_clist_get_text(GTK_CLIST(clist), i, col2, &p2))
			p2 = g_strdup(p2);
		else
			p2 = NULL;
		gtk_clist_set_text(GTK_CLIST(clist), i, col2, p1);
		gtk_clist_set_text(GTK_CLIST(clist), i, col1, p2);
		g_free(p1);
		g_free(p2);
	}

	gtk_clist_thaw(GTK_CLIST(clist));
}

static void guitl_tlist_swap_row_cols(tree, node, cols)
GtkCTree *tree;
GtkCTreeNode *node;
int *cols;
{
	char *p1 = NULL,*p2 = NULL;

	if (gtk_ctree_node_get_text(GTK_CTREE(tree), node, cols[0], &p1))
		p1 = g_strdup(p1);
	if (gtk_ctree_node_get_text(GTK_CTREE(tree), node, cols[1], &p2))
		p2 = g_strdup(p2);
	gtk_ctree_node_set_text(GTK_CTREE(tree), node, cols[1], p1);
	gtk_ctree_node_set_text(GTK_CTREE(tree), node, cols[0], p2);
	g_free(p1);
	g_free(p2);
}

void guitl_tlist_swap_cols(tlist, nodes, col1, col2)
GtkWidget *tlist;
GSList *nodes;
int col1;
int col2;
{
	int cols[2],*colsp;

	colsp = cols;

	cols[0] = col1;
	cols[1] = col2;

	gtk_clist_freeze(GTK_CLIST(tlist));

	guitl_clist_swap_col_widgets(tlist, col1, col2);

	while (nodes)
	{
		GtkCTreeNode *node = (GtkCTreeNode *)nodes->data;
		gtk_ctree_post_recursive(GTK_CTREE(tlist), node,
			GTK_CTREE_FUNC(guitl_tlist_swap_row_cols), colsp);

		nodes = nodes->next;
	}

	gtk_clist_thaw(GTK_CLIST(tlist));
}
