/* 
 * Based on code from http://www.javaonthebrain.com/java/puzz15/
 */


import java.util.*;

public class Puzzle15Model {

	//private int seed = (int)System.currentTimeMillis() & 0xffffff;
	private Random random = new Random(System.currentTimeMillis());
	private int subgoals[] = {1, 0, 2, 0, 3, 4, 0, 5, 0, 6, 0, 7, 8, 0, 9, 13,
			0, 10, 14, 0, 11, 12, 15, 0, 16};
	private int detour1[] = {11, 10, 6, 7, 11, 10, 6, 7, 3, 2, 6, 7, 11, -1};
	private int detour2[] = {15, 14, 10, 11, 15, 14, 10, 11, 7, 6, 10, 11, 15,
			-1};
	private int detour3[] = {6, 2, 3, 7, -1};
	private int detour4[] = {3, 7, -1};
	private int detour5[] = {10, 6, 7, 11, -1};
	private int detour6[] = {7, 11, -1};
	private int detour7[] = {13, 12, 8, 9, -1};
	private int detour8[] = {8, 9, -1};
	private int detour9[] = {10, 14, 13, 9, 10, 14, 13, 9, 8, 12, 13, 9, 10,
			-1};
	private int detour10[] = {14, 13, 9, 10, -1};
	private int detour11[] = {9, 10, -1};
	private int detour12[] = {11, 15, 14, 10, 11, 15, 14, 10, 9, 13, 14, 10,
			11, -1};
	private int roundabout[] = {11, 10, 14, 15, -1};
	private int roundDisp[] = {-4, -3, 1, 5, 4, 3, -1, -5, -4, -3, 1, 5, 4,
			3, -1, -5, -4, -3, 1, 5, 4, 3, -1, -5, -4};
	private int rounddx[] = {0, 1, 1, 1, 0, -1, -1, -1, 0, 1, 1, 1, 0, -1, -1,
			-1, 0, 1, 1, 1, 0, -1, -1, -1, 0};
	
	private int moves[] = new int[400];
	private int holder[] = new int[20];
	private int moveNum = 0;
	private int moveCount = 0;
	private int map[] = new int[6 * 6];
	private int ppath[] = new int[9];

	private List moveListeners = new ArrayList();

	public Puzzle15Model() {
		for (int i = 0; i < 6; i++) {
			map[i] = 1;
			map[i * 6] = 1;
		}
		for (int i = 0; i < 4; i++) {
			for (int j = 0; j < 4; j++) {
				map[7 + i * 6 + j] = (i * 4 + j + 1)  &15;
			}
		}
		resetMap();
	}
	
	private void resetMap( )
	{
		for (int i = 0; i < 4; i++) {
			for (int j = 0; j < 4; j++) {
				int k = 0;
				if (map[i * 6 + j] > 0)
					k += 2;
				if (map[1 + i * 6 + j] > 0)
					k += 1;
				if (map[6 + i * 6 + j] > 0)
					k += 4;
			}
		}
	}

	public int get( int h, int v )
	{
		return map[7 + h + 6 * v];
	}

	public int set( int h, int v, int value )
	{
		int index = 7 + h + 6 * v;
		int oldValue = map[index];
		map[index] = value;
		return oldValue;
	}

	public void setSeed( long seed )
	{
		random.setSeed(seed);
		//this.seed = (int)seed;
	}

	public void move(int h, int v) {
		int toH = h, toV = v;
		if (h > 0 && get(h - 1, v) == 0) {
			toH = h - 1;
		} else if (h < 3 && get(h + 1, v) == 0) {
			toH = h + 1;
		} else if (v > 0 && get(h, v - 1) == 0) {
			toV = v - 1;
		} else if (v < 3 && get(h, v + 1) == 0) {
			toV = v + 1;
		} else {
			return;
		}
		map[7 + toH + 6 * toV] = map[7 + h + 6 * v];
		map[7 + h + 6 * v] = 0;
		notifyMoveListeners(h, v, toH, toV, ++moveNum);
	}

	public void addMoveListener(MoveListener listener) {
		moveListeners.add(listener);
	}

	public void removeMoveListener(MoveListener listener) {
		moveListeners.remove(listener);
	}

	public void notifyMoveListeners(int fromH, int fromV, int toH, int toV,
			int moveNbr) {
		for (Iterator i = moveListeners.iterator(); i.hasNext(); ) {
			MoveListener listener = (MoveListener)i.next();
			listener.moved(fromH, fromV, toH, toV, moveNbr);
		}
	}

	private void getNextMove(MoveHandler handler) {
		while (moveNum < moveCount) {
			if (Thread.interrupted())
				break;
			int j = moves[moveNum];
			int i = j / 4;
			j &= 3;
			move(j, i);
			if (handler != null) {
				handler.handleMove(j, i, moveNum);
			}
		}
	}

	// Called from the outside. Compute solution and put in queue.
	public void solve(MoveHandler handler) {
		boolean detour;
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				holder[i * 4 + j] = get(j, i);
		int goalsDone = 0;
		int i = 0;
		int j = 0;
		while (holder[subgoals[i] - 1] == subgoals[i]) {
			i++;
			if (subgoals[i] == 0) {
				j = i;
				goalsDone++;
				i++;
			}
		}
		for (i = 0; i < j; i++) // Lock the already finished ones
			if (subgoals[i] > 0)
				holder[subgoals[i] - 1] = -1;
		moveCount=0;
		while (goalsDone < 9) {
			switch (goalsDone) {
				case 0:
					moveTo(1, 0);
					break;
				case 1:
					moveTo(2, 1);
					break;
				case 2:
					moveTo(3, 3);
					holder[3] = -1;
					i = locate(0);
					detour = false;
					if (i == 7) {
						if (holder[2] == 4) { // Darn!
							makeDetour(detour3, 7);
							detour = true;
						}
					} else if (i == 2) {
						if (holder[6] == 4) { // Darn!
							makeDetour(detour4, 2);
							detour = true;
						}
					} else {
						if (holder[2] == 4) {
							moveTo(4, 6);
							makeDetour(detour4, 2);
							detour = true;
						}
					}
					if (detour)
						makeDetour(detour1, 7);
					else
						moveTo(4, 7);
					holder[3] = 3;
					holder[7] = -1;
					moveTo(3, 2);
					holder[7] = 4;
					moveTo(4, 3);
					break;
				case 3:
					moveTo(5, 4);
					break;
				case 4:
					moveTo(6, 5);
					break;
				case 5:
					moveTo(7, 7);
					holder[7] = -1;
					i = locate(0);
					detour = false;
					if (i == 11) {
						if (holder[6]==8) { // Darn!
							makeDetour(detour5, 11);
							detour = true;
						}
					} else if (i == 6) {
						if (holder[10]==8) { // Darn!
							makeDetour(detour6, 6);
							detour = true;
						}
					} else {
						if (holder[6] == 8) {
							moveTo(8, 10);
							makeDetour(detour6, 6);
							detour = true;
						}
					}
					if (detour)
						makeDetour(detour2, 11);
					else
						moveTo(8, 11);
					holder[7] = 7;
					holder[11] = -1;
					moveTo(7, 6);
					holder[11] = 8;
					moveTo(8, 7);
					break;
				case 6:
					moveTo(13, 8);
					holder[8] = -1;
					i = locate(0);
					detour = false;
					if (i == 9) {
						if (holder[12]==9) { // Darn!
							makeDetour(detour7, 9);
							detour = true;
						}
					} else if (i == 12) {
						if (holder[13]==9) { // Darn!
							makeDetour(detour8,12);
							detour=true;
						}
					} else {
						if (holder[12] == 9) {
							moveTo(9, 13);
							makeDetour(detour8, 12);
							detour = true;
						}
					}
					if (detour)
						makeDetour(detour9, 9);
					else
						moveTo(9, 9);
					holder[8] = 13;
					holder[9] = -1;
					moveTo(13, 12);
					holder[9] = 9;
					moveTo(9, 8);
					break;
				case 7:
					moveTo(14, 9);
					i = locate(0);
					detour = false;
					if (i == 10) {
						if (holder[13] == 10) { // Darn!
							makeDetour(detour10, 10);
							detour = true;
						}
					} else {
						if (holder[14]==10) { // Darn!
							makeDetour(detour11, 13);
							detour = true;
						}
					}
					if (detour)
						makeDetour(detour12, 10);
					else
						moveTo(10, 10);
					holder[9] = 14;
					holder[10] = -1;
					moveTo(14, 13);
					holder[10] = 10;
					moveTo(10, 9);
					break;
				case 8:
					while (holder[15] != 0) {
						if (holder[10] == 0) {
							moves[moveCount++] = 11;
							holder[10] = holder[11];
							holder[11] = 0;
						}
						if (holder[11] == 0) {
							moves[moveCount++] = 15;
							holder[11] = holder[15];
							holder[15] = 0;
						}
						if (holder[14] == 0) {
							moves[moveCount++] = 15;
							holder[14] = holder[15];
							holder[15] = 0;
						}
					}
					while (holder[14] != 15)
						makeDetour(roundabout, 15);
					break;
			}
			goalsDone++;
		}
		if (moveCount > 0) {
			moveNum = 0;
			getNextMove(handler);
		}
	}

	public void makeDetour(int dList[], int hole) {
		int i=0;
		int j=hole;
		while (dList[i] >= 0) {
			holder[j] = holder[dList[i]];
			holder[dList[i]] = 0;
			j = dList[i];
			moves[moveCount++] = dList[i++];
		}
	}

	// Move piece p to target position t
	public void moveTo(int p, int t) {
		int i = locate(p);
		int whereNow = i;
		int j = 0;
		while ((i & 3) != (t & 3)) {
			if ((i & 3) < (t & 3))
				i++;
			else
				i--;
			ppath[j++] = i;
		}
		while (i>t) {
			i -= 4;
			ppath[j++] = i;
		}
		holder[whereNow] = -1;
		for (i = 0; i < j; i++) {
			moveHole(ppath[i], whereNow);
			moves[moveCount++] = whereNow;
			holder[whereNow] = 0;
			holder[ppath[i]] = -1;
			whereNow = ppath[i];
		}
	}

	// Move hole to target position
	public void moveHole(int tg, int ppos)  {
		int i = locate(0);
		// First phase: reach neighborhood of target piece
		while (Math.abs((i & 3) - (ppos & 3)) > 1 ||
				Math.abs((i / 4) - (ppos / 4)) > 1) {
			int k;
			if ((i & 3)<(tg & 3) && holder[i+1] > 0)
				k = i+1;
			else if ((i & 3)>(tg & 3) && holder[i-1] > 0)
				k = i-1;
			else if ((i / 4) < (tg / 4) && holder[i+4] > 0)
				k = i+4;
			else
				k = i-4;
			moves[moveCount++] = k;
			holder[i] = holder[k];
			holder[k] = 0;
			i = k;
		}
		// Second phase: take shortest path clockwise or counter-clockwise
		if (i != tg) {
			int posCount = 0, negCount = 0;
			int j = 8;
			while (i != ppos + roundDisp[j])
				j++;
			int k = j;
			while (ppos + roundDisp[k] != tg) {
				k++;
				if (ppos + roundDisp[k] >= 0 &&
						ppos + roundDisp[k] < 16 &&
						(ppos & 3) + rounddx[k] < 4 &&
						(ppos & 3) + rounddx[k] >= 0 &&
						holder[ppos + roundDisp[k]] > 0)
					posCount++;
				else
					posCount += 50;
			}
			k = j;
			while (ppos + roundDisp[k] != tg) {
				k--;
				if (ppos + roundDisp[k] >= 0 &&
						ppos + roundDisp[k] < 16 &&
						(ppos & 3) + rounddx[k] < 4 &&
						(ppos & 3) + rounddx[k] >= 0 &&
						holder[ppos + roundDisp[k]] > 0)
					negCount++;
				else
					negCount+=50;
			}
			int l = posCount <= negCount ? 1 : -1;
			while (i != tg) {
				j += l;
				k = ppos + roundDisp[j];
				moves[moveCount++] = k;
				holder[i] = holder[k];
				holder[k] = 0;
				i = k;
			}
		}
	}
	
	private int locate(int num) {
		int li = 0;
		while (holder[li] != num)
			li++;
		return li;
	}

	public void scramble() {
		for (int i =0; i < 4; i++)
			for (int j = 0;  j< 4; j++)
				map[7 + i * 6 + j] = (i * 4 + j + 1) & 15;
		for (int i = 0; i < 16; i++) {
			//int l = (randi() >> 5) % 15;
			int l = random.nextInt(15);
			int j = 7 + 6 * (l / 4) + (l & 3);
			//l = (randi() >> 5) % 15;
			l = random.nextInt(15);
			int k = 7 + 6 * (l / 4) + (l & 3);
			while (k == j) {
				//l = (randi() >> 5) % 15;
				l = random.nextInt(15);
				k = 7 + 6 * (l / 4) + (l & 3);
			}
			l = map[k];
			map[k] = map[j];
			map[j] = l;
		}
		resetMap();
		moveNum = 0;
	}

	/*
	private int randi() {
		//return seed = (seed *171) % 30269;
		return random.nextInt(30269);
	}
	*/

	public void print() {
		System.out.println("------------");
		lines(new LineHandler() {
			public void handleLine(String line) {
				System.out.println(line);
			}
		});
	}

	public void lines(LineHandler lineHandler) {
		for (int row = 0; row < 4; ++row) {
			StringBuffer sb = new StringBuffer();
			for (int col = 0; col < 4; ++col) {
				int v = get(col, row);
				sb.append(v < 10 ? "  " : " ").
						append(v == 0 ? " " : Integer.toString(v));
			}
			lineHandler.handleLine(sb.toString());
		}
	}

	public interface LineHandler {

		public void handleLine(String line);

	}

	public interface MoveHandler {

		public void handleMove(int h, int v, int moveNum);

	}

	public interface MoveListener {

		public void moved(int fromH, int fromV, int toH, int toV, int moveNbr);

	}

}
