/*
 * Copyright 2006 Ricoh Corporation.
 *
 * @@@ ApacheLicenseV2 @@@
 * @@@ RiDPSupport @@@
 */

import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.text.*;

import jp.co.ricoh.dsdk.function.*;
import jp.co.ricoh.dsdk.function.scan.*;
import jp.co.ricoh.dsdk.function.scan.attribute.*;
import jp.co.ricoh.dsdk.function.scan.attribute.standard.*;
import jp.co.ricoh.dsdk.function.scan.event.*;
import jp.co.ricoh.dsdk.panel.*;
import jp.co.ricoh.dsdk.panel.event.*;
import jp.co.ricoh.dsdk.util.image.*;
import jp.co.ricoh.dsdk.xlet.*;

import jp.co.ricoh.dsdk.framework.panel.*;
import jp.co.ricoh.dsdk.framework.panel.scan.*;
import jp.co.ricoh.dsdk.framework.scan.*;
import jp.co.ricoh.dsdk.framework.util.*;

import ricoh.dsdk.uiwidgets.*;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.methods.multipart.*;
import org.apache.commons.httpclient.params.*;

public class FormBrowser extends ScanningXlet
{
	private File uploadedPdf = null;

	String		submitButtonName;
	String		uploadItemName;

	HttpClient	httpClient = new HttpClient();
	URL		urlContext = null;
	URL		expenseHomeURL;
	XHTMLForm	pageForm = null;


	public synchronized void initXlet(XletContext context)
		throws XletStateChangeException
	{
		super.initXlet(context);

		String[] args = (String[]) context.getXletProperty(XletContext.ARGS);
		String str = "http://127.0.0.1:8080/UploadAndPrint/Login";
		if (args != null && args.length > 0)
		{
			str = args[0];
		}
		try
		{

			CheckboxControl.setIcons(
				new ImageIcon(this.getClass().getResource("checkbox.bmp")),
				new ImageIcon(this.getClass().getResource("uncheckedCheckbox.bmp"))  );
			RadioGroupControl.setIcons(
				new ImageIcon(this.getClass().getResource("radioButton.bmp")),
				new ImageIcon(this.getClass().getResource("emptyRadioButton.bmp"))  );


			createGUI(str);

		}
		catch (Exception e)
		{
			throw new XletStateChangeException();
		}
	}


	public synchronized void startXlet() throws XletStateChangeException
	{
		super.startXlet();
	}




	public synchronized void pauseXlet()
	{
		super.pauseXlet();
	}

	public synchronized void destroyXlet(boolean force)
		throws XletStateChangeException
	{
		super.destroyXlet(force);


		try
		{
			if(uploadedPdf != null)
			{
				uploadedPdf.delete();
			}

		}
		catch (Exception e)
		{
		}

	}

	private void printDirectoryContents(String directoryName)
	{
		System.err.println("Children of directory " + directoryName + ":");
		File dir = new File(directoryName);

		String[] children = dir.list();
		if (children == null)
		{
			// Either dir does not exist or is not a directory
		}
		else
		{
			for (int i=0; i<children.length; i++)
			{
				// Get filename of file or directory
				System.err.println("    " + children[i]);
			}
		}
	}

	public String getURLInContext(String url) throws MalformedURLException
	{
		String result = url;

		if(urlContext != null)
		{
			result = new URL(urlContext, url).toString();
			System.err.println("### Context is " + urlContext.toString() + ", spec is " + url + " and result is " + result);
		}

		return result;
	}

	private void createGUI(String formPageURL)
	{
		try
		{
			//createGUI(session.openConnection(formPageURL));
			URI testURI = new URI(formPageURL, false);
			System.err.println("test URI is " + testURI.toString());
			HostConfiguration testHostConfiguration = new HostConfiguration();
			testHostConfiguration.setHost(testURI);
			System.err.println("test host config is " + testHostConfiguration.toString());
			httpClient.setHostConfiguration(testHostConfiguration);
			createGUI(new GetMethod(this.getURLInContext(formPageURL)));
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	private void createGUI(HttpMethod theMethod)
	{
		try
		{
			//
			// Load the page form named "Main".
			//
			int status = httpClient.executeMethod(theMethod);
			InputStream inStream = theMethod.getResponseBodyAsStream();
			urlContext = new URL(new URL(httpClient.getHostConfiguration().getHostURL()), theMethod.getPath());
			System.err.println("Set url context to " + urlContext.toString());
			pageForm = XHTMLFormFactory.loadForm(urlContext.toString(), inStream, "Main");
			inStream.close();
			theMethod.releaseConnection();

			createGUI();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	private void createGUI(URLConnection theConnection)
	{
		try
		{
			//
			// Load the page form named "Main".
			//
			pageForm = XHTMLFormFactory.loadForm(theConnection.getURL().toString(), theConnection.getInputStream(), "Main");
			createGUI();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	private void createGUI()
	{
		try
		{
			rootContainer.removeAll();
			rootContainer.repaint();


			//
			// Create a label at the top of the screen to display the page title
			//
			Label pageTitle = new Label(pageForm.getTitle());
        		pageTitle.setLocation(10, 4);
        		pageTitle.setSize(400, 16);
        		pageTitle.setFont(Font.ALNUM16);

			rootContainer.add(pageTitle);

			//
			// Display a label at the bottom of the screen to display the page message (if any)
			//
			Label pageMessage = new Label(pageForm.getMessage());
        		pageMessage.setLocation(10, 140);
        		pageMessage.setSize(580, 16);
        		pageMessage.setFont(Font.F12);

			rootContainer.add(pageMessage);

			//
			// Make our widgets...
			//
			WidgetsFromFormFactory.createWidgetsFromFormFactory(rootContainer, pageForm, 10, 24, 620, 140);

			//
			// Make the submit buttons
			//
			Iterator submitButtonIter = pageForm.getSubmitButtonLabels().iterator();
			int xPosition = 180;
			while(submitButtonIter.hasNext())
			{
				String submitButtonLabel = (String)submitButtonIter.next();

				System.err.println("Create a dsdk button for submit button labeled " + submitButtonLabel);

				// create a dsdk button for each form submit button

				Button submitButton = new Button(submitButtonLabel);
				submitButton.setBounds(xPosition, 170, 80, 16);
				submitButton.addActionListener( new ActionListener()
					{
						public void actionPerformed(ActionEvent e)
						{
							String nameOfButtonClicked = ((Button)e.getSource()).getLabel();

							//
							// TO DO:  If there are multiple submit buttons
							// on the upload page, chances are that not all
							// of them are "UPLOAD" buttons; there might be
							// cancel buttons that do not require a file
							// upload.  If so, we need a way to distinguish
							// them so that we can scan only when uploads
							// are desired.
							//
							// For this simple demo, though, the upload page
							// has but one submit button.
							//
							if(pageForm.hasUploadFileItem())
							{
								//
								// If there are multiple 'upload' items, we
								// should probably allow the user to scan
								// multiple documents.  For now, though, all
								// that we support is uploading to the first
								// upload form item.
								//
								submitButtonName = nameOfButtonClicked;
								uploadItemName = pageForm.getUploadItemNames()[0];
								openStartScanDialog("Press START to scan document to upload.");
							}
							else
							{
								submitAndRedirect(nameOfButtonClicked);
							}
						}
					} );
				xPosition -= 100;
				rootContainer.add(submitButton);
			}

			Button endButton = new Button("Quit");
			endButton.setBounds(520, 200, 60, 16);
			endButton.addActionListener( new ActionListener()
				{
					public void actionPerformed(ActionEvent e)
					{
						endProgram();
					}
				} );
			rootContainer.add(endButton);

			Button settingsButton = new Button("Settings");
			settingsButton.setBounds(440, 200, 60, 16);
			settingsButton.addActionListener( new ActionListener()
				{
					public void actionPerformed(ActionEvent e)
					{
						openScanSettingsDialog();
					}
				} );
			rootContainer.add(settingsButton);

			rootContainer.repaint();

		}
		catch(Exception e)
		{
			System.err.println("Caught an error creating GUI from form " + e.toString());
			e.printStackTrace();
		}


	}

	/**
	 *	Handle a submit button:  submit the form and process any page
	 *	redirects that happen.  Note that it is possible that the server
	 *	might indicate an error condition that is reported via a modal
	 *	dialog that does not change the state of the program; usually,
	 *	though, this routine will throw away all of the controls on the
	 *	main window, load a new form and create new controls for it.
	 */
	protected void submitAndRedirect(String submitLabel)
	{
		try
		{
			System.err.println("About to call submitResponse with submit label = " + submitLabel);

			HttpMethod theMethod = pageForm.getPostMethod(urlContext, submitLabel);

			int status = httpClient.executeMethod(theMethod);

			System.err.println("Headers are:");
			System.err.println(Arrays.asList(theMethod.getResponseHeaders()));

			Header locationHeader = theMethod.getResponseHeader("Location");
			Header validationErrorHeader = theMethod.getResponseHeader("X-Validation-Error");

			int maxHop = 10;
			while((locationHeader != null) && (validationErrorHeader == null) && (maxHop > 0))
			{
				String redirectLocation = locationHeader.getValue();
				System.err.println("Got a redirect location: " + redirectLocation);

				/* byte[] ignoreMethodBodyAfterRedirect = */ theMethod.getResponseBody();
				theMethod.releaseConnection();

				theMethod = new GetMethod(this.getURLInContext(redirectLocation));
				status = httpClient.executeMethod(theMethod);

				locationHeader = theMethod.getResponseHeader("Location");
				validationErrorHeader = theMethod.getResponseHeader("X-Validation-Error");

				--maxHop;
			}

			if(validationErrorHeader != null)
			{
				System.err.println("X-Validation-Error header found");
				FormBrowser.this.showConfirmationDialog(validationErrorHeader.getValue());

				/* byte[] ignoreMethodBodyAfterValidationError = */ theMethod.getResponseBody();
				theMethod.releaseConnection();
			}
			else
			{
				System.err.println("About to load new form");

				InputStream inStream = theMethod.getResponseBodyAsStream();
				urlContext = new URL(new URL(httpClient.getHostConfiguration().getHostURL()), theMethod.getPath());
				System.err.println("Set url context to " + urlContext.toString());
				pageForm = XHTMLFormFactory.loadForm(urlContext.toString(), inStream, "Main");
				inStream.close();
				theMethod.releaseConnection();

				System.err.println("About to call createGUI for new page");
				createGUI();
			}


		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}

	/**
	 *	Terminate this program
	 */
	public void endProgram()
	{
		try
		{
			destroyXlet(true);
			context.notifyDestroyed();
		}
		catch (XletStateChangeException xge) {}
	}

	/**
	 *	Called by processScanEvent when the scan operation comletes successfully.
	 */
	protected void scanEventCompleted()
	{

		//
		// To do:  find scanned images and convert to application / pdf
		//

		try
		{
			//
			// Convert the scanned pages to PDF prior to upload
			//
			// TO DO:   I'm thinking that this code does not maintain the
			// order of the pages; we'll need to sort them or something.
			//
			// Emulator bug:  on emulator 1.14b, this throws an exception:
			// java.lang.NoSuchMethodError: jp.co.ricoh.dsdk.util.image.MultipagePdf:
			// method <init>()V not found.
			//
			// It works fine on an actual MFP, though.
			//
			// Note: A parameterless call to MultipagePdf's constructor is likely
			// to generate compile-time or runtime errors. Use a call with
			// 0,0 specified as inputs instead.
			//
			MultipagePdf pdfDoc = new MultipagePdf(0,0);

			System.err.println("Scan finished, look for files that were scanned");
			String fileName = null;
			File dir = new File(scanImageDir);
			File fileList[] = dir.listFiles();
			for (int i = 0; i < fileList.length; i++)
			{
				fileName = fileList[i].getName();
				System.err.println("one filename is " + fileName);
				pdfDoc.addPage(fileList[i].toString());
			}

			if(fileName != null)
			{
				// To do:  trim off the ".tiff" or ".jpg".
				File uploadedPdf =  new File(scanImageDir, "scan-" + fileName + ".pdf");
				OutputStream out  = new FileOutputStream(uploadedPdf);
				pdfDoc.write(out);
				out.close();

				uploadScannedDocument(uploadedPdf, "application/pdf");
			}
			else
			{
				System.err.println("No scanned documents found");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		closeScanDialogAfterCompletion();
		showConfirmationDialog("Scan completed successfully.");
	}


	// application/pdf
	public void uploadScannedDocument(File scannedDocument, String theContentType)
	{
		try
		{
			System.err.println("Upload scanned document named " + scannedDocument + ", content type " + theContentType);
			pageForm.setUploadFile(uploadItemName, scannedDocument.toString(), theContentType);
			closeScanDialogAfterCompletion();
			System.err.println("Now call submit and redirect '" + submitButtonName + "'");
			this.submitAndRedirect(submitButtonName);

			submitButtonName = null;
			uploadItemName = null;

		}
		catch(Exception e)
		{
			showConfirmationDialog(e.getMessage());
		}
	}

}
