/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * DiagramNavigatorPanel.java
 *
 * Created on December 12, 2005, 10:10 AM
 */

package org.netbeans.modules.uml.drawingarea.navigator;

import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import com.tomsawyer.editor.overview.TSEOverviewComponent;
import java.awt.BorderLayout;
import javax.swing.JComponent;

/**
 *
 * @author  TreySpiva
 */
public class DiagramNavigatorPanel extends javax.swing.JPanel 
{
   private IDrawingAreaControl drawingArea = null;
   private JComponent currentView = null;
   private boolean initializing = false;
   
   /** Creates new form DiagramNavigatorPanel */
   public DiagramNavigatorPanel()
   {
      initComponents();
   }
   
   public void refresh() {
       SwingUtilities.invokeLater(new Runnable() {
           public void run() {
               JComponent view =  getOverviewView();
               if(view != null) {
                   if(currentView != null) {
                       remove(currentView);
                   }                   
                   add(view, BorderLayout.CENTER);
                   currentView = view;
                   invalidate();
                   validate();
               }
           }
       });
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());

    }// </editor-fold>//GEN-END:initComponents
   
   private JComponent getOverviewView()
   {
      JComponent retVal = null;
      if(getDrawingArea() != null)
      {
         ADGraphWindow graphWindow = getDrawingArea().getGraphWindow();
         if(graphWindow != null)
         {
            TSEOverviewComponent overview = new TSEOverviewComponent(graphWindow);
            overview.removeAll();
            overview.setGraphWindow(graphWindow);
            overview.fitInWindow(true);
            overview.setVisible(true);
            overview.setToolEnabled(true);
            retVal = overview;
         }
      }
      
      return retVal;
   }
   
//   private JComponent getStructuralView()
//   {
//      DiagramStructureNavigator view = new DiagramStructureNavigator(getDrawingArea());
//      view.refresh();
//      
//      return view;
//   }

   public IDrawingAreaControl getDrawingArea()
   {
      return drawingArea;
   }

   public void setDrawingArea(IDrawingAreaControl drawingArea)
   {
      this.drawingArea = drawingArea;
   }

//   private JComponent getCategoryView()
//   {
//      DiagramCategoryNavigator view = new DiagramCategoryNavigator(getDrawingArea());
//      view.refresh();
//      return view;
//   } 

       
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
   
}
