/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.api.gsf;

import org.netbeans.api.lexer.TokenId;


/**
 * @todo Rename this class
 * @author Tor Norbye
 */
public class GsfTokenId implements TokenId {
    public static final GsfTokenId ERROR = new GsfTokenId("GSF_ERROR", null, "error");
    public static final GsfTokenId IDENTIFIER = new GsfTokenId("GSF_IDENTIFIER", null, "identifier");
    public static final GsfTokenId CLASS_VAR = new GsfTokenId("GSF_CLASS", null, "staticfield");
    public static final GsfTokenId INSTANCE_VAR = new GsfTokenId("GSF_INSTANCE", null, "field");
    public static final GsfTokenId GLOBAL_VAR = new GsfTokenId("GSF_GLOBAL", null, "static");
    public static final GsfTokenId CONSTANT = new GsfTokenId("GSF_CONSTANT", null, "constant");
    public static final GsfTokenId DOCUMENTATION = new GsfTokenId("GSF_DOCUMENTATION", null, "comment");
    //public static final GsfTokenId ABSTRACT = new GsfTokenId("GSF_ABSTRACT", "abstract", "keyword");
    public static final GsfTokenId INT_LITERAL = new GsfTokenId("GSF_INT_LITERAL", null, "number");
    public static final GsfTokenId REGEXP_LITERAL = new GsfTokenId("GSF_REGEXP_LITERAL", null, "regexp");
    public static final GsfTokenId LONG_LITERAL = new GsfTokenId("GSF_LONG_LITERAL", null, "number");
    public static final GsfTokenId FLOAT_LITERAL = new GsfTokenId("GSF_FLOAT_LITERAL", null, "number");
    public static final GsfTokenId DOUBLE_LITERAL = new GsfTokenId("GSF_DOUBLE_LITERAL", null, "number");
    public static final GsfTokenId CHAR_LITERAL = new GsfTokenId("GSF_CHAR_LITERAL", null, "character");
    public static final GsfTokenId STRING_LITERAL = new GsfTokenId("GSF_STRING_LITERAL", null, "string");
    public static final GsfTokenId WHITESPACE = new GsfTokenId("GSF_WHITESPACE", null, "whitespace");
    public static final GsfTokenId LINE_COMMENT = new GsfTokenId("GSF_LINE_COMMENT", null, "comment");
    public static final GsfTokenId BLOCK_COMMENT = new GsfTokenId("GSF_BLOCK_COMMENT", null, "comment");
    public static final GsfTokenId TODO = new GsfTokenId("GSF_TODO", null, "todo");
    public static final GsfTokenId TYPE_SYMBOL = new GsfTokenId("GSF_TYPESYMBOL", null, "typesymbol");

    public static final GsfTokenId LPAREN = new GsfTokenId("GSF_LPAREN", "(", "separator");
    public static final GsfTokenId RPAREN = new GsfTokenId("GSF_RPAREN", ")", "separator");
    public static final GsfTokenId LBRACE = new GsfTokenId("GSF_LBRACE", "{", "separator");
    public static final GsfTokenId RBRACE = new GsfTokenId("GSF_RBRACE", "}", "separator");
    public static final GsfTokenId LBRACKET = new GsfTokenId("GSF_LBRACKET", "[", "separator");
    public static final GsfTokenId RBRACKET = new GsfTokenId("GSF_RBRACKET", "]", "separator");
    public static final GsfTokenId STRING_BEGIN = new GsfTokenId("GSF_STRING_BEGIN", null, "string");
    public static final GsfTokenId STRING_END = new GsfTokenId("GSF_STRING_END", null, "string");
    public static final GsfTokenId REGEXP_BEGIN = new GsfTokenId("GSF_REGEXP_BEGIN", null, "regexp"); // or separator?
    public static final GsfTokenId REGEXP_END = new GsfTokenId("GSF_REGEXP_END", null, "regexp");
    
    // Errors and incomplete tokens
    public static final GsfTokenId CHAR_LITERAL_INCOMPLETE = new GsfTokenId("GSF_CHAR_LITERAL_INCOMPLETE", null, "character");
    public static final GsfTokenId STRING_LITERAL_INCOMPLETE = new GsfTokenId("GSF_STRING_LITERAL_INCOMPLETE", null, "string");
    public static final GsfTokenId BLOCK_COMMENT_INCOMPLETE = new GsfTokenId("GSF_BLOCK_COMMENT_INCOMPLETE", null, "comment");
    public static final GsfTokenId JAVADOC_COMMENT_INCOMPLETE = new GsfTokenId("GSF_JAVADOC_COMMENT_INCOMPLETE", null, "comment");
    public static final GsfTokenId INVALID_COMMENT_END = new GsfTokenId("GSF_INVALID_COMMENT_END", "*/", "error");
    public static final GsfTokenId FLOAT_LITERAL_INVALID = new GsfTokenId("GSF_FLOAT_LITERAL_INVALID", null, "number");

    // Cheating: out of laziness just map all keywords returning from JRuby
    // into a single KEYWORD token; eventually I will have separate tokens
    // for each here such that the various helper methods for formatting,
    // smart indent, brace matching etc. can refer to specific keywords
    public static final GsfTokenId ANY_KEYWORD = new GsfTokenId("GSF_ANY_KEYWORD", null, "keyword");
    public static final GsfTokenId ANY_OPERATOR = new GsfTokenId("GSF_ANY_OPERATOR", null, "operator");

    private final String name;
    private final String primaryCategory;
    private final String fixedText;
    private final int ordinal;
    protected static int nextOrdinal;

    public GsfTokenId(String name, String fixedText, String primaryCategory) {
        this.name = name;
        this.primaryCategory = primaryCategory;
        this.fixedText = fixedText;
        synchronized (GsfTokenId.class) {
            this.ordinal = nextOrdinal++;
        }
    }

    public String primaryCategory() {
        return primaryCategory;
    }

    public String fixedText() {
        return fixedText;
    }

    public String name() {
        return name;
    }

    public int ordinal() {
        return ordinal;
    }
    
    public String toString() {
        return getClass().getName() + ":" + name + ":" + ordinal;
    }
}
