/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * RMSReaderMidlet.java
 *
 * Created on April 6, 2007, 2:16 PM
 */

package org.netbeans.microedition.testme.rms;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

/**
 *
 * @author  Pavel
 * @version
 */
public final class RMSReaderMidlet extends MIDlet implements CommandListener {
    //TODO use CVS revision as version
    private static final String VERSION = "0.1";
    private static final String TITLE   = "RMS Log Browser";
    
    private final Form                textScreen;
    private final List                logSelectionScreen;
    private       RMSRecordSetManager rmsMgr;
    private       String []           logs;
    
    private final Command   EXIT       = new Command( "Exit", Command.EXIT, 0);
    private final Command   BACK       = new Command( "Back", Command.BACK, 0);
    private final Command   VIEW_LOG   = new Command( "View", Command.ITEM, 1);
    private final Command   DELETE_LOG = new Command( "Delete", Command.ITEM, 1);
    
    public RMSReaderMidlet() {
        logSelectionScreen = new List(TITLE, Choice.IMPLICIT);
        logSelectionScreen.setCommandListener(this);
        logSelectionScreen.setSelectCommand(VIEW_LOG);
        logSelectionScreen.addCommand(EXIT);
        logSelectionScreen.addCommand(DELETE_LOG);
        
        textScreen         = new Form(TITLE);
        textScreen.setCommandListener( this);
        textScreen.addCommand(EXIT);
        textScreen.addCommand(BACK);
    }
        
    protected void updateLogList() {
        logSelectionScreen.deleteAll();
        logs = rmsMgr.listRecordSets();

        
        if (logs.length > 0) {
            for (int i = 0; i < logs.length; i++) {
                logSelectionScreen.append( logs[i], null);
            }  
            showSelectionScreen();
        } else {
            textScreen.deleteAll();                    
            log("No logs found.");
            getDisplay().setCurrent(textScreen);                
            textScreen.removeCommand(BACK);
        }            
    }
    
    public void startApp() {
        getDisplay().setCurrent(textScreen);
        try {
            rmsMgr = new RMSRecordSetManager();
            updateLogList();
        } catch (IOException ex) {
            logException(ex);
        }        
    }
    
    protected void showSelectionScreen() {
        getDisplay().setCurrent(logSelectionScreen);
    }
    
    protected void showLogViewScreen(String logName) {
        textScreen.deleteAll();
        int    lineNum = 0;
        
        try {
            RMSEntry rset = rmsMgr.openRecordSet(logName);
            InputStream in = rset.openReader();
            String line    = null;
            while( (line=Utils.readString(in)) != null) {
                log(line + "\n");
                lineNum++;
            }
        } catch (IOException ex) {
            logException(ex);
        }
        textScreen.setTitle( logName + "[" + lineNum + "]");
        getDisplay().setCurrent(textScreen);
    }
    
    public void pauseApp() {
    }
    
    public void destroyApp(boolean unconditional) {
    }    
    
    protected final Display getDisplay() {
        return Display.getDisplay(this);
    }      
    
    protected void log(String msg) {
        textScreen.append(msg);
    }
    
    protected void logException(Exception e) {
        log("Exception caught: " + e.getClass() + " " + e.getMessage());
        e.printStackTrace();
    }
    
    public void commandAction(Command command, Displayable displayable) {
        if ( command == EXIT) {
            destroyApp(true);
            notifyDestroyed();
        } else if (command == VIEW_LOG) {
            showLogViewScreen(getSelectedLog());
        } else if (command == DELETE_LOG) {
            try {
                rmsMgr.deleteRecordSet(getSelectedLog());
            } catch (IOException ex) {
                ex.printStackTrace();
            }
            updateLogList();
        } else if (command == BACK) {
            showSelectionScreen();
        }
    }
    
    private String getSelectedLog() {
        return logs[logSelectionScreen.getSelectedIndex()];    
    }
}