/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 

package org.netbeans.microedition.testme.svg.tests;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import org.netbeans.microedition.testme.svg.support.SVGTestMIDlet;
import org.netbeans.microedition.testme.svg.support.SVGUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGElement;

/**
 * The J2ME test suite for known issues related to SVG element focus transitions.
 * @author  PavelBenes
 * @version
 */
public final class FocusTests extends SVGTestMIDlet {
    public FocusTests() throws Exception {
        super("Focus transitions unit test(s)", 2, "focusTests.svg", true);
    }
    
    protected void runTest(int testNumber) throws Throwable {
        switch(testNumber) {
            case 1: testFocusIn(); break;
            case 2: testRepeatedFocusIn(); break;
        }
    }    
    
    /**
     * This test verifies that focus-received event triggers an SVG animation.
     */
    protected void testFocusIn() throws InterruptedException {
        // request focus, it should trigger animation that
        // smoothly changes color or the box from green to white during one second.
        log("Requesting focus.");
        requestFocus();
        
        // two seconds later check the visual state of SVG image. The triggered
        // animation should be completed by now and the box color should be white
        // i.e. the box should not be visible.
        new Timer().schedule( new TimerTask() {
            public void run() {
                log( "Checking the box color");
                asynchronousTestCompleted(SVGUtils.isImageEmpty( takeScreenshot()),
                                          "Box color should be white.");
            }
        }, 2000);
    }

    /**
     * This test verifies if repeated focus-received event does not trigger SVG 
     * animation.
     */
    protected void testRepeatedFocusIn() throws InterruptedException {
        // request focus for the first time, it should trigger animation that
        // gradually changes color or box from green to white in one second
        log("Requesting focus for the first time.");
        requestFocus();

        // after two seconds, request focus again
        // it should not trigger animation since the focus is already on the element
        new Timer().schedule( new TimerTask() {
            public void run() {
                log("Requesting focus for the second time.");
                requestFocus();
            }
        }, 2000);

        // 100 milliseconds later check the visual state of SVG image. If the second
        // focus have triggered the animation the box color is somewhere between green
        // a while, otherwise the color is white i.e. the box is not visible.
        new Timer().schedule( new TimerTask() {
            public void run() {
                log( "Checking the box color");
                asynchronousTestCompleted(SVGUtils.isImageEmpty( takeScreenshot()),
                                          "Box color should be white.");
            }
        }, 2100);        
    }

    /**
     * Helper function, request focus for box element
     */
    protected void requestFocus() {
        try {
            final Document doc = getSVGImage().getDocument();
            getSVGAnimator().invokeAndWait( new Runnable() {
                public void run() {
                    getSVGImage().focusOn((SVGElement)doc.getElementById("button"));       
                }                
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        } 
    }
}
