/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */

package org.netbeans.modules.changelog;


import java.util.*;
import org.openide.windows.*;
import org.openide.*;
import java.io.*;

/**
 * prints the processed groups to text file..
 * @author  ralph
 */
public class LogPrinter_Text implements LogPrinter {

    private java.io.PrintWriter writer;
    private boolean includeSummary;

    public LogPrinter_Text(File file) {
        if (!file.exists()) {
            try {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            } catch (IOException exc) {
                 org.openide.ErrorManager.getDefault().notify(exc);
                 System.out.println("error while creating file..");
            }
        }
        writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(file));
        } catch (IOException exc) {
                 org.openide.ErrorManager.getDefault().notify(exc);
                 System.out.println("error while opening file..");
        }
    }
    
    public void printHeader(ChangeLogProcessor processor) {
        if (writer == null) {
            return;
        }
        includeSummary = processor.isIncludeSummary();
        if (processor.isIncludeQueryDescription()) {
            writer.println("Query:");
            if (processor.getDateRange() != null) {
                writer.println("   Date Range:" + processor.getDateRange());
            }
            if (processor.getRevisionRange() != null) {
                writer.println("   Revision Filter:" + processor.getRevisionRange());
            }
            if (processor.getMessageFilter() != null) {
                String messageType = "";
                if (processor.getMessageFilterType() == ChangeLogProcessor.MESSAGE_FILTER_SUBSTRING) {
                    messageType = "Substring";
                } else if (processor.getMessageFilterType() == ChangeLogProcessor.MESSAGE_FILTER_SOME_WORDS) {
                    messageType = "Any of words";
                } else if (processor.getMessageFilterType() == ChangeLogProcessor.MESSAGE_FILTER_ALL_WORDS) {
                    messageType = "All of words";
                } else if (processor.getMessageFilterType() == ChangeLogProcessor.MESSAGE_FILTER_REGEXP) {
                    messageType = "Regular expression";
                }
                writer.println("   Message Filter (" + messageType + "):" + processor.getMessageFilter());
            }
            if (processor.getFileFilter() != null) {
                String fileType = "";
                if (processor.getFileFilterType() == ChangeLogProcessor.FILE_FILTER_SUBSTRING) {
                    fileType = "Substring";
                } else if (processor.getFileFilterType() == ChangeLogProcessor.FILE_FILTER_REGEXP) {
                    fileType = "Regular expression";
                }
                writer.println("   Contained Files Filter (" + fileType + "):" + processor.getFileFilter());
            }
            if (processor.getSortMode() == ChangeLogProcessor.SORT_BY_DATE) {
                writer.print("   Sort: by Date");
            } else if (processor.getSortMode() == ChangeLogProcessor.SORT_BY_USER) {
                writer.print("   Sort: by User");
            }
            if (processor.isDescendingSort()) {
                writer.println(" (Descending)");
            } else {
                writer.println(" (Ascending)");
            }
            writer.println();
            writer.println();
        }
    }
    
    public void printGroupHeader(RevisionsGroup group) {
        if (writer == null) {
            return;
        } 
          writer.println("--------------------------------------------------");
          writer.println("User: " + group.getUser());
          writer.println("Date: " + group.getStartingDate());
          writer.println("Message:" + group.getMessage());
    }
    
    public void printSingleRevision(LogInfoRevision revision) {
        if (writer == null ) {
            return;
        }
        String repoFileName = revision.getLogInfoHeader().getRepositoryFilename();
        repoFileName = repoFileName.substring(0, repoFileName.length() - 2);
        writer.println("   " + revision.getNumber() + "  " + repoFileName);
    }
    
    public void printGroupFooter(RevisionsGroup group) {
        //do nothing
    }
    
    public void printSummary(SummaryProcessor processor) {
        if (writer == null) {
            return;
        }
        if (includeSummary) {
            writer.println("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
            writer.println("Summary:");
            writer.println("Number of changes: " + processor.getCommitCount());
            writer.print("Developers: ");
            String[] users = processor.getUserList();
            for (int i = 0; i < users.length; i++) {
                if (i < users.length) {
                    writer.println(users[i] + ", ");
                } else {
                    writer.println(users[i]);
                }
            }
            writer.println();
            String[] mostChanged = processor.getMostChangedFiles();
            writer.println("Most frequently changed files:");
            for (int j = 0; j < mostChanged.length; j++) {
                writer.println(mostChanged[j]);
            }
            writer.println();
            writer.println("Most active developers (based on number of commits):");
            String[] mostActive= processor.getMostActiveUsers();
            for (int k = 0; k < mostActive.length; k++) {
                writer.println(mostActive[k]);
            }
            writer.println();
        }
    }
    
    public void printFooter(ChangeLogProcessor processor) {
        //do nothing
        if (writer != null) {
            writer.flush();
            writer.close();
        }
    }
    
}
