/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.earproject.ProjectEar;
import org.netbeans.modules.j2ee.earproject.ui.FoldersListSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;

final class PanelProjectLocationVisual extends SettingsPanel implements DocumentListener {
    private static final long serialVersionUID = 1L;
    
    private final PanelConfigureProject panel;
    private final String propNameIndex;
    private final ResourceBundle customBundle;
    private final boolean importStyle;
    
    /** Creates new form PanelProjectLocationVisual */
    public PanelProjectLocationVisual(PanelConfigureProject panel, String propNameIndex, ResourceBundle customBundle, boolean importStyle) {
        this.customBundle = customBundle;
        initComponents();
        this.panel = panel;
        this.propNameIndex = propNameIndex;
        
        // Register listener on the textFields to make the automatic updates
        projectNameTextField.getDocument().addDocumentListener(this);
        projectLocationTextField.getDocument().addDocumentListener(this);
        this.importStyle = importStyle;
        createdFolderTextField.setEditable(importStyle);
        if (importStyle) {
            createdFolderTextField.getDocument().addDocumentListener(this);
        }
        browseFolderButton.setVisible(importStyle);
    }
    
    void addNameListener(DocumentListener listener) {
        projectNameTextField.getDocument().addDocumentListener(listener);        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        projectNameLabel = new javax.swing.JLabel();
        projectNameTextField = new javax.swing.JTextField();
        projectLocationLabel = new javax.swing.JLabel();
        projectLocationTextField = new javax.swing.JTextField();
        browseLocationButton = new javax.swing.JButton();
        createdFolderLabel = new javax.swing.JLabel();
        createdFolderTextField = new javax.swing.JTextField();
        browseFolderButton = new javax.swing.JButton();
        spaceFiller = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        projectNameLabel.setLabelFor(projectNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(projectNameLabel, org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "LBL_NWP1_ProjectName_Label")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(projectNameLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 12, 3, 5);
        add(projectNameTextField, gridBagConstraints);
        projectNameTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "ACS_LBL_NWP1_ProjectName_A11YDesc")); // NOI18N

        projectLocationLabel.setLabelFor(projectLocationTextField);
        org.openide.awt.Mnemonics.setLocalizedText(projectLocationLabel, org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "LBL_NWP1_ProjectLocation_Label")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(projectLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 12, 3, 0);
        add(projectLocationTextField, gridBagConstraints);
        projectLocationTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "ACS_LBL_NPW1_ProjectLocation_A11YDesc")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(browseLocationButton, org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "LBL_NWP1_BrowseLocation_Button")); // NOI18N
        browseLocationButton.setActionCommand("BROWSE"); // NOI18N
        browseLocationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseLocationAction(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 6, 3, 5);
        add(browseLocationButton, gridBagConstraints);
        browseLocationButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "ACS_LBL_NWP1_BrowseLocation_A11YDesc")); // NOI18N

        createdFolderLabel.setLabelFor(createdFolderTextField);
        org.openide.awt.Mnemonics.setLocalizedText(createdFolderLabel, org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "LBL_NWP1_CreatedProjectFolder_Lablel")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(createdFolderLabel, gridBagConstraints);

        createdFolderTextField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 12, 3, 0);
        add(createdFolderTextField, gridBagConstraints);
        createdFolderTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "ACS_LBL_NWP1_CreatedProjectFolder_A11YDesc")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(browseFolderButton, org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "LBL_NWP1_BrowseLocation_Button")); // NOI18N
        browseFolderButton.setActionCommand("BROWSE"); // NOI18N
        browseFolderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseLocationAction2(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(browseFolderButton, gridBagConstraints);
        browseFolderButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PanelProjectLocationVisual.class, "ACSD_LBL_NWP1_BrowseFolder")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(spaceFiller, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void browseLocationAction2(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseLocationAction2
        String command = evt.getActionCommand();
        
        if ("BROWSE".equals(command)) { //NOI18N
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(customBundle.getString("LBL_NWP1_SelectProjectLocation")); //NOI18N
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            String path = getCreatedFolderText();
            if (path.length() > 0) {
                File f = new File(path);
                if (f.exists()) {
                    chooser.setSelectedFile(f);
                }
            }
            if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                createdFolderTextField.setText(projectDir.getAbsolutePath());
            }            
            panel.fireChangeEvent();
        }
    }//GEN-LAST:event_browseLocationAction2

    private void browseLocationAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseLocationAction
        String command = evt.getActionCommand();
        
        if ("BROWSE".equals(command)) { //NOI18N
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(customBundle.getString("LBL_NWP1_SelectProjectLocation")); //NOI18N
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            String path = projectLocationTextField.getText();
            if (path.length() > 0) {
                File f = new File(path);
                if (f.exists()) {
                    chooser.setSelectedFile(f);
                }
            }
            if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                projectLocationTextField.setText(projectDir.getAbsolutePath());
            }            
            panel.fireChangeEvent();
        }
    }//GEN-LAST:event_browseLocationAction
    
    public void addNotify() {
        super.addNotify();
        //same problem as in 31086, initial focus on Cancel button
        projectNameTextField.requestFocus();
    }
    
    boolean valid(WizardDescriptor wizardDescriptor) {
        //fix of #57246 - Too much time is needed to creation of new ent app
        //if the projectLocationTextField contains just '\' then the generated project path
        //starts with \\ which is wrong (a network path)
        if("\\".equals(getCreatedFolderText())) { // NOI18N
            return false;
        }
        
        if (!SettingsPanel.isValidProjectName(projectNameTextField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", //NOI18N
                    customBundle.getString("MSG_IllegalProjectName")); //NOI18N
            return false; // Display name not specified
        }
        
        final String relativeDDPath = "src" + File.separator + "conf" // NOI18N
                + File.separator + ProjectEar.FILE_DD;
        
        if (importStyle) {
            File appXmlSrc = new File(projectLocationTextField.getText().trim() +
                    File.separator + relativeDDPath);
            if (!appXmlSrc.exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", // NOI18N
                MessageFormat.format(customBundle.getString("MSG_Requires"),new Object[] {appXmlSrc.getAbsolutePath()})); //NOI18N
                return false;
            }
            if (getCreatedFolderText().length() == 0) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", //NOI18N
                    customBundle.getString("MSG_EmptyProjectFolder"));//NOI18N
                return false;
            }
        }

        File destParent = SettingsPanel.findExistingParent(getCreatedFolderText());
                
        File destDir = new File(getCreatedFolderText());
        if (destDir.exists() && !destDir.isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", //NOI18N
            MessageFormat.format(customBundle.getString("MSG_WillOverwrite"),new Object[] {destDir.getAbsolutePath() })); //NOI18N
            return false;
        }
        File buildXml = new File(getCreatedFolderText() + File.separator + "build.xml"); // NOI18N
        if (buildXml.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", //NOI18N
            MessageFormat.format(customBundle.getString("MSG_WillOverwrite"),new Object[] {buildXml.getAbsolutePath() })); //NOI18N
            return false;
        }
        File tFile = new File(getCreatedFolderText() + File.separator + relativeDDPath);
        if (tFile.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", // NOI18N
            MessageFormat.format(customBundle.getString("MSG_WillOverwrite"),new Object[] {tFile.getAbsolutePath()})); //NOI18N
            return false;
        }
        
        tFile = new File(getCreatedFolderText() + File.separator + "nbproject" + File.separator + "project.xml"); //NOI18N
        if (tFile.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", // NOI18N
            MessageFormat.format(customBundle.getString("MSG_WillOverwrite"),new Object[] {tFile.getAbsolutePath()})); //NOI18N
            return false;
        }
        tFile = new File(getCreatedFolderText() +
            File.separator+"nbproject"+File.separator+"project.properties"); //NOI18N
        if (tFile.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", // NOI18N
            MessageFormat.format(customBundle.getString("MSG_WillOverwrite"),new Object[] {tFile.getAbsolutePath()})); //NOI18N
            return false;
        }
        if (null != destParent && destParent.exists() && !destParent.canWrite()) {
            // Read only project location
            wizardDescriptor.putProperty("WizardPanel_errorMessage", // NOI18N
                MessageFormat.format(customBundle.getString("MSG_ProjectLocationRO"),new Object[] {destParent.getAbsolutePath()})); //NOI18N
            return false;
        }
                
        wizardDescriptor.putProperty("WizardPanel_errorMessage", ""); //NOI18N
        return true;
    }
    
    void store( WizardDescriptor d ) {
        String name = projectNameTextField.getText().trim();
        String folder = getCreatedFolderText() ;
        
        d.putProperty( /*XXX Define somewhere */ "projdir", new File( folder )); // NOI18N
        d.putProperty( /*XXX Define somewhere */ "name", name ); // NOI18N
        
        final Integer nameIndex = projectNameTextField.getText().equals(generatedProjectName) ? generatedProjectNameIndex : null;
        d.putProperty(propNameIndex, nameIndex);
    }
    
    void read (WizardDescriptor settings) {
        File projectLocation = (File) settings.getProperty ("projdir");  //NOI18N
        if (projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory ()) {
            projectLocation = ProjectChooser.getProjectsFolder();
        }
        else {
            projectLocation = projectLocation.getParentFile();
        }
        this.projectLocationTextField.setText (projectLocation.getAbsolutePath());
        
        String projectName = (String) settings.getProperty ("name"); //NOI18N
        if (projectName == null) {
                int baseCount = FoldersListSettings.getDefault().getNewProjectCount() + 1;
                String formater = customBundle.getString("LBL_NPW1_DefaultProjectName");
                while ((projectName=validFreeProjectName(projectLocation, formater, baseCount))==null) {
                    baseCount++;                
                }
                settings.putProperty (propNameIndex, baseCount);
        }
        this.projectNameTextField.setText (projectName);                
        this.projectNameTextField.selectAll();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseFolderButton;
    private javax.swing.JButton browseLocationButton;
    private javax.swing.JLabel createdFolderLabel;
    private javax.swing.JTextField createdFolderTextField;
    private javax.swing.JLabel projectLocationLabel;
    private javax.swing.JTextField projectLocationTextField;
    private javax.swing.JLabel projectNameLabel;
    private javax.swing.JTextField projectNameTextField;
    private javax.swing.JPanel spaceFiller;
    // End of variables declaration//GEN-END:variables
        
    // Private methods ---------------------------------------------------------
    
    private String validFreeProjectName (final File parentFolder, final String formater, final int index) {
        String name = MessageFormat.format(formater, index);
        File file = new File (parentFolder, name);
        return file.exists() ? null : name;
    }

    // Implementation of DocumentListener --------------------------------------
    
    public static final String PROP_PROJECT_NAME = "projectName"; //NOI18N

    public void changedUpdate( DocumentEvent e ) {
        updateTexts( e );
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            firePropertyChange (PROP_PROJECT_NAME,null,this.projectNameTextField.getText());
        }
    }
    
    public void insertUpdate( DocumentEvent e ) {
        updateTexts( e );
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            firePropertyChange (PROP_PROJECT_NAME,null,this.projectNameTextField.getText());
        }
    }
    
    public void removeUpdate( DocumentEvent e ) {
        updateTexts( e );
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            firePropertyChange (PROP_PROJECT_NAME,null,this.projectNameTextField.getText());
        }
    }
    
    private String generatedProjectName = "";
    private int generatedProjectNameIndex = 0;

     /** Handles changes in the Project name and project directory
     */
    private void updateTexts( DocumentEvent e ) {
        javax.swing.text.Document doc = e.getDocument();
        if (doc == projectNameTextField.getDocument() || doc == projectLocationTextField.getDocument()) {
            String projectName = projectNameTextField.getText();
            
            if (doc == projectLocationTextField.getDocument()) {
                if (projectName.equals(generatedProjectName)) {
                    File f = new File(projectLocationTextField.getText().trim());
                    generatedProjectNameIndex = getValidProjectNameIndex(generatedProjectNameIndex, f, customBundle);
                } else {
                    generatedProjectNameIndex = 0;
                }
                generatedProjectName = generatedProjectNameIndex > 0 ? getProjectName(generatedProjectNameIndex,customBundle) : null;
                if(generatedProjectNameIndex > 0) {
                    projectName = generatedProjectName;
                    projectNameTextField.setText(generatedProjectName);
                    projectNameTextField.selectAll();
                }
            }
            
            String projectFolder = projectLocationTextField.getText(); 
            createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }                
        panel.fireChangeEvent(); // Notify that the panel changed        
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        } catch (IOException e) {
            return null;
        }
    }

    public static String getProjectName(int index, ResourceBundle rb) {
        return MessageFormat.format(rb.getString("LBL_NPW1_DefaultProjectName"), new Object[] {String.valueOf(index)});
    }

    private static int getValidProjectNameIndex(int currentIndex, File projectLocation, ResourceBundle rb) {
        int index = currentIndex > 0 ? currentIndex : FoldersListSettings.getDefault().getNewProjectCount() + 1;
        if(projectLocation != null) {
            while (new File(projectLocation, getProjectName(index,rb)).exists()) {
                index++;
            }
        }
        return index;
    }
    
    private String getCreatedFolderText() {
        return createdFolderTextField.getText().trim();
    }
    
}

//TODO implement check for project folder name and location
