package org.netbeans.bluej.welcome;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.JPanel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * Top component which displays something.
 */
final class BluejWelcomeTopComponent extends TopComponent {
    
    private static final long serialVersionUID = 1L;
    
    private static BluejWelcomeTopComponent instance;
    /** path to the icon used by the component and its open action */
    static final String ICON_PATH = "org/netbeans/bluej/welcome/frame.gif"; // NOI18N
    
    private static final String PREFERRED_ID = "BluejWelcomeTopComponent"; // NOI18N
    private JPanel panel;
    private BluejWelcomeTopComponent() {
        initComponents();
        panel = new TitlePanel50();
        add(panel);
        setName(NbBundle.getMessage(BluejWelcomeTopComponent.class, "CTL_BluejWelcomeTopComponent")); // NOI18N
        setToolTipText(NbBundle.getMessage(BluejWelcomeTopComponent.class, "HINT_BluejWelcomeTopComponent")); // NOI18N
        setIcon(Utilities.loadImage(ICON_PATH, true));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
    public void addNotify() {
        super.addNotify();
        
    }
    
    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link findInstance}.
     */
    public static synchronized BluejWelcomeTopComponent getDefault() {
        if (instance == null) {
            instance = new BluejWelcomeTopComponent();
        }
        return instance;
    }
    
    /**
     * Obtain the BluejWelcomeTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized BluejWelcomeTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(ErrorManager.WARNING, "Cannot find BluejWelcome component. It will not be located properly in the window system."); // NOI18N
            return getDefault();
        }
        if (win instanceof BluejWelcomeTopComponent) {
            return (BluejWelcomeTopComponent)win;
        }
        ErrorManager.getDefault().log(ErrorManager.WARNING, "There seem to be multiple components with the '" + PREFERRED_ID + "' ID. That is a potential source of errors and unexpected behavior."); // NOI18N
        return getDefault();
    }
    
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }
    
    public void componentOpened() {
        // TODO add custom code on component opening
    }
    
    public void componentClosed() {
        // TODO add custom code on component closing
    }
    
    /** replaces this in object stream */
    public Object writeReplace() {
        return new ResolvableHelper();
    }
    
    protected String preferredID() {
        return PREFERRED_ID;
    }
    
    final static class ResolvableHelper implements Serializable {
        private static final long serialVersionUID = 1L;
        public Object readResolve() {
            return BluejWelcomeTopComponent.getDefault();
        }
    }
    
    
}
