/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;
import java.util.logging.Logger;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
/**
 * Generates client WSDL
 * @author Sreenivasan Genipudi
 */
public class IDEXFormGenerationTask extends Task {
    //Member variable representing source directory

    //Member variable representing source dir
    private File mSourceDir;
    //Member variable representing build dir
    private File mBuildDir;
    private boolean mAlways;
    /**
     * Logger instance
     */
    private Logger logger = Logger.getLogger(IDEXFormGenerationTask.class.getName());

    /**
     * Constructor
     */
    public IDEXFormGenerationTask() {
    }


    /**
     * Set the source directory
     * @param srcDir Source directory
     */
    public void setSourceDirectory(String srcDir) {
  	  this.mSourceDir = new File(srcDir);
    }

    /**
     * Set the build directory
     * @param buildDir build directory
     */
    public void setBuildDirectory(String buildDir) {
    	this.mBuildDir = new File(buildDir);
    }
    

    public void setAlways(String always) {
        if (always.endsWith("true")) {
            mAlways = true;
        } else {
            mAlways = false;
        }
    }
    /**

    /**
     * Generate client WSDL
     */
    public void execute() throws BuildException {

        if(this.mSourceDir == null) {
                throw new BuildException("No directory is set for source files.");
        }

        if(this.mBuildDir == null) {
                throw new BuildException("No build directory is set.");
        }

       
        XformGenerator xformGen = new XformGenerator();
        try {
            xformGen.generate(this.mSourceDir,this.mBuildDir,this.mAlways);
        } catch (Exception e) {
            throw new BuildException (e);
        }

    }

}
