/* *************************************************************************
 *
 *          Copyright (c) 2002, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.wsdl.PortType;
import javax.xml.namespace.QName;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.openide.util.NbBundle;

import com.sun.jbi.workflow.model.ModelFactory;
import com.sun.jbi.workflow.model.Notification;
import com.sun.jbi.workflow.model.Tasks;
import com.sun.jbi.workflow.model.xmlbeans.TTask;

/**
 * 
 * @author SUN Microsystems
 */
public class GenerateAsaArtifacts extends Task {

    
    private static final String WF_SUFFIX = "WF_SUFFIX";

    
    private static final String TASK_COMMON_END_POINT = "TaskCommon_EndPoint";

    private static final String TASK_COMMON_WSDL_URI = "TaskCommon_WSDL_URI";
    
    private static final String TASK_COMMON_INTERFACE = "TaskCommon_Interface";

    private static final String WFSE_WSDL_URI_PREFIX = "WFSE_WSDL_URI_Prefix";

    private static final String WFSE_WSDL_URI_CLIENT_SUFFIX = "WFSE_WSDL_URI_Client_Suffix";
    
   
    private static class Provide {
        private String interfaceName;

        private String serviceName;

        private String endPointName;
    }

    private static class Consumes {
        private String interfaceName;

        private String serviceName;

        private String endPointName;
        
        public String toString() {
        	return interfaceName + ":" + serviceName + ":" + endPointName;
        }
        
        public boolean equals(Object obj) {
        	boolean result = true;
        	if(!(obj instanceof Consumes)) {
        		return false;
        	}
        	
        	Consumes target = (Consumes) obj;
        	
        	result &= this.interfaceName != null ? this.interfaceName.equals(target.interfaceName) : target.interfaceName == null; 
        	result &= this.serviceName != null ? this.serviceName.equals(target.serviceName) : target.serviceName == null;
        	result &= this.endPointName != null ? this.endPointName.equals(target.endPointName) : target.endPointName == null;
        	
        	return result;
        }
        
        public int hashCode() {
        	int code = super.hashCode();
        	if(interfaceName != null) {
        		code += interfaceName.hashCode();
        	}
        	
        	if(serviceName != null) {
        		code += serviceName.hashCode();
        	}
        	
        	if(endPointName != null) {
        		code += endPointName.hashCode();
        	}
        	
        	return code;
        }
        
        public boolean isValid() {
        	boolean valid = true;
        	
        	valid &= this.interfaceName != null;
        	valid &= this.serviceName != null;
        	valid &= this.endPointName != null;
        	
        	return valid;
        }
    }

    private String mSrcDirectoryLocation;

    private String mJbiDescriptorFileLocation;

    private String mProjectName;

    private Properties mProps;

    /** Creates a new instance of GenerateIEPASAArtifacts */
    public GenerateAsaArtifacts() {
        loadProps();
    }

    private void loadProps() {
        mProps = Util.getCommonProperties();

    }

    /**
     * @return Returns the srcDirectoryLocation.
     */
    public String getSrcDirectoryLocation() {
        return mSrcDirectoryLocation;
    }

    /**
     * @param workflowMapFileLocation
     *            The workflowMapFileLocation to set.
     */
    public void setSrcDirectoryLocation(String workflowMapFileLocation) {
        mSrcDirectoryLocation = workflowMapFileLocation;
    }

    /**
     * @return Returns the portMapFileLocation.
     */
    public String getJbiDescriptorFileLocation() {
        return mJbiDescriptorFileLocation;
    }

    /**
     * @param portMapFileLocation
     *            The portMapFileLocation to set.
     */
    public void setJbiDescriptorFileLocation(String jbiDescriptorFileLocation) {
        mJbiDescriptorFileLocation = jbiDescriptorFileLocation;
    }

    public String getProjectName() {
        return mProjectName;
    }

    public void setProjectName(String projectName) {
        mProjectName = projectName;
    }

    public void execute() throws BuildException {
        final String wfSuffix = mProps.getProperty(WF_SUFFIX);
        File srcFolder = new File(mSrcDirectoryLocation);
        if (!srcFolder.exists()) {
            throw new BuildException("Folder " + mSrcDirectoryLocation + " does not exit.");
        }
        // Find all .wf file
        String[] allwfs = srcFolder.list(new FilenameFilter() {
            public boolean accept(File dir, String name) {
                // TODO Auto-generated method stub
                if (name.endsWith(wfSuffix)) {
                    return true;
                }
                return false;
            }
        });

        Map<String, String> prefixTable = new HashMap<String, String>(); // keyed by prefix
        Map<String, String> nsTable = new HashMap<String, String>(); // keyed by name space
        List<Provide> provides = new ArrayList<Provide>();
        List<Consumes> consumes = new ArrayList<Consumes>();
        
        if (allwfs != null && allwfs.length > 0) {
            int nsIndex = 0;
            try {
                for (int i = 0; i < allwfs.length; i++) {
                    String wfFileName = new File(srcFolder, allwfs[i]).getAbsolutePath();
                    Tasks tasks = ModelFactory.getInstance().getTasksModel(wfFileName);
                    com.sun.jbi.workflow.model.Task task = (com.sun.jbi.workflow.model.Task) tasks
                            .getTasks().get(0);
                    String wfns = tasks.getTargetNamespace();
                    String wfnsprefix = "ns" + nsIndex;
                    nsIndex++;
                    prefixTable.put(wfnsprefix, wfns);
                    nsTable.put(wfns, wfnsprefix);

                    Provide provide = new Provide();
                    provides.add(provide);

                    provide.serviceName = wfnsprefix + ":" + task.getPartnerLink();
                    provide.endPointName = task.getRole();

                    PortType portType = task.getPortType ();
                    String bpelwsdlns = portType.getQName().getNamespaceURI();
                    String bpelwsdlnsprefix = "ns" + nsIndex;
                    nsIndex++;
                    prefixTable.put(bpelwsdlnsprefix, bpelwsdlns);
                    nsTable.put(bpelwsdlns, bpelwsdlnsprefix);

                    provide.interfaceName = bpelwsdlnsprefix + ":"
                            + portType.getQName().getLocalPart();
                    nsIndex = createClientAPIProvides(prefixTable, nsTable, provides, task
                            .getName(), nsIndex);
                    
                    
                    //generate consumes entry based on notification
                    List<Notification> notifications = task.getTaskNotifications();
                    Iterator<Notification> it = notifications.iterator();
                    while(it.hasNext()) {
                    	Notification notification = it.next();
                    	
                    	nsIndex = createNotificationConsumes(prefixTable, 
                    						   nsTable, 
                    						   consumes,
                    						   tasks,
                    						   notification,
                    						   nsIndex);
                    }
                }
                FileOutputStream fos = null;
                try {
                    // Generate jbi.xml
                    // <?xml version='1.0'?>
                    // <jbi version="1.0"
                    // xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                    // xmlns="http://java.sun.com/xml/ns/jbi"
                    // xsi:schemaLocation="http://java.sun.com/xml/ns/jbi jbi.xsd"
                    // xmlns:ns0=${ns1} ... xmlns:nsN=${nsN} >
                    // <services binding-component="false">
                    // <provides interface-name=port-type service-name=partner-link
                    // endpoint-name=role-name/>
                    // <consumes interface-name=port-type service-name=partner-link
                    // endpoint-name=role-name link-type="standard"/>
                    // </services>
                    // </jbi>
                    StringBuffer sb = new StringBuffer();
                    sb.append("<!--start of generated code -->\n");
                    sb.append("<jbi version=\"1.0\"\n");
                    sb.append("        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
                    sb.append("        xmlns=\"http://java.sun.com/xml/ns/jbi\"\n");
                    sb
                            .append("        xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi jbi.xsd\"\n");
                    for (int i = 0, I = nsTable.size(); i < I; i++) {
                        String ns = "ns" + i;
                        sb.append("        xmlns:" + ns + "=\"" + prefixTable.get(ns) + "\"");
                        if (i < I - 1) {
                            sb.append("\n");
                        }
                    }
                    sb.append(">\n");
                    sb.append("    <services binding-component=\"false\">\n");
                    // Generate all <provides> first
                    for (int i = 0, I = provides.size(); i < I; i++) {
                        Provide provide = (Provide) provides.get(i);
                        sb.append("        <provides interface-name=\"" + provide.interfaceName);
                        sb.append("\" service-name=\"" + provide.serviceName);
                        sb.append("\" endpoint-name=\"" + provide.endPointName);
                        sb.append("\"/>\n");

                    }
                    
                    //then generate all <consumes>
                    for (int i = 0, I = consumes.size(); i < I; i++) {
                    	Consumes consume = (Consumes) consumes.get(i);
                        sb.append("        <consumes interface-name=\"" + consume.interfaceName);
                        sb.append("\" service-name=\"" + consume.serviceName);
                        sb.append("\" endpoint-name=\"" + consume.endPointName);
                        sb.append("\"/>\n");

                    }
                    sb.append("    </services>\n");
                    sb.append(" </jbi>\n");
                    sb.append("<!--end of generated code -->\n");

                    String content = sb.toString();
                    fos = new FileOutputStream(mJbiDescriptorFileLocation);
                    IOUtil.copy(content.getBytes("UTF-8"), fos);
                } catch (Exception e) {
                    throw e;
                } finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        } catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }

            } catch (Exception e) {
                throw new BuildException(e.getMessage(), e);
            }
        }

        // FileOutputStream fos = null;
        // try {
        // List workflowEntryList = WorkflowMapReader.parse(workflowMapFile);
        //            
        // // Populate prefixTable
        // int nsIndex = 1;
        // for (int i = 0, I = workflowEntryList.size(); i < I; i++) {
        // WorkflowMapEntry entry = (WorkflowMapEntry)workflowEntryList.get(i);
        // String ns = entry.getPartnerLink().getNamespaceURI();
        // if (ns != null && !ns.trim().equals("") && !nsTable.containsKey(ns)) {
        // nsTable.put(ns, "ns" + nsIndex);
        // prefixTable.put("ns" + nsIndex, ns);
        // nsIndex++;
        // }
        //                
        // ns = entry.getPortType().getNamespaceURI();
        // if (ns != null && !ns.trim().equals("") && !nsTable.containsKey(ns)) {
        // nsTable.put(ns, "ns" + nsIndex);
        // prefixTable.put("ns" + nsIndex, ns);
        // nsIndex++;
        // }
        //
        // if (entry.getType() != WorkflowMapEntry.REQUEST_REPLY_SERVICE) {
        // ns = entry.getOutPartnerLink().getNamespaceURI();
        // if (ns != null && !ns.trim().equals("") && !nsTable.containsKey(ns)) {
        // nsTable.put(ns, "ns" + nsIndex);
        // prefixTable.put("ns" + nsIndex, ns);
        // nsIndex++;
        // }
        //
        // ns = entry.getOutPortType().getNamespaceURI();
        // if (ns != null && !ns.trim().equals("") && !nsTable.containsKey(ns)) {
        // nsTable.put(ns, "ns" + nsIndex);
        // prefixTable.put("ns" + nsIndex, ns);
        // nsIndex++;
        // }
        // }
        // }
        //            
        //            

        // try {

        // for (int i = 0, I = workflowEntryList.size(); i < I; i++) {
        // WorkflowMapEntry xme = (WorkflowMapEntry)workflowEntryList.get(i);
        // sb.append(" <provides interface-name=\"" + getDottedQName(xme.getPortType(), nsTable));
        // sb.append("\" service-name=\"" + getDottedQName(xme.getPartnerLink(), nsTable));
        // sb.append("\" endpoint-name=\"" + xme.getRoleName());
        // sb.append("\"/>\n");
        // }
        // // Generate all <consumes> second
        // for (int i = 0, I = workflowEntryList.size(); i < I; i++) {
        // WorkflowMapEntry xme = (WorkflowMapEntry)workflowEntryList.get(i);
        // if (!xme.getType().equals(WorkflowMapEntry.REQUEST_REPLY_SERVICE)) {
        // sb.append(" <consumes interface-name=\"" + getDottedQName(xme.getOutPortType(),
        // nsTable));
        // sb.append("\" service-name=\"" + getDottedQName(xme.getOutPartnerLink(), nsTable));
        // sb.append("\" endpoint-name=\"" + xme.getOutRoleName());
        // sb.append("\" link-type=\"standard\"/>\n");
        // }
        // }

        // } catch (Exception e) {
        // throw new BuildException(e.getMessage());
        // }
    }

    private int createClientAPIProvides(Map prefixTable, Map nsTable, List provides,
            String taskName, int nsIndex) {
            
        String clientwsdlns = mProps.getProperty(TASK_COMMON_WSDL_URI);
        String clientwsdlnsprefix = null;
        Provide provide = null;
        if ((clientwsdlnsprefix = (String)nsTable.get(clientwsdlns)) == null) {
            clientwsdlnsprefix = "ns" + nsIndex;
            nsIndex++;
            prefixTable.put(clientwsdlnsprefix, clientwsdlns);
            nsTable.put(clientwsdlns, clientwsdlnsprefix);
    
            provide = new Provide();
            provides.add(provide);
    
            provide.endPointName = mProps.getProperty(TASK_COMMON_END_POINT);
            provide.interfaceName = clientwsdlnsprefix + ":"
                    + mProps.getProperty(TASK_COMMON_INTERFACE);
            provide.serviceName = clientwsdlnsprefix + ":" + mProps.getProperty(Util.TASK_SERVICE_NAME);
        }
        
        String dynamicClientwsdlns = mProps.getProperty(WFSE_WSDL_URI_PREFIX) + "/" + mProjectName + mProps.getProperty(WFSE_WSDL_URI_CLIENT_SUFFIX);
        String dynamicClientwsdlnsprefix = null;
        
        if ((dynamicClientwsdlnsprefix = (String)nsTable.get(dynamicClientwsdlns)) == null) {
            dynamicClientwsdlnsprefix = "ns" + nsIndex;
            nsIndex++;
            prefixTable.put(dynamicClientwsdlnsprefix, dynamicClientwsdlns);
            nsTable.put(dynamicClientwsdlns, dynamicClientwsdlnsprefix);
    
            provide = new Provide();
            provides.add(provide);
            provide.endPointName = Util.getTaskSpecificClientEndpointName(this.mProjectName); 
            	
            provide.interfaceName = dynamicClientwsdlnsprefix + ":" + Util.getTaskSpecificClientPortTypeName(taskName);
                    
            provide.serviceName = dynamicClientwsdlnsprefix + ":" + Util.getTaskSpecificClientServiceName();
        }
        
        return nsIndex;
        // TODO Auto-generated method stub

    }

    private int createNotificationConsumes(Map<String, String> prefixTable, 
    									   Map<String, String> nsTable, 
    									   List<Consumes> consumesList,
    									   Tasks tasks,
    									   Notification notification,
    									   int nsIndex) throws Exception {
    
    	String wfns = tasks.getTargetNamespace();
        String wfnsprefix =  (String) nsTable.get(wfns);
        if(wfnsprefix == null) {
        	wfnsprefix = "ns" + nsIndex;
        	prefixTable.put(wfnsprefix, wfns);
            nsTable.put(wfns, wfnsprefix);
            nsIndex++;
        }
        
        
        Consumes consumes = new Consumes();
        
        consumes.serviceName = wfnsprefix + ":" + notification.getPartnerLink();
        consumes.endPointName = notification.getRole();

        PortType portType = notification.getPortType();
        if(portType != null && portType.getQName() != null) {
	        String wsdlns = portType.getQName().getNamespaceURI();
	        
	        String wsdlnsprefix = (String) nsTable.get(wsdlns);
	        if(wsdlnsprefix == null) {	
	        	wsdlnsprefix = "ns" + nsIndex;
	        	prefixTable.put(wsdlnsprefix, wsdlns);
	        	nsTable.put(wsdlns, wsdlnsprefix);
	        	nsIndex++;
	        }
	        
	        consumes.interfaceName = wsdlnsprefix + ":"
            + portType.getQName().getLocalPart();
        }
        
        
        if(consumes.isValid()) {
	        if(!consumesList.contains(consumes)) {
	        	consumesList.add(consumes);
	        }
        } else {
        	throw new BuildException("Can not generate valid <consumes> entry for " + consumes.toString());
        }
        
        return nsIndex;
    }
    
    private static String getDottedQName(QName qn, Map nsTable) {
        String ns = qn.getNamespaceURI();
        String prefix = (String) nsTable.get(ns);
        if (prefix == null) {
            return qn.getLocalPart();
        }
        return prefix + ":" + qn.getLocalPart();
    }

    public static void main(String[] args) throws MalformedURLException {
        GenerateAsaArtifacts tsk = new GenerateAsaArtifacts();
        tsk.setJbiDescriptorFileLocation("c:/work/test/jbi.xml");
        tsk
                .setSrcDirectoryLocation("c:/Alaska/root/sharedlibrary/workflowmodel/test/data/samples/approvePurchase");
        tsk.execute();

        // String urlStr =
        // "jar:file:/D:/darkhorse/nbbuild/netbeans/BusinessIntegration/modules/ext/workflowpro/anttask.jar!/com/sun/jbi/ui/devtool/projects/workflowpro/anttasks/jbi_gen.properties";
        // String urlStr =
        // "jar:file:/C:/work/test/anttask.jar!/com/sun/jbi/ui/devtool/projects/workflowpro/anttasks/jbi_gen.properties";
        // String urlStr = "file:/C:/work/test/anttask.jar";
        //        
        //       
        // URL url = new URL (urlStr);
        // String file = url.getFile();
        // System.out.println(new File (file).exists());

        // try {
        // FileInputStream fileInputStream = new FileInputStream(url.getFile());
        // } catch (FileNotFoundException e) {
        // // TODO Auto-generated catch block
        // e.printStackTrace();
        // }

    }

}
