/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.spi;

import java.util.Collection;
import java.util.List;

import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;

public class PartnerLinkTypeReference extends WSDLReferenceImpl<PartnerLinkType> {

	public PartnerLinkTypeReference(
			AbstractDocumentComponent parent, String ref) {
		super(PartnerLinkType.class, parent, ref);
		// TODO Auto-generated constructor stub
	}

	public PartnerLinkTypeReference(PartnerLinkType referenced,
						AbstractDocumentComponent parent) {
		super(referenced, PartnerLinkType.class, parent);
		// TODO Auto-generated constructor stub
	}

	public PartnerLinkType get() {
		// TODO Auto-generated method stub

		String namespace = getEffectiveNamespace();
		TTask task = TTask.class.cast(getParent());
		Collection<WSDLModel> wsdlmodels = task.getModel().findWSDLModel(
				namespace);
		boolean found = false;
		for (WSDLModel model : wsdlmodels) {
			List<PartnerLinkType> list = model.getDefinitions()
					.getExtensibilityElements(PartnerLinkType.class);
			for (PartnerLinkType partnerLink : list) {
				if (getLocalName().equals(partnerLink.getName())) {
					
					setReferenced(PartnerLinkType.class.cast(partnerLink)) ;
					found = true;
					break;
				}
			}
			if (found)
				break;
		}

		return getReferenced();
	}

}
