/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.netbeans.modules.wlm.model.api.TImport;
import org.netbeans.modules.wlm.model.api.TTasks;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMComponentFactory;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WLMModelImpl extends WLMModel {
	private TTasks tasks;

	private WLMComponentFactory wcf;

	public WLMModelImpl(ModelSource source) {
		super(source);
		wcf = new WLMComponentFactoryImpl(this);
	}

	@Override
	public WLMComponent createRootComponent(Element root) {
		// TODO Auto-generated method stub
		  String namespace = root.getNamespaceURI();
	        if ( WLMModel.WLM_NAMESPACE.equals(namespace) &&
	        		WLMModel.WLM_TASKS.equals( root.getLocalName() ) ) 
	        {
	        	tasks = new TasksImpl (this, root);
	            return tasks;
	        } 
	        return null;
	}

	@Override
	protected ComponentUpdater<WLMComponent> getComponentUpdater() {
		// TODO Auto-generated method stub
		return new ChildComponentUpdateVisitor<WLMComponent>();
	}

	public List<WSDLModel> findWSDLModel(String namespaceURI) {
		// TODO Auto-generated method stub
        if (namespaceURI == null) {
            return Collections.emptyList();
        }
        
        List<WSDLModel> models = getImportedWSDLModels();

        List<WSDLModel> ret = new ArrayList<WSDLModel>();
        for (WSDLModel m : models) {
            String targetNamespace = m.getDefinitions().getTargetNamespace();
            if (namespaceURI.equals(targetNamespace)) {
                ret.add(m);
            }
        }
        return ret;
	}
	
    public List<WSDLModel> getImportedWSDLModels() {
        List<WSDLModel> ret = new ArrayList<WSDLModel>();
        Collection<TImport> imports = getTasks().getImports();
        for (TImport i:imports) {
            try {
                WSDLModel m = i.getImportedWSDLModel();
                if (m != null) {
                    ret.add(m);
                }
            } catch(Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "getImportedWSDLModels", e);
            }
        }
        return ret;
    }	

	public WLMComponentFactory getFactory() {
		// TODO Auto-generated method stub
		return wcf;
	}


	public WLMComponent createComponent(WLMComponent parent, Element element) {
		// TODO Auto-generated method stub
		return parent.createChild(element);
	}

	public WLMComponent getRootComponent() {
		// TODO Auto-generated method stub
		return tasks;
	}

	public TTasks getTasks() {
		// TODO Auto-generated method stub
		return tasks;
	}

	public void setTasks(TTasks tasks) {
		// TODO Auto-generated method stub
		this.tasks = tasks;
	}
	
    public ChangeInfo prepareChangeInfo(List<Node> pathToRoot) {
        ChangeInfo change = super.prepareChangeInfo(pathToRoot);
        DocumentComponent parentComponent = findComponent(change.getRootToParentPath());
        if (parentComponent == null) {
            return change;
        }
        change.setParentComponent(parentComponent);
        return change;
    }

}
