/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.wlm.model.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.netbeans.modules.wlm.model.api.TImport;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.TTasks;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.api.WLMVisitor;
import org.w3c.dom.Element;

public class TasksImpl extends WLMComponentBase implements TTasks {

	public TasksImpl(WLMModel model, Element e) {
		super(model, e);
		// TODO Auto-generated constructor stub
	}

	public TasksImpl(WLMModel model) {
		this(model, createNewElement(WLMQNames.TASKS.getQName(), model));
	}
	public void addImport(TImport toAdd) {
                if(!contains(toAdd)) {
                    addAfter(IMPORT_TYPE_PROPERTY, toAdd, TypeCollection.FOR_TASKS_IMPORT.types());
                }
	}

	public void addTask(TTask toAdd) {
		// TODO Auto-generated method stub
		addAfter(TASK_PROPERTY, toAdd, TypeCollection.FOR_TASKS_TASK.types());
	}

	public Collection<TImport> getImports() {
		// TODO Auto-generated method stub
		return getChildren(TImport.class);
	}

	public String getTargetNamespace() {
		// TODO Auto-generated method stub
		return getAttribute(WLMAttribute.TARGET_NAME_SPACE);
	}

	public List<TTask> getTasks() {
		// TODO Auto-generated method stub
		return getChildren(TTask.class);
	}

	public void removeImport(TImport toRemove) {
		// TODO Auto-generated method stub
		removeChild (IMPORT_TYPE_PROPERTY, toRemove);
	}

	public void removeTask(TTask toRemove) {
		// TODO Auto-generated method stub
		removeChild (TASK_PROPERTY, toRemove);
	}

	public void setTargetNamespace(String value) {
		// TODO Auto-generated method stub
		setAttribute(TARGET_NAMESPACE_PROPERTY, WLMAttribute.TARGET_NAME_SPACE, value);
	}

	public void accept(WLMVisitor visitor) {
		// TODO Auto-generated method stub
	    visitor.visitTasks(this);
	}

	public WLMComponent createChild(Element childEl) {
		// TODO Auto-generated method stub
		WLMComponent child = null;
		if (childEl != null) {
			String localName = childEl.getLocalName();
			if (localName == null || localName.length() == 0) {
				localName = childEl.getTagName();
			}
			if (localName.equals(IMPORT_TYPE_PROPERTY)) {
				child = new ImportImpl(getModel(), childEl);
			} else if (localName.equals(TASK_PROPERTY)) {
				child = new TaskImpl(getModel(), childEl);
			} 
		}
		return child;

	}
        
        private boolean contains(TImport imp) {
            boolean result = false;
            String ns = imp.getNamespace();
            String loc = imp.getLocation();
            
            Collection<TImport> imports = getImports();
            Iterator<TImport> it = imports.iterator();
            
            while(it.hasNext()) {
                TImport i = it.next();
                String namespace = i.getNamespace();
                String location = i.getLocation();
                
                boolean matchedNamespace = false;
                boolean matchedLocation = false;
                
                if(ns != null && ns.equals(namespace)) {
                    matchedNamespace = true;
                }
                
                if(loc != null && loc.equals(location)) {
                    matchedLocation = true;
                }
                
                if(ns != null) {
                    result =  matchedNamespace; 
                }
                
                if(loc != null) {
                    result &=  matchedLocation; 
                }
                
                if(result) {
                    break;
                }
                       
            }
            return result;
        }

}
