/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.impl;

import java.util.List;

import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TEscalation;
import org.netbeans.modules.wlm.model.api.TImport;
import org.netbeans.modules.wlm.model.api.TNotification;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.TTimeout;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMComponentFactory;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.api.WLMVisitor;
import org.netbeans.modules.wlm.model.api.WSDLReference;
import org.netbeans.modules.wlm.model.spi.OperationReference;
import org.netbeans.modules.wlm.model.spi.PartnerLinkTypeReference;
import org.netbeans.modules.wlm.model.spi.RoleReference;
import org.netbeans.modules.wlm.model.utl.Util;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.w3c.dom.Element;

public class TaskImpl extends WLMComponentBase implements TTask {

	public TaskImpl(WLMModel model, Element e) {
		super(model, e);
		// TODO Auto-generated constructor stub
	}

	public TaskImpl(WLMModel model) {
		this(model, createNewElement(WLMQNames.TASK.getQName(), model));
	}

	public void addEscalation(TEscalation escalation) {
		// TODO Auto-generated method stub
		addAfter(ESCALATION_PROPERTY, escalation,
				TypeCollection.FOR_TASK_ESCALATION.types());
	}

	public void addNotification(TNotification notification) {
		// TODO Auto-generated method stub
		addAfter(NOTIFICATION_PROPERTY, notification,
				TypeCollection.FOR_TASK_NOTIFICATION.types());
	}

	public void addTimeOut(TTimeout timeout) {
		// TODO Auto-generated method stub
		addAfter(TIMEOUT_PROPERTY, timeout, TypeCollection.FOR_TASK_TIMEOUT
				.types());
	}

	public TAssignment getAssignment() {
		// TODO Auto-generated method stub
		return getChild(TAssignment.class);
	}

	public List<TEscalation> getEscalations() {
		// TODO Auto-generated method stub
		return getChildren(TEscalation.class);
	}

	public List<TNotification> getNotifications() {
		// TODO Auto-generated method stub
		return getChildren(TNotification.class);
	}

	public WSDLReference<Operation> getOperation() {		
		// TODO Auto-generated method stub
		String optStr = getOperationAsString();
		if (optStr == null || optStr.length() == 0) {
			return null;
		}		
		OperationReference optRef = new OperationReference(this, optStr);
		return optRef;
	}

	public String getPartnerLink() {
		// TODO Auto-generated method stub
		return getAttribute(WLMAttribute.PARTNERLINK);
	}

        public void setPartnerLink(String partnerLink) {
            setAttribute(PARTNER_LINK_PROPERTY, WLMAttribute.PARTNERLINK, partnerLink);
        }
        
	public WSDLReference<PartnerLinkType> getPartnerLinkType() {
		// TODO Auto-generated method stub
		String ptnerStr = getPartnerLinkTypeAsString();
		if (ptnerStr == null || ptnerStr.length() == 0) {
			return null;
		}
		PartnerLinkTypeReference ptRef = new PartnerLinkTypeReference(this,
				ptnerStr);
		return ptRef;
	}

	public WSDLReference<Role> getRole() {
		// TODO Auto-generated method stub
		String roleStr = getRoleAsString();
		if (roleStr == null || roleStr.length() == 0) {
			return null;
		}
		RoleReference roleRef = new RoleReference(this, roleStr);
		return roleRef;
	}

	public List<TTimeout> getTimeouts() {
		// TODO Auto-generated method stub
		return getChildren(TTimeout.class);
	}

	public void removeAssignment(TAssignment value) {
		// TODO Auto-generated method stub
		removeChild(ASSIGNMENT_PROPERTY, value);
	}

	public void removeEscalation(TEscalation escalation) {
		// TODO Auto-generated method stub
		removeChild(ESCALATION_PROPERTY, escalation);
	}

	public void removeNotification(TNotification notification) {
		// TODO Auto-generated method stub
		removeChild(NOTIFICATION_PROPERTY, notification);
	}

	public void removeTimeOut(TTimeout timeout) {
		// TODO Auto-generated method stub
		removeChild(TIMEOUT_PROPERTY, timeout);
	}

	public void setAssignment(TAssignment value) {
		// TODO Auto-generated method stub
		setChild(TAssignment.class, ASSIGNMENT_PROPERTY, value,
				TypeCollection.EMPTY.types());
	}

	public void setOperation(WSDLReference<Operation> ref) {
		// TODO Auto-generated method stub
		String val = ref.getRefString();
		String namespace = ref.getEffectiveNamespace();
//		String prefix =  lookupPrefix(namespace) ;
//		if (prefix == null) {
//			prefix = Util.getNewPrefix (getModel().getTasks());
//			addPrefix(prefix, namespace);
//		}		
//		String [] names = val.split(":");
//		if (names.length == 1) {
//			val = prefix + ":" + names[0] ;
//		} else {
//			val = prefix + ":" + names[1] ;
//		}
		setAttribute(OPERATION_PROPERTY, WLMAttribute.OPERATION, val);
		Operation opt = ref.get();
		WSDLModel model = opt.getModel();
		List<PartnerLinkType> list = model.getDefinitions()
				.getExtensibilityElements(PartnerLinkType.class);
		boolean found = false;
		for (PartnerLinkType partnerLink : list) {
			Role role = partnerLink.getRole1();
			if (role != null) {
				PortType portType = role.getPortType().get();
				found = Util.findOptInPortType(opt, portType);
				if (found) {
					String partnerLinkTypeName = lookupPrefix(namespace) + ":"
							+ partnerLink.getName();
					setAttribute(PARTNER_LINK_TYPE_PROPERTY,
							WLMAttribute.PARTNER_LINK_TYPE, partnerLinkTypeName);
					String RoleName = role.getName();
					setAttribute(ROLE_PROPERTY, WLMAttribute.ROLE, RoleName);
					break;
				}
			}
			role = partnerLink.getRole2();
			if (role != null) {
				PortType portType = role.getPortType().get();
				found = Util.findOptInPortType(opt, portType);
				if (found) {
					String partnerLinkTypeName = lookupPrefix(namespace) + ":"
							+ partnerLink.getName();
					setAttribute(PARTNER_LINK_TYPE_PROPERTY,
							WLMAttribute.PARTNER_LINK_TYPE, partnerLinkTypeName);
					String RoleName = role.getName();
					setAttribute(ROLE_PROPERTY, WLMAttribute.ROLE, RoleName);
					break;
				}
			}
		}
		// Add import
		if (!getOperation().isResolved()) {
			WLMComponentFactory factory = getModel ().getFactory();
			TImport importEl = factory.createImport(getModel());
			importEl.setWSDL(opt.getModel());
			getModel().getTasks().addImport(importEl);
		}

	}

	public void setName(String name) {
		// TODO Auto-generated method stub
		setAttribute(NAME_PROPERTY, WLMAttribute.NAME, name);
	}

	public String getName() {
		// TODO Auto-generated method stub
		return getAttribute(WLMAttribute.NAME);
	}

	public void accept(WLMVisitor visitor) {
		// TODO Auto-generated method stub
		visitor.visitTask(this);
	}

	public WLMComponent createChild(Element childEl) {
		// TODO Auto-generated method stub
		WLMComponent child = null;
		if (childEl != null) {
			String localName = childEl.getLocalName();
			if (localName == null || localName.length() == 0) {
				localName = childEl.getTagName();
			}
			if (localName.equals(ASSIGNMENT_PROPERTY)) {
				child = new AssignmentImpl(getModel(), childEl);
			} else if (localName.equals(TIMEOUT_PROPERTY)) {
				child = new TimeoutImpl(getModel(), childEl);
			} else if (localName.equals(ESCALATION_PROPERTY)) {
				child = new EscalationImpl(getModel(), childEl);
			} else if (localName.equals(NOTIFICATION_PROPERTY)) {
				child = new NotificationImpl(getModel(), childEl);
			}
		}
		return child;
	}

	public String getOperationAsString() {
		// TODO Auto-generated method stub
		String optStr = getAttribute(WLMAttribute.OPERATION);
		return optStr;
	}

	public String getPartnerLinkTypeAsString() {
		// TODO Auto-generated method stub
		String optStr = getAttribute(WLMAttribute.PARTNER_LINK_TYPE);
		return optStr;
	}

	public String getRoleAsString() {
		// TODO Auto-generated method stub
		String optStr = getAttribute(WLMAttribute.ROLE);
		return optStr;
	}

    public OperationReference createOperationReference(Operation referenced) {
        OperationReference ref = new OperationReference(referenced, this);
        
        return ref;
        
    }
        
        
}
