/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.wlm.model.impl;

import java.util.List;

import org.netbeans.modules.wlm.model.api.TAction;
import org.netbeans.modules.wlm.model.api.TActionType;
import org.netbeans.modules.wlm.model.api.TRecipient;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.api.WLMVisitor;
import org.w3c.dom.Element;

public class ActionImpl extends WLMComponentBase implements TAction {

	public ActionImpl(WLMModel model, Element e) {
		super(model, e);
		// TODO Auto-generated constructor stub
	}

	public ActionImpl(WLMModel model) {
		this(model, createNewElement(WLMQNames.ACTION.getQName(), model));
	}

	public void addRecipient(TRecipient recipient) {
		// TODO Auto-generated method stub
		addAfter(RECIPIENT_PROPERTY, recipient, TypeCollection.EMPTY.types());
	}

	public List<TRecipient> getRecipients() {
		// TODO Auto-generated method stub
		return getChildren (TRecipient.class);
	}

	public TActionType getType() {
		// TODO Auto-generated method stub
		String typeStr = getAttribute(WLMAttribute.TYPE);
		return TActionType.valueOf(typeStr);
	}

	public void removeRecipient(TRecipient recipient) {
		// TODO Auto-generated method stub
		removeChild(RECIPIENT_PROPERTY, recipient);
	}

	public void setType(TActionType value) {
		// TODO Auto-generated method stub
		setAttribute(TYPE_PROPERTY, WLMAttribute.TYPE, value);
	}

	public void accept(WLMVisitor visitor) {
		// TODO Auto-generated method stub
		visitor.visitAction(this);
	}

	public WLMComponent createChild(Element childEl) {
		// TODO Auto-generated method stub
		WLMComponent child = null;
		if (childEl != null) {
			String localName = childEl.getLocalName();
			if (localName == null || localName.length() == 0) {
				localName = childEl.getTagName();
			}
			if (localName.equals(RECIPIENT_PROPERTY)) {
				child = new RecipientImpl(getModel(), childEl);
			} 
		}
		return child;
	}

}
