package org.netbeans.modules.wlm.model.api;
/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved. */

import java.util.List;
import org.netbeans.modules.wlm.model.spi.OperationReference;

import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Nameable;

/**
 * <p>
 * Java class for tTask complex type.
 * 
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 * 
 * <pre>
 * &lt;complexType name=&quot;tTask&quot;&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base=&quot;{http://www.w3.org/2001/XMLSchema}anyType&quot;&gt;
 *       &lt;sequence&gt;
 *         &lt;element name=&quot;assignment&quot; type=&quot;{http://jbi.com.sun/wfse}tAssignment&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;timeout&quot; type=&quot;{http://jbi.com.sun/wfse}tTimeout&quot; maxOccurs=&quot;unbounded&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;escalation&quot; type=&quot;{http://jbi.com.sun/wfse}tEscalation&quot; maxOccurs=&quot;unbounded&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;notification&quot; type=&quot;{http://jbi.com.sun/wfse}tNotification&quot; maxOccurs=&quot;unbounded&quot; minOccurs=&quot;0&quot;/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name=&quot;name&quot; use=&quot;required&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; /&gt;
 *       &lt;attribute name=&quot;operation&quot; use=&quot;required&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}QName&quot; /&gt;
 *       &lt;attribute name=&quot;partnerLink&quot; use=&quot;required&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; /&gt;
 *       &lt;attribute name=&quot;partnerLinkType&quot; use=&quot;required&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}QName&quot; /&gt;
 *       &lt;attribute name=&quot;role&quot; use=&quot;required&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */

public interface TTask extends Nameable<WLMComponent>,
		WLMComponent {
	static final String ASSIGNMENT_PROPERTY = "assignment";

	static final String TIMEOUT_PROPERTY = "timeout";

	static final String ESCALATION_PROPERTY = "escalation";

	static final String NOTIFICATION_PROPERTY = "notification";

	static final String OPERATION_PROPERTY = "operation";

	static final String PARTNER_LINK_PROPERTY = "partnerLink";

	static final String PARTNER_LINK_TYPE_PROPERTY = "partnerLinkType";

	static final String ROLE_PROPERTY = "role";
	
	static final String NAME_PROPERTY = "name";

	TAssignment getAssignment();

	void setAssignment(TAssignment value);
	
	void removeAssignment (TAssignment value);

	List<TTimeout> getTimeouts();

	void addTimeOut(TTimeout timeout);

	void removeTimeOut(TTimeout timeout);

	List<TEscalation> getEscalations();

	void addEscalation(TEscalation escalation);

	void removeEscalation(TEscalation escalation);

	List<TNotification> getNotifications();

   void addNotification(TNotification notification);

	void removeNotification(TNotification notification);

	WSDLReference<Operation> getOperation();
	
	String getOperationAsString ();

	void setOperation(WSDLReference<Operation> operation);

    WSDLReference<Role> getRole();
    
    String getRoleAsString ();

    WSDLReference<PartnerLinkType> getPartnerLinkType();
    
    String getPartnerLinkTypeAsString ();
    
    String getPartnerLink ();
    
    void setPartnerLink(String partnerLink);
    
    OperationReference createOperationReference(Operation referenced);
}
