/*
 * UsersTableModel.java
 * 
 * Created on Jun 22, 2007, 3:27:34 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.wizard;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author radval
 */
public class UsersTableModel extends AbstractTableModel {

        private List<User> users = new ArrayList<User>();
        
        public int getRowCount() {
            return users.size();
        }

        public int getColumnCount() {
            return 1;
        }
        
        public List<User> getUsers() {
            return this.users;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            User user = users.get(rowIndex);
            if(user != null) {
                return user.getUserName();
            }
            
            return "";
        }
        
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            User user = users.get(rowIndex);
            if(user != null) {
                user.setUserName((String)aValue);
            }
        }
         
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
         
        public void addNewUser(User user) {
            if(user != null) {
                users.add(user);
                fireTableDataChanged();
            }
        }
        
        public void addNewRow() {
            User user = new User("");
            users.add(user);
            fireTableDataChanged();
        }
        
        public void removeRow(int row) {
            if(users.size() > row)  {
                users.remove(row);
            }
            fireTableDataChanged();
        }
        
        
        class User {
            
            private String user;
            
            public User(String user) {
                this.user = user;
            }
            
            public void setUserName(String user) {
                this.user = user;
            }
            
            public String getUserName() {
                return this.user;
            }
            
            public String toString() {
                return this.user;
            }
        }
        
        class Group {
            
            private String group;
            
            public Group(String group) {
                this.group = group;
            }
            
            public void setGroupName(String group) {
                this.group = group;
            }
            
            public String getGroupName() {
                return this.group;
            }
            
            public String toString() {
                return this.group;
            }
        }
}
