package org.netbeans.modules.worklist.wizard;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.wlm.model.spi.OperationReference;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.editor.multiview.overview.ExplorerPropertyChangeListener;
import org.netbeans.modules.worklist.editor.view.WSDLOperationPanel;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;

import org.openide.DialogDisplayer;
import org.openide.loaders.DataObject;

public final class TaskPanel extends JPanel {
    
    public static final String PROP_WSDL_OPERATION = "PROP_WSDL_OPERATION";
    private DataObject dObj;
    
    private Operation selectedOperation;
    
    private WorklistWizardBottomPanel1 parent;
       
    private PropertyChangeSupport pSupport = new PropertyChangeSupport(this);
    
    /** Creates new form WorklistVisualPanel1 */
    public TaskPanel(WorklistWizardBottomPanel1 parent, DataObject folder) {
        this.dObj = folder;
        this.parent = parent;
        initComponents();
        initGUI();
    }
    
    public String getName() {
        return "Task Name and WSDL Operation";
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        taskNameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        wsdlOperationTextField = new javax.swing.JTextField();
        selectOperationButton = new javax.swing.JButton();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, "Task Name");

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, "Operation");

        wsdlOperationTextField.setEditable(false);

        org.openide.awt.Mnemonics.setLocalizedText(selectOperationButton, "jButton1");
        selectOperationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selectOperationButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(taskNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 343, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(jLabel2)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(wsdlOperationTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 341, Short.MAX_VALUE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(selectOperationButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(taskNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(11, 11, 11)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(selectOperationButton)
                    .add(wsdlOperationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(236, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void selectOperationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selectOperationButtonActionPerformed
    WSDLOperationPanel wsdlOperations = new WSDLOperationPanel(this.dObj);
    DialogDescriptor  dd = new DialogDescriptor(wsdlOperations, "select operation");
    dd.setValid(false);
    ExplorerPropertyChangeListener listener = new ExplorerPropertyChangeListener(dd);
    wsdlOperations.getExplorerManager().addPropertyChangeListener(listener);
    DialogDisplayer dDis = DialogDisplayer.getDefault();
    dDis.notify(dd);
    
    if (dd.getValue() == DialogDescriptor.OK_OPTION ) {
        Operation oldOperation = this.selectedOperation;
        this.selectedOperation = listener.getSelectedOperation();
        if(this.selectedOperation != null) {
            this.wsdlOperationTextField.setText(this.selectedOperation.getName());
        }
        
        pSupport.firePropertyChange(PROP_WSDL_OPERATION, oldOperation, selectedOperation);
    }
}//GEN-LAST:event_selectOperationButtonActionPerformed
    
    public String getTaskName() {
        return this.taskNameTextField.getText();
    }
    
    public void setTaskName(String taskName) {
        this.taskNameTextField.setText(taskName);
    }
    
    public Operation getSelectedOperation() {
        return this.selectedOperation;
    }
    
    public JTextField getTaskNameTextField() {
        return this.taskNameTextField;
    }
    
    public JTextField getTaskOperationTextField() {
        return this.wsdlOperationTextField;
    }
    
    private void initGUI() {
        
    }
    
    public void addPropertyChangeListener(PropertyChangeListener l) {
        pSupport.addPropertyChangeListener(l);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener l) {
        pSupport.removePropertyChangeListener(l);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton selectOperationButton;
    private javax.swing.JTextField taskNameTextField;
    private javax.swing.JTextField wsdlOperationTextField;
    // End of variables declaration//GEN-END:variables
    
}

