/*
 * TaskSelectionModel.java
 * 
 * Created on Jun 5, 2007, 1:13:18 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview;

import javax.swing.event.EventListenerList;
import org.netbeans.modules.wlm.model.api.TTask;

/**
 *
 * @author radval
 */
public class TaskSelectionModel {

    private TTask selectedTask;
    
    private EventListenerList listeners = new EventListenerList();
    
    public TaskSelectionModel() {
    }
   
    
    
    public TTask getSelectedTask() {
        return selectedTask;
    }
    
    public void setSelectedTask(TTask selected) {
        this.selectedTask = selected;
        fireTaskSelectionEvent(this.selectedTask);
    }
    
    public void addTaskSelectionListner(TaskSelectionListener listener) {
        synchronized(listeners) {
            listeners.add(TaskSelectionListener.class, listener);
        }
    }
    
    public void removeTaskSelectionListner(TaskSelectionListener listener) {
        synchronized(listeners) {
            listeners.remove(TaskSelectionListener.class, listener);
        }
    }
    
    
     /**
     * Fires Task Selection Event to the registered listeners, if any.
     *
     * @param  task TTask
     */
    private void fireTaskSelectionEvent(TTask task) {
        synchronized(listeners) {
            Object[] list = listeners.getListenerList();
            TaskSelectionEvent event = null;
            for (int ii = list.length - 2; ii >= 0; ii -= 2) {
                if (list[ii] == TaskSelectionListener.class) {
                    if (event == null) {
                        event = new TaskSelectionEvent(this, task);
                    }
                    ((TaskSelectionListener) list[ii + 1]).taskSelected(event);
                }
            }
        }
    }
    
}
