/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.script.project.wizard.element;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;

import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.xam.ModelSource;

import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.catalogsupport.ProjectConstants;

import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;

/**
 * @author Raghunadh
 * 
 */
final class Util {

  private Util() {}

  /**{@inheritDoc}*/
  public static WSDLFile [] getWSDLFiles(Project project) {
    List<WSDLFile> wsdlFiles = new ArrayList<WSDLFile>();

    addWSDLFilesFromProject(project, wsdlFiles);

    DefaultProjectCatalogSupport instance =
      DefaultProjectCatalogSupport.getInstance(project.getProjectDirectory());
    Iterator projects = instance.getProjectReferences().iterator();

//out();
    while (projects.hasNext()) {
      Project next = (Project) projects.next();
      addWSDLFilesFromProject(next, wsdlFiles);
//out();
//out("see: " + next);
    }
    return wsdlFiles.toArray(new WSDLFile [wsdlFiles.size()]);
  }

  private static void addWSDLFilesFromProject(
    Project project,
    List<WSDLFile> wsdlFiles)
  {
    Sources sources = ProjectUtils.getSources(project);
    SourceGroup [] groups =
      sources.getSourceGroups(ProjectConstants.SOURCES_TYPE_XML);

    for (SourceGroup group : groups) {
      Enumeration files = group.getRootFolder().getChildren(true);

      while (files.hasMoreElements()) {
        FileObject file = (FileObject) files.nextElement();

        if (file.getExt().toLowerCase().equals("wsdl")) { // NOI18N
          wsdlFiles.add(new WSDLFile(file, project));
        }
      }
    }
  }

  /**{@inheritDoc}*/
  public static FileObject getSrcFolder(Project project) {
    return project.getProjectDirectory().getFileObject(SRC_FOLDER);
  }

  /**{@inheritDoc}*/
  public static String calculateRelativeName(FileObject file, Project project) {
    if (file == null) {
      return null;
    }
    String path = file.getPath();
    Sources sources = ProjectUtils.getSources(project);
    SourceGroup [] groups = sources.getSourceGroups(Sources.TYPE_GENERIC);

    for (SourceGroup group : groups) {
      String folder = group.getRootFolder().getPath();

      if (path.startsWith(folder)) {
        return removeSrcPrefix(path.substring(folder.length()));
      }
    }
    return removeSrcPrefix(path);
  }

  /**{@inheritDoc}*/
  public static FileObject createFile(
    FileObject folder,
    String name,
    String text) throws IOException
  {
    FileObject file = null;
    FileLock lock = null;

    try {
      file = folder.createData(name);
      lock = file.lock();
      BufferedWriter writer = new BufferedWriter(
        new OutputStreamWriter(file.getOutputStream(lock)));
      writer.write(text);
      writer.close();
    }
    catch (IOException e) {
      throw e;
    }
    catch (IllegalArgumentException e) {
      throw new IOException(
        org.openide.util.NbBundle.getMessage(Util.class, "ERR_Illegal_Argument", e.getMessage())); // NOI18N
    }
    finally {
      if (lock != null) {
        lock.releaseLock();
      }
    }
    return file;
  }

  /**{@inheritDoc}*/
  public static WSDLModel getWSDLModel(FileObject file) {
    if (file == null) {
      return null;
    }
    ModelSource source = Utilities.getModelSource(file, file.canWrite());
    return WSDLModelFactory.getDefault().getModel(source);
  }

  /**{@inheritDoc}*/
  public static FileObject getFileObject(SchemaModel model) {
    if (model== null) {
      return null;
    }
    ModelSource source = model.getModelSource();
    return (FileObject) source.getLookup().lookup(FileObject.class);
  }

  /**{@inheritDoc}*/
  public static String generatePrefix(WSDLModel model) {
    return NameGenerator.getInstance().generateNamespacePrefix(null, model);
  }
  
  /**{@inheritDoc}*/
  public static void saveModel(WSDLModel model) {
    DataObject dataObject = (DataObject) model.getModelSource().
      getLookup().lookup(DataObject.class);

    if (dataObject == null) {
      return;
    }
    SaveCookie save = (SaveCookie) dataObject.getCookie(SaveCookie.class);

    if (save == null) {
      return;
    }
    try {
      save.save();
      dataObject.setModified(false);
    }
    catch (IOException e) {
      return;
    }
  }

  private static String removeSrcPrefix(String name) {
    if (name.startsWith(SLASHED_SRC)) {
      return name.substring(SLASHED_SRC.length());
    }
    return name;
  }

  // ---------------------------
  public static class WSDLFile {
    public WSDLFile(FileObject file, Project project) {
      myFile = file;
      myProject = project;
    }

    public FileObject getFile() {
      return myFile;
    }

    public String getName() {
      return
        "[" + ProjectUtils.getInformation(myProject).getDisplayName() + // NOI18N
        "] " + calculateRelativeName(myFile, myProject); // NOI18N
    }
    
    private FileObject myFile;
    private Project myProject;
  }

  private static final String SRC_FOLDER = "src"; // NOI18N
  private static final String SLASHED_SRC = "/" + SRC_FOLDER + "/"; // NOI18N
}
