package it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.impl;

import it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.CorbaComponent;
import it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.CorbaMessage;
import it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.CorbaQName;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.w3c.dom.Element;

public class CorbaMessageImpl extends CorbaComponentImpl
        implements CorbaMessage {

    private static final Attribute CONTENUTO = new Attribute() {

        public Class getMemberType() {
            return null;
        }

        public String getName() {
            return ATTR_CORBA_CONTENUTO;
        }

        public Class getType() {
            return String.class;
        }
    };

    public CorbaMessageImpl(WSDLModel model, Element e) {
        super(model, e);
    }

    public CorbaMessageImpl(WSDLModel model){
        this(model,
             createPrefixedElement(CorbaQName.MESSAGE.getQName(), model));
    }

    public void accept(CorbaComponent.Visitor visitor) {
        visitor.visit(this);
    }

    public String getContenuto() {
        return getAttribute(CONTENUTO);
    }

    public void setContenuto(String contenuto) {
        setAttribute(ATTR_CORBA_CONTENUTO, CONTENUTO, contenuto);
    }
}
