/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */


package org.netbeans.modules.aspect.editor.multiview;

import java.io.Serializable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectInput;

import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.windows.TopComponent;
import org.openide.util.Utilities;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

import org.netbeans.modules.aspect.editor.dataobject.AspectDataObject;

/**
 *
 * @author Jeri Lockhart
 */
public class AspectGraphMultiViewDesc extends Object
    implements MultiViewDescription, Serializable {


    /**
     *
     */
    private static final long serialVersionUID = 2580263536201519563L;
    public static final String PREFERRED_ID = "aspect-graphview";
    private AspectDataObject obj;

    /**
     *
     *
     */
    public AspectGraphMultiViewDesc() {
        super();
    }


    /**
     *
     *
     */
    public AspectGraphMultiViewDesc(AspectDataObject obj) {
        this.obj = obj;
    }


    /**
     *
     *
     */
    public String preferredID() {
        return PREFERRED_ID;
    }


    /**
     *
     *
     */
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_NEVER;
    }


    /**
     *
     *
     */
    public java.awt.Image getIcon() {
        return Utilities.loadImage(AspectDataObject.ASPECT_ICON_BASE_WITH_EXT);
    }


    /**
     *
     *
     */
    public org.openide.util.HelpCtx getHelpCtx() {
        return new HelpCtx(getClass().getName());
    }


    /**
     *
     *
     */
    public String getDisplayName() {
        return NbBundle.getMessage(AspectGraphMultiViewDesc.class,
            "LBL_designView_name");
    }


    /**
     *
     *
     */
    public MultiViewElement createElement() {
            return new AspectGraphMultiViewElement(obj);
    }


    /**
     *
     *
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(obj);
    }


    /**
     *
     *
     */
    public void readExternal(ObjectInput in)
        throws IOException, ClassNotFoundException
    {
        Object firstObject = in.readObject();
        if (firstObject instanceof AspectDataObject)
            obj = (AspectDataObject) firstObject;
    }
}
