/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.model;

/**
 * This class represents Input model
 * @author karthikeyan s
 */
public class Input extends ServiceDescription {
    
    private String partnerLink;
    
    private String roleName;    
    
    /** Creates a new instance of Input */
    public Input(String partnerLink, String roleName, String portType, String operation, String messageType) {
        super(operation, portType, messageType);
        this.partnerLink = partnerLink;
        this.roleName = roleName;
    }
    
    public void setPartnerLink(String partnerLink) {
        this.partnerLink = partnerLink;
    }
    
    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }
    
    public String getPartnerLink() {
        return this.partnerLink;
    }
    
    public String getRoleName() {
        return this.roleName;
    }
    
    public String toXmlString() {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("\t<" + AspectMap.INPUT_ELEMENT + "\n\t" + AspectMap.PARTNERLINK_ATTR + "=\"" 
                + getPartnerLink() + "\" \n\t" + AspectMap.ROLE_NAME_ATTR + "=\"" +
                getRoleName() + "\" \n\t" + AspectMap.PORTTYPE_ATTR + "=\"" + getPortType() + "\" \n\t" +
                AspectMap.OPERATION_ATTR + "=\"" + getOperation() +"\" \n\t" + AspectMap.MESSAGE_TYPE_ATTR +
                "=\"" + getMessageType() + "\" />");
        return xmlString.toString();
    }    
}