/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph.panels;

import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;

import org.netbeans.modules.aspect.editor.model.Advice;
/**
 *
 * @author  karthikeyan s
 */
public class EditAdvicePropertiesPanel extends PropertiesEditorPanel {
         
    /** Creates new form EditAdvicePropertiesPanel */
    //public EditAdvicePropertiesPanel(Advice adv) { JAXB
    public EditAdvicePropertiesPanel(AdviceType adv) {
        super(adv);
        initComponents();
        init();
    }
    
    private void init() {
        //Map<String, String> props = advice.getPropertiesModel().getConfig().getProperties(); JAXB
        Map<String, String> props = AspectMapBuilder.getAspectMapBuilder().getAdviceProperties(advice);
        Object[] header = new Object[2];
        header[0] = "Name";
        header[1] = "Value";      
        int i = 0;
        final DefaultTableModel model = new DefaultTableModel(header, props.size());
        Iterator it = props.keySet().iterator();
        while(it.hasNext()) {
            String key = (String)it.next();
            String value = props.get(key);
            model.setValueAt(key, i, 0);
            model.setValueAt(value, i++, 1);
        }
        SwingUtilities.invokeLater(new Runnable(){
            public void run() {
                jTable1.setModel(model);
            }
        }); 
    }
    
    //public Advice getAdvice() { JAXB
    public AdviceType getAdvice() {
        return advice;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        propName = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        propValue = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        propTable = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jButton2 = new javax.swing.JButton();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(EditAdvicePropertiesPanel.class, "EditAdvicePropertiesPanel.jLabel1.text")); // NOI18N

        propName.setText(org.openide.util.NbBundle.getMessage(EditAdvicePropertiesPanel.class, "EditAdvicePropertiesPanel.propName.text")); // NOI18N

        jLabel2.setText(org.openide.util.NbBundle.getMessage(EditAdvicePropertiesPanel.class, "EditAdvicePropertiesPanel.jLabel2.text")); // NOI18N

        propValue.setText(org.openide.util.NbBundle.getMessage(EditAdvicePropertiesPanel.class, "EditAdvicePropertiesPanel.propValue.text")); // NOI18N

        jButton1.setText(org.openide.util.NbBundle.getMessage(EditAdvicePropertiesPanel.class, "EditAdvicePropertiesPanel.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jButton1)
                    .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(jPanel1Layout.createSequentialGroup()
                            .add(jLabel1)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(propName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 140, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(jPanel1Layout.createSequentialGroup()
                            .add(jLabel2)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(propValue)))))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(propName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(propValue, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jButton1)
                .addContainerGap())
        );

        propTable.setAutoscrolls(true);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Title 1", "Title 2"
            }
        ));
        jTable1.setToolTipText(org.openide.util.NbBundle.getMessage(EditAdvicePropertiesPanel.class, "EditAdvicePropertiesPanel.jTable1.toolTipText")); // NOI18N
        propTable.setViewportView(jTable1);

        jButton2.setText(org.openide.util.NbBundle.getMessage(EditAdvicePropertiesPanel.class, "EditAdvicePropertiesPanel.jButton2.text")); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addContainerGap())
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(jButton2)
                            .add(propTable, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 222, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(14, 14, 14))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(propTable, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 111, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButton2))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

        String name = propName.getText().trim();
        String value = propValue.getText().trim();
        //advice.getPropertiesModel().getConfig().setProperties(name, value); JAXB
        AspectMapBuilder.getAspectMapBuilder().setAdviceProperties(advice,name,value);
        final DefaultTableModel model = (DefaultTableModel)jTable1.getModel();
        Object[] obj = new Object[2];
        obj[0] = name;
        obj[1] = value;
        model.addRow(obj);
        SwingUtilities.invokeLater(new Runnable(){
           public void run() {
               jTable1.setModel(model);
           } 
        });
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed

        int[] rows = jTable1.getSelectedRows();
        final DefaultTableModel model = (DefaultTableModel) jTable1.getModel();
        for(int i = 0; i < rows.length; i++) {
            int row = rows[i];
            String key = (String)model.getValueAt(row, 0);
            //advice.getPropertiesModel().getConfig().removeProperty(key); JAXB
            AspectMapBuilder.getAspectMapBuilder().removeAdviceProperty(advice, key);
            model.removeRow(row);
        }
        SwingUtilities.invokeLater(new Runnable(){
           public void run() {
               jTable1.setModel(model);
           } 
        });
    }//GEN-LAST:event_jButton2ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JButton jButton1;
    javax.swing.JButton jButton2;
    javax.swing.JLabel jLabel1;
    javax.swing.JLabel jLabel2;
    javax.swing.JPanel jPanel1;
    javax.swing.JTable jTable1;
    javax.swing.JTextField propName;
    javax.swing.JScrollPane propTable;
    javax.swing.JTextField propValue;
    // End of variables declaration//GEN-END:variables
    
}
