/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph.panels;

import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.netbeans.modules.aspect.editor.jaxbutils.Utiltools;

/**
 *
 * @author  karthikeyan s
 */
public class AddAdvicePanel extends javax.swing.JPanel {
    
    //private List<Advice> list; JAXB
    private List<AdviceType> list;
    
    /** Creates new form AddAdvicePanel */
    public AddAdvicePanel() {
        initComponents();
        /*
        //list = new ArrayList<Advice>(); //JAXB
        list = new ArrayList<AdviceType>();  
        adviceCombo.addItemListener(new ItemListener(){
            public void itemStateChanged(ItemEvent e) {
                if(e.getItem() != null) {
                    String selectedItem = (String)e.getItem();
                    adviceName.setEnabled(false);
                    if(selectedItem.equals("others")) {
                        adviceName.setEnabled(true);                        
                    } else if(selectedItem.equalsIgnoreCase("contentBasedRouting") ||
                            selectedItem.equalsIgnoreCase("tee")){
                        insertAfter.removeAllItems();
                        insertAfter.addItem(list.get(list.size() - 1).getType() +
                                ";OrderNo:" + list.get(list.size() - 1).getOrder());
                    }
                }
            }            
        });
        */
    }
    
    
    //public void populateComboBox(List<Advice> objects) { //JAXB
    public void populateComboBox(List<AdviceType> objects) {
        //list = Util.getSortedAdviceList(objects); JAXB
        list = Utiltools.getSortedAdviceList(objects);
        insertAfter.addItem("Input");
        Iterator it = list.iterator();
        while(it.hasNext()) {
            //Advice adv = (Advice)it.next(); JAXB
            AdviceType adv = (AdviceType)it.next();
            //insertAfter.addItem(adv.getType() + ";OrderNo:" + adv.getOrderNo()); //JAXB
            insertAfter.addItem(adv.getType() + ";OrderNo:" + adv.getOrder());
        }
    }
    
    public Object getInsertAfter() {
        if(insertAfter.getSelectedIndex() == 0) {
            return "input";
        }
        String selectedData = ((String)insertAfter.getSelectedItem());
        String orderNo = selectedData.substring(selectedData.lastIndexOf(":") + 1);
        //Advice result = null; JAXB
        AdviceType result = null;
        Iterator it = list.iterator();
        while(it.hasNext()) {
            //Advice adv = (Advice)it.next(); //JAXB
            AdviceType adv = (AdviceType)it.next();
            //if(adv.getOrderNo().equalsIgnoreCase(orderNo)) { //JAXB
            if(Byte.toString(adv.getOrder()).equalsIgnoreCase(orderNo)) {
                result = adv;
            }
        }
        return result;
    }    
    
    /*
    public String getAdviceType() {
        if(adviceCombo.getSelectedItem().equals("others")){
            return adviceName.getText().trim();
        }
        return (String) adviceCombo.getSelectedItem();
    }
     */ 
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        insertAfter = new javax.swing.JComboBox();

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jLabel4)
                .add(13, 13, 13)
                .add(insertAfter, 0, 140, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(jLabel4)
                .add(insertAfter, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(104, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JComboBox insertAfter;
    javax.swing.JLabel jLabel4;
    javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
    
}
