/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph;

import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 *
 * @author karthikeyan s
 */
public class GraphUtil {
    
    /** Creates a new instance of GraphUtil */
    public GraphUtil() {
    }
    
    public static String[] getDialogData(AspectEditorPane.Nodes node, Object model) {
        List<JTextField> lst = new ArrayList<JTextField>();
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        Object[] obj = null;
        String[] data = null;
        JPanel panel = new JPanel();
        JLabel label = null;
        panel.setBorder(BorderFactory.createEtchedBorder());
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gl);
        
        ResultSetMetaData meta = null;
        switch(node) {
            case INPUT:                
                lst.add(addTextField("PartnerLink", "Partner Link", "Partner Link",panel, c));
                lst.add(addTextField("PortName", "Port Name","PortName", panel, c));
                lst.add(addTextField("PortType", "Port Type","Port Type", panel, c));
                lst.add(addTextField("MessageType", "Message Type", "Message Type", panel, c));
                lst.add(addTextField("Operation", "Operation", "Operation", panel, c));
                break;
            case ADVICE:
                lst.add(addTextField("PartnerLink", "Partner Link", "Partner Link",panel, c));
                lst.add(addTextField("PortName", "Port Name","PortName", panel, c));
                lst.add(addTextField("PortType", "Port Type","Port Type", panel, c));
                lst.add(addTextField("MessageType", "Message Type", "Message Type", panel, c));
                lst.add(addTextField("Operation", "Operation", "Operation", panel, c));                
                break;
        }
        DialogDescriptor desc = new DialogDescriptor(panel, "Enter the Values");
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        dialog.setModal(true);
        dialog.pack();
        dialog.setVisible(true);
        if(desc.getValue()== NotifyDescriptor.OK_OPTION) {
            String msg = "";
            for(int i = 0; i < lst.size(); i++) {
                JTextField textField = lst.get(i);
                try {
                    for(int j = 1; j <= meta.getColumnCount(); j++) {
                        if(meta.getColumnName(j).equals(textField.getName())) {
                            if(meta.getColumnClassName(j).equals("java.lang.String")) {
                                data[j-1] = "'" + textField.getText() + "'";
                            } else if(meta.getColumnType(j) == java.sql.Types.DATE) {
                                data[j-1]  = "{d'" + textField.getText() + "'}";
                            } else if(meta.getColumnType(j) == java.sql.Types.TIME) {
                                data[j-1]  = "{t'" + textField.getText() +"'}";
                            } else if(meta.getColumnClassName(j).equals("java.math.BigDecimal")){
                                data[j-1] = textField.getText();
                            } else if(meta.getColumnClassName(j).equals("java.math.BigInteger")){
                                data[j-1] = textField.getText();
                            } else {
                                data[j-1] = "'" + textField.getText() + "'";
                            }
                            break;
                        }
                    }
                } catch (SQLException ex) {
                    //ignore
                }
            }
        } else {
            data = null;
        }
        return data;
    }
    
    private static JTextField addTextField(String name, String lbl, String tooltip, JPanel panel, GridBagConstraints c) {
        JLabel label = new JLabel(lbl + ":");
        JTextField ptr = new JTextField();
        ptr.setToolTipText(tooltip);
        ptr.setName(name);
        label.setLabelFor(ptr);
        c.weightx = 0.35;
        c.gridwidth = GridBagConstraints.RELATIVE;
        c.fill = GridBagConstraints.HORIZONTAL;
        panel.add(label, c);
        c.weightx = 0.65;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = GridBagConstraints.REMAINDER;
        panel.add(ptr, c);
        return ptr;
    }    
}