/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.iep.editor.model;

import org.netbeans.modules.iep.editor.tcg.exception.ParseXmlException;
import org.netbeans.modules.iep.editor.tcg.model.TcgComponent;
import org.netbeans.modules.iep.editor.tcg.model.TcgProperty;
import org.netbeans.modules.iep.editor.tcg.util.NameUtil;
import java.io.File;
import java.util.WeakHashMap;
import org.openide.loaders.DataObject;


/**
 * Description: The ModelManager class This is the main class, which loads
 * the data from library.xml and build the component hierarchy similar to xml
 * file but different objects. component_library = TcgComponentTypeGroup
 * component_type_group = TcgComponentTypeGroup component_type = TcgComponentType
 * property = PropertyType
 *
 * @author Bing Lu
 *
 */
public class ModelManager implements ModelConstants {
    private static final java.util.logging.Logger mLog = java.util.logging.Logger.getLogger(ModelManager.class.getName());

    // UTF-8
    public static TcgComponent getModel(DataObject doc) throws ParseXmlException {
        if (doc == null) {
            return null;
        }    
        return new ModelImpl(doc);
    }    
     
    public static TcgComponent getModel(File file) throws ParseXmlException {
        if (file == null) {
            return null;
        }
        return new ModelImpl(file);
    }
            
    //==========================================================================
    public static String getDocFullName(Object doc) {
        if (doc instanceof DataObject) {
            return NameUtil.makeJavaId(((DataObject)doc).getPrimaryFile().getPath());
        }
        if (doc instanceof File) {
            return NameUtil.makeJavaId(((File)doc).getPath());
        }
        return null;
    }
    
    public static String getDocExtName(Object doc) {
        if (doc instanceof DataObject) {
            return NameUtil.makeJavaId(((DataObject)doc).getPrimaryFile().getNameExt());
        }
        if (doc instanceof File) {
            return NameUtil.makeJavaId(((File)doc).getName());
        }
        return null;
    }
    
    public static Object getDoc(TcgProperty prop) {
        Object ret = null;
        if (prop != null) {
            try {
                //mLog.debug("DocManager.getDoc prop: " + prop.getName());
                TcgComponent comp = prop.getParentComponent();
                ret = getDoc(comp);
            } catch (Exception e) {
                mLog.warning("Exception: " + e);
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static Object getDoc(TcgComponent comp) {
        Object ret = null;
        if (comp != null) {
            try {
                //mLog.debug("ModelManager.getDoc comp: " + comp.getName());
                comp = comp.getRoot();
                TcgProperty prop = comp.getProperty(DOC_KEY);
                if (prop != null) {
                    ret = (DataObject) prop.getValue();
                } else {
                    mLog.warning("model is null; returning null " + org.netbeans.modules.iep.editor.tcg.util.TraceUtil.getTrace(10));
                }
            } catch (Exception e) {
                mLog.warning("Exception: " + e);
                e.printStackTrace();
            }
        }
        return ret;
    }
    
    
    //=========================Model=========================================
    private static WeakHashMap mDoc2Model = new WeakHashMap();

    public static void destroyModel(Model model) {
        if (model != null) {
            Object doc = model.getDoc();
            mDoc2Model.remove(doc);
            model.destroy();
        }
    }

    //=======================Plan=============================================    
    public static Plan getPlan(DataObject doc) {
        try {
            Plan model = (Plan) mDoc2Model.get(doc);
            if (model == null) {
                model = new PlanImpl(doc);
                mDoc2Model.put(doc, model);
            }
            return model;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
    
    // Used by org.netbeans.modules.iep.project.anttasks.GenerateAsaArtifacts
    public static Plan getPlan(File doc) {
        try {
            Plan model = new PlanImpl(doc);
            return model;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
    
    //==================== Schema ================================================
    public static Schema createSchema(String name) {
        TcgComponent newComp = SCHEMA_TYPE.newTcgComponent(name, name);
        return new SchemaImpl(newComp);
    }
    
    public static Schema getSchema(TcgComponent component) {
        return new SchemaImpl(component);
    }
    
    //==================== AttributeMetadata ========================================
    public static AttributeMetadata createColumnMetadata(String name, String type, int size, int scale) {
        AttributeMetadata cm = new AttributeMetadataImpl();
        try {
            cm.getProperty(NAME_KEY).setValue(name);
            cm.getProperty(TYPE_KEY).setValue(type);
            if (size >= 0) {
                cm.getProperty(SIZE_KEY).setValue(new Integer(size));
                if (scale >= 0) {
                    cm.getProperty(SCALE_KEY).setValue(new Integer(scale));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return cm;        
    }
    public static AttributeMetadata createColumnMetadata(String name, String type, int size) {
        return createColumnMetadata(name, type, size, -1);
    }
    public static AttributeMetadata createColumnMetadata(String name, String type) {
        return createColumnMetadata(name, type, -1, -1);
    }

}