/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.model.visitors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.netbeans.modules.model.database.DBColumn;
import org.netbeans.modules.model.database.DBTable;
import org.netbeans.modules.model.database.DatabaseModel;
import org.netbeans.modules.sql.framework.model.SQLDBColumn;
import org.netbeans.modules.sql.framework.model.SQLDBModel;
import org.netbeans.modules.sql.framework.model.SQLDBTable;
import org.netbeans.modules.sql.framework.model.SQLDefinition;
import org.netbeans.modules.sql.framework.model.ValidationInfo;
import org.netbeans.modules.sql.framework.model.impl.ValidationInfoImpl;
import org.openide.util.NbBundle;

import com.sun.sql.framework.utils.StringUtil;

/**
 * @author Girish Patil
 * @version $Revision: 1.2 $
 */
public class SQLOTDSynchronizationValidationVisitor {
    private List validationInfoList = new ArrayList();

    public List getValidationInfoList() {
        return this.validationInfoList;
    }

    public void visit(SQLDBModel etlDBModel) {
        DatabaseModel otd = (DatabaseModel) etlDBModel.getSource();

        if (otd != null) {
            List otdTables = otd.getTables();
            List collabTables = etlDBModel.getTables();

            if ((collabTables != null) && (!collabTables.isEmpty())) {
                Iterator itr = collabTables.iterator();
                SQLDBTable collabTable = null;
                while (itr.hasNext()) {
                    collabTable = (SQLDBTable) itr.next();
                    checkCollabTableForChanges(collabTable, otdTables);
                }
            }
        }
    }

    public void visit(SQLDefinition definition) {
        List collabOtds = definition.getAllOTDs();
        if ((collabOtds != null) && (collabOtds.size() > 0)) {
            SQLDBModel etlDBModel = null;
            Iterator itr = collabOtds.iterator();
            while (itr.hasNext()) {
                etlDBModel = (SQLDBModel) itr.next();
                visit(etlDBModel);
            }
        }
    }

    private void checkCollabColumnForChanges(SQLDBColumn collabColumn, List otdColumns, SQLDBTable table) {
        Iterator itr = otdColumns.iterator();
        DBColumn otdColumn = null;
        boolean columnMatched = true;

        while (itr.hasNext()) {
            otdColumn = (DBColumn) itr.next();
            columnMatched = (collabColumn.compareTo(otdColumn) == 0);
            if (columnMatched) {
                break;
            }
        }

        if (!columnMatched) {
            // Column not present or is modified in OTD
            String desc = NbBundle.getMessage(this.getClass(), "MSG_column_not_found", collabColumn.getName(), table.getName());
            ValidationInfo vInfo = new ValidationInfoImpl(table, desc, ValidationInfo.VALIDATION_ERROR);
            this.validationInfoList.add(vInfo);
        }
    }

    private void checkCollabTableForChanges(SQLDBTable collabTable, List otdTables) {
        String catalog = collabTable.getCatalog();
        String schema = collabTable.getSchema();
        String tableName = collabTable.getName();

        if ((otdTables != null) && (otdTables.size() > 0)) {
            Iterator itr = otdTables.iterator();
            DBTable otdTable = null;
            boolean catlogMatched = false;
            boolean schemaMatched = false;
            boolean tableNameMatched = false;

            while (itr.hasNext()) {
                otdTable = (DBTable) itr.next();
                catlogMatched = false;
                schemaMatched = false;
                tableNameMatched = false;

                catlogMatched = StringUtil.isIdentical(catalog, otdTable.getCatalog(), true);

                if (catlogMatched) {
                    schemaMatched = StringUtil.isIdentical(schema, otdTable.getSchema(), true);
                    if (schemaMatched) {
                        tableNameMatched = StringUtil.isIdentical(tableName, otdTable.getName());

                        if (catlogMatched && schemaMatched && tableNameMatched) {
                            compareCollabTableWithOtdTable(collabTable, otdTable);
                            break;
                        }
                    }
                }
            }

            if (!tableNameMatched) {
                // Table is removed or renamed in OTD.
                String desc = NbBundle.getMessage(this.getClass(), "MSG_table_not_found", collabTable.getName());
                ValidationInfo vInfo = new ValidationInfoImpl(collabTable, desc, ValidationInfo.VALIDATION_ERROR);
                this.validationInfoList.add(vInfo);
            }
        }
    }

    private void compareCollabTableWithOtdTable(SQLDBTable collabTable, DBTable otdTable) {
        List collabColumns = collabTable.getColumnList();
        List otdColumns = otdTable.getColumnList();
        Iterator itr = collabColumns.iterator();
        SQLDBColumn collabColumn = null;

        while (itr.hasNext()) {
            collabColumn = (SQLDBColumn) itr.next();
            checkCollabColumnForChanges(collabColumn, otdColumns, collabTable);
        }
    }
}
