/* The following code was generated by JFlex 1.4_5 on 2/14/06 12:57 AM */

/* SQLLexer.java is a generated file.  You probably want to
 * edit SQLLexer.lex to make changes.  Use JFlex to generate it.
 * To generate SQLLexer.java
 * Install <a href="http://jflex.de/">JFlex</a> v1.3.2 or later.
 * Once JFlex is in your classpath run<br>
 * <code>java JFlex.Main SQLLexer.lex</code><br>
 * You will then have a file called SQLLexer.java
 */
package org.netbeans.modules.sql.framework.highlighter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * SQLLexer is a SQL language lexer.  Created with JFlex.  An example of how it is used:
 *  <CODE>
 *  <PRE>
 *  SQLLexer shredder = new SQLLexer(System.in);
 *  SQLToken t;
 *  while ((t = shredder.getNextToken()) != null){
 *      System.out.println(t);
 *  }
 *  </PRE>
 *  </CODE>
 *
 * @see SQLToken
 */


public class SQLLexer implements Lexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int YY_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 1;

  /** 
   * Translates characters to character classes
   */
  private static final char [] yycmap = {
     0,  0,  0,  0,  0,  0,  0,  0,  0, 29, 38,  0, 29, 38,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    29, 36, 34, 36, 35, 36, 36, 37, 32, 32, 36, 40, 32, 25, 33, 36, 
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 31, 31, 36, 36, 36, 36, 
    36,  1,  2, 10, 13,  9, 15, 16, 20, 11, 28, 21,  7, 14, 12,  3, 
    24, 27,  4,  6,  5,  8, 19, 22, 26, 17, 18, 34, 39, 34, 36, 23, 
    36,  1,  2, 10, 13,  9, 15, 16, 20, 11, 28, 21,  7, 14, 12,  3, 
    24, 27,  4,  6,  5,  8, 19, 22, 26, 17, 18,  0, 36,  0, 36,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  };

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] YY_ACTION = yy_unpack_YY_ACTION();

  private static final String YY_ACTION_packed0 =
    "\1\1\1\0\12\2\1\3\3\2\1\3\1\2\1\3"+
    "\4\2\1\3\1\2\1\4\1\2\1\5\1\2\1\1"+
    "\1\6\1\7\1\10\1\11\2\5\1\4\2\2\2\3"+
    "\16\2\1\3\1\2\1\3\4\2\2\3\10\2\1\3"+
    "\47\2\1\3\1\2\1\3\4\2\1\3\4\2\1\3"+
    "\20\2\1\3\26\2\1\12\1\2\1\0\1\6\1\13"+
    "\1\0\1\6\1\14\1\0\1\2\1\3\6\2\1\3"+
    "\15\2\1\3\3\2\1\3\3\2\1\3\5\2\1\3"+
    "\10\2\1\3\25\2\1\3\17\2\1\3\26\2\1\3"+
    "\40\2\1\3\14\2\1\3\14\2\1\3\6\2\2\3"+
    "\3\2\2\3\23\2\1\3\14\2\1\0\1\6\30\2"+
    "\1\3\20\2\2\3\35\2\1\3\7\2\1\0\2\2"+
    "\1\3\7\2\1\3\17\2\1\3\21\2\1\3\1\2"+
    "\2\3\3\2\1\3\23\2\1\3\13\2\2\3\12\2"+
    "\1\6\30\2\1\3\10\2\1\3\25\2\1\3\5\2"+
    "\1\0\22\2\1\3\3\2\1\3\35\2\1\3\23\2"+
    "\1\3\21\2\1\3\10\2\1\0\1\3\11\2\2\3"+
    "\35\2\1\3\21\2\1\0\1\3\3\2\1\3\4\2"+
    "\1\3\10\2\1\3\17\2\1\3\2\2\1\3\27\2"+
    "\1\3\7\2\1\3\4\2\1\3\7\2\1\3\12\2"+
    "\1\3\54\2\1\3\23\2";

  private static int [] yy_unpack_YY_ACTION() {
    int [] result = new int[943];
    int offset = 0;
    offset = yy_unpack_YY_ACTION(YY_ACTION_packed0, offset, result);
    return result;
  }

  private static int yy_unpack_YY_ACTION(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] yy_rowMap = yy_unpack_yy_rowMap();

  private static final String yy_rowMap_packed0 =
    "\0\0\0\51\0\122\0\173\0\244\0\315\0\366\0\u011f"+
    "\0\u0148\0\u0171\0\u019a\0\u01c3\0\u01ec\0\u0215\0\u023e\0\u0267"+
    "\0\u0290\0\u02b9\0\u02e2\0\u030b\0\u0334\0\u035d\0\u0386\0\u03af"+
    "\0\u03d8\0\u0401\0\u042a\0\u0453\0\u047c\0\u04a5\0\u04ce\0\u0401"+
    "\0\u04f7\0\u0401\0\u0520\0\u0401\0\u0549\0\u0572\0\u059b\0\u05c4"+
    "\0\u05ed\0\u0616\0\u063f\0\u0668\0\u0691\0\u06ba\0\u06e3\0\u070c"+
    "\0\u0735\0\u075e\0\u0787\0\u07b0\0\u07d9\0\u0802\0\u082b\0\122"+
    "\0\u0854\0\u087d\0\u08a6\0\u08cf\0\u08f8\0\u0921\0\u094a\0\u0973"+
    "\0\u099c\0\u09c5\0\u09ee\0\u0a17\0\u0a40\0\u0a69\0\u0a92\0\u0abb"+
    "\0\u0ae4\0\u0b0d\0\u0b36\0\u0b5f\0\u0b88\0\u0bb1\0\u0bda\0\u0c03"+
    "\0\u0c2c\0\u0c55\0\u0c7e\0\u0ca7\0\u0cd0\0\u0cf9\0\u0d22\0\u0d4b"+
    "\0\u0d74\0\u0d9d\0\u0dc6\0\u0def\0\u0e18\0\u0e41\0\u0e6a\0\u0e93"+
    "\0\u0ebc\0\u0ee5\0\u0f0e\0\u0f37\0\u0f60\0\u0f89\0\u0fb2\0\u0fdb"+
    "\0\u1004\0\u102d\0\u1056\0\u107f\0\u10a8\0\u10d1\0\u10fa\0\u1123"+
    "\0\u114c\0\u1175\0\u119e\0\u11c7\0\u11f0\0\u1219\0\u1242\0\u126b"+
    "\0\u1294\0\u12bd\0\u12e6\0\u130f\0\u1338\0\u1361\0\u138a\0\u13b3"+
    "\0\u13dc\0\u1405\0\u142e\0\u1457\0\u1480\0\u14a9\0\u14d2\0\u14fb"+
    "\0\u1524\0\u154d\0\u1576\0\u159f\0\u15c8\0\u15f1\0\u161a\0\u1643"+
    "\0\u166c\0\u1695\0\u16be\0\u16e7\0\u1710\0\u1739\0\u1762\0\u178b"+
    "\0\u17b4\0\u17dd\0\u1806\0\u182f\0\u1858\0\u1881\0\u18aa\0\u18d3"+
    "\0\u18fc\0\u1925\0\u194e\0\u1977\0\u19a0\0\u19c9\0\u19f2\0\u1a1b"+
    "\0\u1a44\0\u0549\0\u0401\0\u0401\0\u1a6d\0\u1a96\0\u1abf\0\u1ae8"+
    "\0\u1b11\0\u1b3a\0\u1b63\0\u1b8c\0\u1bb5\0\u1bde\0\u1c07\0\u1c30"+
    "\0\u1c59\0\u1c82\0\u1cab\0\u1cd4\0\u1cfd\0\u1d26\0\u1d4f\0\u1d78"+
    "\0\u1da1\0\u1dca\0\u1df3\0\u1e1c\0\u1e45\0\u1e6e\0\u1e97\0\u1ec0"+
    "\0\u1ee9\0\u1f12\0\u1f3b\0\u1f64\0\u1f8d\0\u1fb6\0\u1fdf\0\u2008"+
    "\0\u2031\0\u205a\0\u2083\0\u20ac\0\u20d5\0\u20fe\0\u2127\0\u2150"+
    "\0\u2179\0\u21a2\0\u21cb\0\u21f4\0\u221d\0\u2246\0\u226f\0\u2298"+
    "\0\u22c1\0\u22ea\0\u2313\0\u233c\0\u2365\0\u238e\0\u23b7\0\u23e0"+
    "\0\u2409\0\u2432\0\u245b\0\u2484\0\u24ad\0\u24d6\0\u24ff\0\u2528"+
    "\0\u2551\0\u257a\0\u25a3\0\u25cc\0\u25f5\0\u261e\0\u2647\0\u2670"+
    "\0\u2699\0\u26c2\0\u26eb\0\u2714\0\u273d\0\u2766\0\u278f\0\u27b8"+
    "\0\u27e1\0\u280a\0\u2833\0\u285c\0\u2885\0\u28ae\0\u28d7\0\u2900"+
    "\0\u2929\0\u2952\0\u297b\0\u29a4\0\u29cd\0\u29f6\0\u2a1f\0\u2a48"+
    "\0\u2a71\0\u2a9a\0\u2ac3\0\u2aec\0\u2b15\0\u2b3e\0\u2b67\0\u2b90"+
    "\0\u2bb9\0\u2be2\0\u2c0b\0\u2c34\0\u2c5d\0\u2c86\0\u2caf\0\u2cd8"+
    "\0\u2d01\0\u2d2a\0\u2d53\0\u2d7c\0\u2da5\0\u2dce\0\u2df7\0\u2e20"+
    "\0\u2e49\0\u2e72\0\u2e9b\0\u2ec4\0\u2eed\0\u2f16\0\u2f3f\0\u2f68"+
    "\0\u2f91\0\u2fba\0\u2fe3\0\u300c\0\u3035\0\u305e\0\u3087\0\u30b0"+
    "\0\u30d9\0\u3102\0\u312b\0\u3154\0\u317d\0\u31a6\0\u31cf\0\u31f8"+
    "\0\u3221\0\u324a\0\u3273\0\u329c\0\u32c5\0\u32ee\0\u3317\0\u3340"+
    "\0\u3369\0\u3392\0\u33bb\0\u33e4\0\u340d\0\u3436\0\u345f\0\u3488"+
    "\0\u34b1\0\u34da\0\u3503\0\u352c\0\u3555\0\u357e\0\u35a7\0\u35d0"+
    "\0\u35f9\0\u3622\0\u364b\0\u3674\0\u369d\0\u36c6\0\u36ef\0\u3718"+
    "\0\u3741\0\u376a\0\u3793\0\u37bc\0\u37e5\0\u380e\0\u3837\0\u3860"+
    "\0\u3889\0\u38b2\0\u38db\0\u3904\0\u392d\0\u3956\0\u397f\0\u39a8"+
    "\0\u39d1\0\u39fa\0\u3a23\0\u3a4c\0\u3a75\0\u3a9e\0\u3ac7\0\u3af0"+
    "\0\u3b19\0\u3b42\0\u3b6b\0\u3b94\0\u3bbd\0\u3be6\0\u3c0f\0\u3c38"+
    "\0\u3c61\0\u0549\0\u3c8a\0\u3cb3\0\u3cdc\0\u3d05\0\u3d2e\0\u3d57"+
    "\0\u3d80\0\u3da9\0\u3dd2\0\u3dfb\0\u3e24\0\u3e4d\0\u3e76\0\u3e9f"+
    "\0\u3ec8\0\u3ef1\0\u3f1a\0\u3f43\0\u3f6c\0\u3f95\0\u3fbe\0\u3fe7"+
    "\0\u4010\0\u4039\0\u1f12\0\u4062\0\u408b\0\u40b4\0\u40dd\0\u4106"+
    "\0\u412f\0\u4158\0\u4181\0\u41aa\0\u41d3\0\u41fc\0\u4225\0\u424e"+
    "\0\u4277\0\u42a0\0\u42c9\0\u42f2\0\u431b\0\u4344\0\u436d\0\u4396"+
    "\0\u43bf\0\u43e8\0\u4411\0\u443a\0\u4463\0\u448c\0\u44b5\0\u44de"+
    "\0\u4507\0\u4530\0\u4559\0\u4582\0\u45ab\0\u45d4\0\u45fd\0\u4626"+
    "\0\u464f\0\u4678\0\u46a1\0\u46ca\0\u46f3\0\u471c\0\u4745\0\u476e"+
    "\0\u4797\0\u47c0\0\u47e9\0\u4812\0\u483b\0\u4864\0\u488d\0\u48b6"+
    "\0\u48df\0\u4908\0\u4931\0\u495a\0\u4983\0\u49ac\0\u49d5\0\u49fe"+
    "\0\u4a27\0\u4a50\0\u4a79\0\u4aa2\0\u4acb\0\u4af4\0\u4b1d\0\u4b46"+
    "\0\u4b6f\0\u4b98\0\u4bc1\0\u4bea\0\u4c13\0\u4c3c\0\u4c65\0\u4c8e"+
    "\0\u4cb7\0\u4ce0\0\u4d09\0\u4d32\0\u4d5b\0\u4d84\0\u4dad\0\u4dd6"+
    "\0\u4dff\0\u4e28\0\u4e51\0\u4e7a\0\u4ea3\0\u4ecc\0\u4ef5\0\u4f1e"+
    "\0\u4f47\0\u4f70\0\u4f99\0\u4fc2\0\u4feb\0\u5014\0\u503d\0\u5066"+
    "\0\u508f\0\u50b8\0\u50e1\0\u510a\0\u5133\0\u515c\0\u5185\0\u51ae"+
    "\0\u51d7\0\u5200\0\u5229\0\u5252\0\u527b\0\u52a4\0\u52cd\0\u52f6"+
    "\0\u531f\0\u5348\0\u5371\0\u539a\0\u53c3\0\u53ec\0\u5415\0\u543e"+
    "\0\u5467\0\u5490\0\u54b9\0\u54e2\0\u550b\0\u5534\0\u555d\0\u5586"+
    "\0\u55af\0\u55d8\0\u5601\0\u562a\0\u5653\0\u567c\0\u56a5\0\u56ce"+
    "\0\u56f7\0\u5720\0\u5749\0\u5772\0\u579b\0\u57c4\0\u57ed\0\u5816"+
    "\0\u583f\0\u5868\0\u3c61\0\u49ac\0\u5891\0\u58ba\0\u58e3\0\u590c"+
    "\0\u5935\0\u595e\0\u5987\0\u59b0\0\u59d9\0\u5a02\0\u5a2b\0\u5a54"+
    "\0\u5a7d\0\u5aa6\0\u5acf\0\u5af8\0\u5b21\0\u5b4a\0\u5b73\0\u5b9c"+
    "\0\u5bc5\0\u5bee\0\u5c17\0\u5c40\0\u5c69\0\u4af4\0\u5c92\0\u5cbb"+
    "\0\u5ce4\0\u5d0d\0\u5d36\0\u5d5f\0\u5d88\0\u5db1\0\u5dda\0\u5e03"+
    "\0\u5e2c\0\u5e55\0\u5e7e\0\u5ea7\0\u5ed0\0\u5ef9\0\u5f22\0\u5f4b"+
    "\0\u5f74\0\u5f9d\0\u5fc6\0\u5fef\0\u6018\0\u6041\0\u606a\0\u6093"+
    "\0\u60bc\0\u60e5\0\u610e\0\u6137\0\u6160\0\u6189\0\u61b2\0\u61db"+
    "\0\u6204\0\u622d\0\u6256\0\u627f\0\u62a8\0\u62d1\0\u62fa\0\u6323"+
    "\0\u634c\0\u6375\0\u639e\0\u63c7\0\u63f0\0\u6419\0\u6442\0\u646b"+
    "\0\u6494\0\u64bd\0\u64e6\0\u650f\0\u6538\0\u6561\0\u658a\0\u65b3"+
    "\0\u65dc\0\u6605\0\u662e\0\u5d88\0\u6657\0\u6680\0\u66a9\0\u66d2"+
    "\0\u66fb\0\u6724\0\u674d\0\u6776\0\u1bde\0\u679f\0\u67c8\0\u67f1"+
    "\0\u681a\0\u6843\0\u686c\0\u6895\0\u68be\0\u68e7\0\u6910\0\u6939"+
    "\0\u6962\0\u698b\0\u69b4\0\u69dd\0\u6a06\0\u39fa\0\u6a2f\0\u6a58"+
    "\0\u6a81\0\u6aaa\0\u6ad3\0\u6afc\0\u6b25\0\u6b4e\0\u6b77\0\u6ba0"+
    "\0\u6bc9\0\u6bf2\0\u6c1b\0\u6c44\0\u6c6d\0\u6c96\0\u6cbf\0\u6ce8"+
    "\0\u6d11\0\u6d3a\0\u6d63\0\u6d8c\0\u6db5\0\u6dde\0\u6e07\0\u6e30"+
    "\0\u6e59\0\u6e82\0\u6eab\0\u6ed4\0\u6efd\0\u6f26\0\u6f4f\0\u6f78"+
    "\0\u5c40\0\u6fa1\0\u6fca\0\u6ff3\0\u701c\0\u7045\0\u706e\0\u7097"+
    "\0\u70c0\0\u70e9\0\u7112\0\u713b\0\u7164\0\u1c59\0\u718d\0\u71b6"+
    "\0\u71df\0\u7208\0\u7231\0\u725a\0\u7283\0\u72ac\0\u72d5\0\u4277"+
    "\0\u72fe\0\u7327\0\u7350\0\u7379\0\u73a2\0\u73cb\0\u73f4\0\u741d"+
    "\0\u7446\0\u746f\0\u7498\0\u74c1\0\u74ea\0\u7513\0\u753c\0\u7565"+
    "\0\u758e\0\u75b7\0\u75e0\0\u7609\0\u7632\0\u765b\0\u7684\0\u76ad"+
    "\0\u76d6\0\u76ff\0\u7728\0\u7751\0\u777a\0\u77a3\0\u77cc\0\u77f5"+
    "\0\u781e\0\u7847\0\u7870\0\u7899\0\u78c2\0\u78eb\0\u7914\0\u793d"+
    "\0\u7966\0\u798f\0\u79b8\0\u79e1\0\u7a0a\0\u7a33\0\u7a5c\0\u7a85"+
    "\0\u7aae\0\u08a6\0\u7ad7\0\u7b00\0\u7b29\0\u7b52\0\u7b7b\0\u7ba4"+
    "\0\u7bcd\0\u7bf6\0\u7c1f\0\u7c48\0\u7c71\0\u7c9a\0\u7cc3\0\u7cec"+
    "\0\u7d15\0\u7d3e\0\u7d67\0\u7ba4\0\u7d90\0\u7db9\0\u7de2\0\u7e0b"+
    "\0\u7e34\0\u7e5d\0\u7e86\0\u7eaf\0\u7ed8\0\u7f01\0\u7f2a\0\u7f53"+
    "\0\u7f7c\0\u7fa5\0\u650f\0\u7fce\0\u7ff7\0\u8020\0\u0401\0\u8049"+
    "\0\u8072\0\u809b\0\u80c4\0\u80ed\0\u8116\0\u813f\0\u8168\0\u8191"+
    "\0\u54b9\0\u81ba\0\u72fe\0\u81e3\0\u820c\0\u8235\0\u825e\0\u8287"+
    "\0\u82b0\0\u82d9\0\u8302\0\u832b\0\u8354\0\u837d\0\u83a6\0\u83cf"+
    "\0\u83f8\0\u8421\0\u844a\0\u8473\0\u849c\0\u84c5\0\u84ee\0\u8517"+
    "\0\u8540\0\u8569\0\u8592\0\u85bb\0\u85e4\0\u860d\0\u8636\0\u865f"+
    "\0\u8688\0\u86b1\0\u86da\0\u8703\0\u872c\0\u8755\0\u877e\0\u87a7"+
    "\0\u87d0\0\u87f9\0\u8822\0\u884b\0\u8874\0\u889d\0\u88c6\0\u88ef"+
    "\0\u8918\0\u8941\0\u896a\0\u8993\0\u89bc\0\u89e5\0\u8a0e\0\u8a37"+
    "\0\u8a60\0\u8a89\0\u8ab2\0\u8adb\0\u8b04\0\u8b2d\0\u8b56\0\u8b7f"+
    "\0\u8ba8\0\u8bd1\0\u8bfa\0\u8c23\0\u8c4c\0\u8c75\0\u8c9e\0\u8cc7"+
    "\0\u8cf0\0\u77cc\0\u8d19\0\u8d42\0\u8d6b\0\u8d94\0\u8dbd\0\u8de6"+
    "\0\u8e0f\0\u8e38\0\u8e61\0\u8e8a\0\u8eb3\0\u8edc\0\u8f05\0\u8f2e"+
    "\0\u8f57\0\u8f80\0\u8fa9\0\u8fd2\0\u8ffb\0\u9024\0\u904d\0\u9076"+
    "\0\u909f\0\u90c8\0\u90f1\0\u911a\0\u9143\0\u916c\0\u9195\0\u91be"+
    "\0\u91e7\0\u9210\0\u9239\0\u9262\0\u928b\0\u92b4\0\u92dd";

  private static int [] yy_unpack_yy_rowMap() {
    int [] result = new int[943];
    int offset = 0;
    offset = yy_unpack_yy_rowMap(yy_rowMap_packed0, offset, result);
    return result;
  }

  private static int yy_unpack_yy_rowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = ((int) packed.charAt(i++)) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] yytrans = yy_unpack_yytrans();

  private static final String yytrans_packed0 =
    "\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12"+
    "\1\13\1\14\1\15\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\2\3\1\35\1\36\1\37\1\32\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\36\1\3\1\44"+
    "\51\32\31\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\2\3\1\46\1\3\1\47\1\50\1\51\1\52"+
    "\1\53\1\3\1\54\1\3\1\55\1\56\1\3\1\57"+
    "\1\60\2\3\1\61\5\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\62\1\3\1\63\1\64"+
    "\2\3\1\65\1\3\1\66\1\3\1\67\5\3\1\70"+
    "\7\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\2\3\1\71\1\3\1\72\2\3\1\73\1\74\1\3"+
    "\1\75\1\76\1\77\2\3\1\100\3\3\1\101\2\3"+
    "\1\102\1\3\1\103\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\3\3\1\104\4\3\1\105\1\106\1\3"+
    "\1\107\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\110\1\3\1\111\1\112\4\3\1\113"+
    "\1\3\1\114\5\3\1\115\2\3\1\116\4\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\117"+
    "\1\3\1\120\1\3\1\121\2\3\1\122\1\123\1\124"+
    "\1\125\2\3\1\126\2\3\1\127\2\3\1\130\3\3"+
    "\1\131\1\0\1\3\1\132\1\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\133\1\3\1\134\5\3\1\135"+
    "\1\3\1\136\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\6\3\1\137\5\3\1\140\13\3\1\141"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\142\4\3\1\143\1\144\4\3\1\145\6\3\1\146"+
    "\5\3\1\0\1\147\1\150\1\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\151\1\3\1\152\1\153\2\3"+
    "\1\154\1\155\10\3\1\156\2\3\1\157\4\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\5\3\1\160"+
    "\1\161\1\162\4\3\1\163\1\164\1\165\1\3\1\166"+
    "\10\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\167\1\3\1\170\4\3\1\171\1\172\1\173"+
    "\16\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\174\1\3\1\175\1\176\4\3\1\177\1\3"+
    "\1\200\5\3\1\201\7\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\202\1\3\1\203\4\3"+
    "\1\204\1\205\1\3\1\206\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\207\1\3\1\210"+
    "\1\211\2\3\1\212\1\213\1\214\1\3\1\215\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\216\1\217\2\3\1\220\1\3\1\221\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\222"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\3\3\1\223\25\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\224\7\3\1\225\1\3\1\226"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\227\1\3\1\230\7\3\1\231\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\232"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\3\3\1\233\1\234\6\3\1\235\10\3\1\236\4\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\52\0\1\3"+
    "\1\237\1\3\1\240\1\241\2\3\1\242\1\243\1\244"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\32\0"+
    "\1\245\17\0\3\3\1\246\25\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\36\0\1\36\10\0\1\36\13\0"+
    "\1\247\24\0\1\37\2\0\1\250\45\0\1\250\12\0"+
    "\27\251\1\0\1\251\1\0\3\251\12\0\1\251\1\0"+
    "\45\252\1\253\1\254\1\255\1\252\3\3\1\256\2\3"+
    "\1\257\22\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\260\4\3\1\70\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\261\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\6\3"+
    "\1\262\2\3\1\263\1\70\6\3\1\264\7\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\5\3\1\265"+
    "\1\3\1\266\3\3\1\267\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\270\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\5\3\1\271"+
    "\4\3\1\272\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\273\13\3\1\70\3\3\1\70"+
    "\7\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\70\13\3\1\70\1\246\12\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\265\23\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\20\3"+
    "\1\274\10\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\20\3\1\70\10\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\12\3\1\275\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\276\1\3"+
    "\1\277\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\300\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\301\25\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\302\11\3"+
    "\1\303\1\246\10\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\304\6\3\1\305\14\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\31\3\1\0"+
    "\2\3\1\306\1\0\1\3\10\0\1\3\1\0\15\3"+
    "\1\307\13\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\15\3\1\70\13\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\310\23\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\311\23\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\15\3"+
    "\1\312\13\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\313\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\17\3\1\314\11\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\11\3\1\315\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\265\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\316\3\3\1\317\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\7\3\1\320\1\321"+
    "\15\3\1\322\2\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\323\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\324\3\3\1\325"+
    "\1\326\1\327\2\3\1\330\1\331\1\332\2\3\1\333"+
    "\3\3\1\334\4\3\1\335\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\20\3\1\336\10\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\2\3\1\337\26\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\340\27\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\341\6\3\1\342\1\343\1\3\1\344"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\345\11\3\1\346\12\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\347\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\30\3\1\323"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\350\7\3\1\350\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\23\3\1\351\5\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\10\3\1\352\5\3"+
    "\1\323\12\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\353\2\3\1\354\10\3\1\355\3\3"+
    "\1\105\7\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\2\3\1\356\13\3\1\70\12\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\357\2\3"+
    "\1\360\1\361\1\362\1\363\2\3\1\364\1\3\1\365"+
    "\14\3\1\0\1\3\1\366\1\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\105\1\3\1\115\1\367\17\3"+
    "\1\370\4\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\16\3\1\371\3\3\1\323\6\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\372\27\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\6\3"+
    "\1\373\7\3\1\374\12\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\375\1\3\1\376\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\377\7\3\1\u0100\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\7\3\1\u0101\21\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0102\1\u0103"+
    "\1\u0104\5\3\1\u0105\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\73\10\3\1\u0106\13\3"+
    "\1\265\2\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u0107\4\3\1\312\5\3\1\u0108\2\3"+
    "\1\u0104\3\3\1\u0109\5\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\6\3\1\u010a\7\3\1\u010b\6\3"+
    "\1\323\3\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u0102\7\3\1\u010c\1\3\1\u010d\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\u010e\1\3\1\u010f\1\3\1\u0110\1\u0111\1\u0112\1\u0113"+
    "\1\265\7\3\1\u0114\3\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\15\3\1\u0115\12\3\1\265\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\12\3\1\277"+
    "\16\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\u0116\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\6\3\1\323\22\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\12\3\1\u0117\2\3\1\u0118"+
    "\13\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u0119\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\u011a\3\3\1\u011b\1\u011c\1\u011d"+
    "\14\3\1\u011e\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\10\3\1\u011f\20\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u0120\1\u0121\1\u0122\1\u0123"+
    "\2\3\1\u0124\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u0125\1\u0126\1\3\1\u0127\2\3"+
    "\1\u0128\1\u0129\3\3\1\u012a\1\3\1\u012b\11\3\1\313"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u012c\5\3\1\u012d\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\u012e\1\3\1\u012f\4\3"+
    "\1\u0130\20\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\2\3\1\323\1\3\1\u0131\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\12\3\1\105\16\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\u0132\7\3\1\u0133\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u0134\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u0135\10\3"+
    "\1\u0136\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u0137\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\u0138\1\3\1\u0139\1\u013a"+
    "\3\3\1\u013b\1\u013c\1\265\1\u013d\1\3\1\u013e\3\3"+
    "\1\u013f\1\u0140\3\3\1\u0138\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u0141\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\16\3\1\u0142\11\3"+
    "\1\u0143\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\14\3\1\303\14\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\u0144\10\3\1\u0145\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\5\3\1\u0146"+
    "\4\3\1\u0147\1\3\1\323\11\3\1\70\2\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\7\3\1\u0148"+
    "\6\3\1\u0149\12\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\26\3\1\70\2\3\1\0\1\u0104\2\3"+
    "\1\0\1\3\10\0\1\3\1\0\7\3\1\65\14\3"+
    "\1\222\4\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u014a\13\3\1\70\7\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\10\3\1\u014b\5\3"+
    "\1\u014c\12\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\u014d\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\u014e\2\3\1\u014f\1\u0150"+
    "\1\u0151\1\u0152\2\3\1\u0153\4\3\1\u0154\10\3\1\u0155"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\u0156\4\3\1\u0157\3\3\1\u0158\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u0159\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\142\22\3\1\70\1\0\1\u015a\2\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\323\7\3\1\u0155\1\u015b"+
    "\5\3\1\323\5\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\16\3\1\u015c\12\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u015d\1\u015e\22\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\u015f\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\144\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u0160\3\3\1\u0161\20\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u0162\5\3\1\u0163\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\343\25\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\7\3\1\u0164\4\3"+
    "\1\u0165\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\142\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\340\7\3\1\u0166\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\u0167\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u0168\1\3\1\u0169\25\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u016a\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\70\6\3\1\u016b\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\u016c\27\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\323\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\4\3"+
    "\1\u016d\2\3\1\u016e\2\3\1\u016f\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0170\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\376\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\u0171\6\3\1\u0172\5\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\6\3\1\u0104\1\73"+
    "\1\u016c\20\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u0173\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\21\3\1\u0174\7\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0175\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\13\3"+
    "\1\u0176\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u0177\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u0178\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0179\1\277"+
    "\1\u017a\6\3\1\70\13\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\6\3\1\u017b\22\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u017c\5\3"+
    "\1\u017d\1\3\1\u017e\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\70\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\2\3\1\u017f\26\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\u0180\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\46\245\1\0\2\245\13\3\1\350\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\32\0\1\u0181\16\0"+
    "\1\u0181\11\0\1\247\24\0\1\250\12\0\31\251\1\0"+
    "\3\251\1\0\1\251\10\0\1\251\1\0\45\252\1\u0182"+
    "\1\254\1\255\1\252\4\3\1\u0104\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u0183\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\313\27\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\16\3\1\u0184\12\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u0185\1\3\1\u0186\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\365\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\16\3\1\374\12\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u016c\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u0187\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\312\27\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\24\3\1\u0188\4\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u0189\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\11\3\1\u012c\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\7\3"+
    "\1\u018a\21\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\u018b\24\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\25\3\1\u018c\3\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\7\3\1\u018d\21\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\24\3"+
    "\1\70\4\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u018e\27\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\2\3\1\70\26\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\26\3\1\u018f\2\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\375\25\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\23\3\1\222\3\3\1\u0190\1\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\u0119\27\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u0191\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u016c\1\3\1\u0192\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\11\3\1\u016c\16\3"+
    "\1\u0138\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u0193\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\6\3\1\70\22\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\21\3\1\70\7\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\u0194"+
    "\22\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\u0195\24\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\13\3\1\u0196\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\u0197\7\3\1\70"+
    "\14\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\7\3\1\u0198\1\3\1\70\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u0199\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\70"+
    "\20\3\1\u019a\1\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\11\3\1\70\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\7\3\1\70\5\3\1\u019b"+
    "\13\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\10\3\1\u019c\20\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\u019d\2\3\1\u019e\1\u0104\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\u019f\27\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\10\3\1\u01a0\20\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\14\3\1\u01a1\14\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\u01a2\27\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u01a3\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\u0137\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\7\3\1\u01a4\1\3\1\u01a5\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\24\3"+
    "\1\u0104\4\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\u01a6\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\6\3\1\u0104\22\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\13\3\1\u01a7\1\u01a8"+
    "\14\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\6\3\1\u01a9\2\3\1\70\2\3\1\u0187\14\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u0104"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\16\3\1\70\1\3\1\u01aa\10\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\u01ab\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\30\3\1\u01ac"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u01ad\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\70\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u01ae\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\377\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\4\3"+
    "\1\u0104\1\u01af\23\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\10\3\1\u01b0\20\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\3\3\1\u0138\7\3\1\350"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\6\3\1\u01b1\1\u01b2\2\3\1\u01b3\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\142\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\13\3"+
    "\1\u01b4\7\3\1\u01b5\5\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\u01b6\2\3\1\70\22\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\6\3"+
    "\1\u01b7\22\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u0191\5\3\1\70\11\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u0161\1\3"+
    "\1\271\2\3\1\u01b8\20\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\6\3\1\u01b9\22\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\10\3\1\u01ba\20\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u01bb\25\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u01bc\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u01bd\14\3\1\105\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\7\3\1\u01be"+
    "\21\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\5\3\1\u01bf\5\3\1\73\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\u01c0\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\4\3\1\323"+
    "\24\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\26\3\1\70\2\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\12\3\1\323\16\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\12\3\1\u01c1\16\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\u01c2"+
    "\2\3\1\u01c3\1\u01c4\13\3\1\u01c5\2\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\20\3\1\323\10\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u01c6\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\70\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\12\3\1\u01c7\5\3\1\u01c8\10\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\u01c9\23\3\1\70\3\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\15\3\1\u0172\13\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\20\3\1\u0155\10\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u0164\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u01ca\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u0104\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u01cb\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\61\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u0164\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u01cc\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u01cd\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u01ce\25\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\350\25\3\1\0\1\3\1\u01cf\1\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\u01d0\7\3"+
    "\1\340\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\u01d1\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\u0176\27\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\115\27\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u0107\1\u01d2\24\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\31\3\1\u01d3\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\4\3\1\313\24\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\u01d4\4\3\1\u01d5"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\u01d6\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\u01d7\1\3\1\u01d8\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\u01d9"+
    "\22\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\7\3\1\u014c\21\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u01da\27\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\15\3\1\u01db\13\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u01dc"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\5\3\1\70\3\3\1\70\1\u01dd\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\7\3\1\u01de\21\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\24\3"+
    "\1\323\4\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\u01df\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\u0164\25\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u01e0\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\7\3"+
    "\1\u01e1\1\u01e2\20\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\14\3\1\u0104\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u01e3\1\u01e4\5\3"+
    "\1\u01e5\1\u01e6\5\3\1\u01e7\5\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\u01e8\11\3\1\u01e9"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\6\3"+
    "\1\312\22\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u01ea\27\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\6\3\1\u01eb\22\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\2\3\1\70\3\3"+
    "\1\323\22\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\6\3\1\57\22\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u01ec\1\3\1\u01ed\22\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\4\3"+
    "\1\u01ee\6\3\1\350\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\12\3\1\u01ef\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0115\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\7\3"+
    "\1\u01f0\21\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\10\3\1\u01bb\20\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\25\3\1\323\3\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\10\3\1\u0104\20\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\70\5\3\1\u01f1\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u01f2\3\3\1\u01f3\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\4\3"+
    "\1\u01f4\24\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u01f5\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u01f6\1\3\1\u01f7\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\13\3"+
    "\1\u01f6\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\u01f8\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u01f9\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u01fa\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u01fb\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\u01fc\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\10\3\1\u01c6\2\3\1\u01fd\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u019b\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u01fe\1\u0136\7\3\1\u0172\4\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\4\3\1\u01ff"+
    "\24\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\7\3\1\u0200\21\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\2\3\1\265\6\3\1\u0201\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u0202"+
    "\7\3\1\u0203\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\2\3\1\105\26\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\246\27\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\30\3\1\70"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\7\3"+
    "\1\u0204\21\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u01b6\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u0205\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\u0206\4\3"+
    "\1\u0207\16\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u0176\1\3\1\u0208\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\7\3\1\u0209\3\3"+
    "\1\u020a\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u020b\7\3\1\u020c\1\3\1\u020d\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\277\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\20\3\1\u020e\10\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u020f\4\3\1\u0210\15\3"+
    "\1\u0211\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\5\3\1\u0212\23\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u0213\27\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\23\3\1\u0214\5\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\10\3\1\105"+
    "\1\70\1\3\1\u0215\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\30\3\1\312\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\24\3\1\u0216\4\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\u0217"+
    "\22\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\10\3\1\u0176\12\3\1\u0214\5\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u0218\3\3\1\u0219"+
    "\1\323\13\3\1\u021a\2\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\14\3\1\73\14\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\16\3\1\70\12\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u021b\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\70\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\12\3\1\u021c\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\u0164\27\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\70\25\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\u021d\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\10\3\1\u021e\20\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\2\3\1\u0166\26\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u021f\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\70\24\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\12\3\1\u0220\1\u0221\5\3\1\u0172"+
    "\7\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\10\3\1\u0145\2\3\1\73\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\10\3\1\u0222\20\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\2\3\1\u0223"+
    "\3\3\1\271\22\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\15\3\1\u0224\13\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u010d\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\4\3\1\u0225"+
    "\24\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\27\3\1\u0226\1\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\25\3\1\70\3\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\323\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\24\3\1\u0227"+
    "\4\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\323\7\3\1\u0228\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u0229\3\3\1\u022a"+
    "\23\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\6\3\1\u022b\3\3\1\u0166\16\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u022c\5\3\1\u021c"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\u022d\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\3\3\1\u022e\2\3\1\u022f\3\3\1\u0230"+
    "\4\3\1\u013e\10\3\1\u0209\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\u016c\12\3\1\305\4\3"+
    "\1\u0231\5\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\u0184\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\15\3\1\u0232\13\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\37\0\1\u0233\12\0\7\3"+
    "\1\u0234\21\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u0235\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u021c\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\20\3\1\u0236\10\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\12\3"+
    "\1\u0115\16\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\u0237\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\350\25\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\21\3\1\u0238\7\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u0239\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\26\3\1\u021a\2\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u023a\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\15\3\1\u0155\13\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u01ca\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\u023b\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\12\3\1\u0104\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u023c\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\u023d\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u0104\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u023e\2\3\1\u023f\21\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u0240\25\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u0241\27\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\2\3\1\u0242\5\3\1\u014d\20\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\13\3"+
    "\1\u0243\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\12\3\1\u0244\16\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u0245\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0246\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\7\3"+
    "\1\u0104\21\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u0247\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u0248\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\15\3\1\u0249\13\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\16\3"+
    "\1\323\12\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\u024a\24\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\377\27\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\u024b\27\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u024c\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\u0172\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\6\3\1\u024d\22\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\u024e\23\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\20\3"+
    "\1\u024f\10\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u0250\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\u0251\3\3\1\u0115\21\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\6\3"+
    "\1\u0252\13\3\1\u0253\6\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\30\3\1\u0254\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\u0255\1\3\1\u0256"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\u0257\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\u0258\23\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\340\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\7\3\1\u0259"+
    "\21\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\u025a\27\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\11\3\1\u025b\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\17\3\1\70\11\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\13\3\1\u025c"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\u025d\24\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\13\3\1\u019f\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\u025e\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\7\3\1\u0164"+
    "\21\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\16\3\1\u025f\12\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\222\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\7\3\1\u0260\21\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u0261"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u0262\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\13\3\1\u0263\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u0115\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\4\3\1\u0264"+
    "\24\3\1\0\1\u0265\2\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\u0266\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\u0267\27\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0166\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u0268\25\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\10\3\1\u0269\20\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u026a\1\3\1\u026b\21\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\350\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\27\3\1\u026c\1\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\6\3\1\u010a\22\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\12\3\1\u026d\16\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\16\3"+
    "\1\u026e\12\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\10\3\1\323\20\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\16\3\1\u024e\12\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u026f\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\21\3"+
    "\1\u0270\7\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\12\0\1\u0271\37\0\1\3\1\u0191\27\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0272\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\10\3"+
    "\1\u0176\20\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\10\3\1\u0248\20\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\30\3\1\u0273\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u0274\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\7\3\1\312"+
    "\21\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u0192\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\u0275\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u0276\27\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\73"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u0277\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\11\3\1\u0278\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u0279\27\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\16\3\1\u027a"+
    "\12\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\u027b\11\3\1\u027c\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u027d\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u027e"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u027f\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\11\3\1\256\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u0280\7\3\1\u0129"+
    "\1\3\1\u0281\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\u0282\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u0283\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\u0284"+
    "\22\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u0285\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\3\3\1\u0286\25\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u0287\25\3\1\u0190"+
    "\1\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\25\3\1\u0288\3\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u021c\27\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\u0289\13\3\1\265"+
    "\10\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\u028a\7\3\1\u028b\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\u0104\7\3\1\365"+
    "\14\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u028c\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\13\3\1\u028d\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\31\3\1\0\1\70\2\3"+
    "\1\0\1\3\10\0\1\3\1\0\12\3\1\u028e\16\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\25\3"+
    "\1\265\3\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\u028f\24\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u025d\23\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\15\3\1\u0290\13\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u0291\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\u0272\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\17\3\1\313\11\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\11\3\1\u0292\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\u014b\11\3\1\u01b6\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u0184\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\2\3\1\u0293\26\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\u0294\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\7\3\1\u0295\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u0296\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0297\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\4\3"+
    "\1\u0298\24\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\16\3\1\u0299\12\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\375\27\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\16\3\1\u0166\12\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\10\3"+
    "\1\u019e\20\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\u029a\24\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\14\3\1\u029b\14\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u029c\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\13\3"+
    "\1\u029d\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\u029e\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\214\27\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\13\3\1\u029f\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\16\3"+
    "\1\u02a0\12\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u02a1\27\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\17\3\1\u02a2\11\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\73\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\u02a3\27\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\u023a\24\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u02a4\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\u02a5\27\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\22\3"+
    "\1\323\6\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\271\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u01de\23\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\30\3\1\u02a6\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\4\3\1\u02a7"+
    "\24\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\24\3\1\222\4\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u014b\27\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\10\3\1\u0162\20\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\3\3\1\144"+
    "\25\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\7\3\1\265\21\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u02a8\27\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u02a9\10\3\1\u02aa"+
    "\12\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\3\3\1\u0138\25\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\11\3\1\u02ab\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\u02ac\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\13\3\1\u0166"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\26\3\1\u02ad\2\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\17\3\1\u013e\11\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\u02ae\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\4\3\1\u02af"+
    "\24\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u02b0\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\13\3\1\u02b1\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u02b2\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u0129"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\70\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\14\3\1\u028c\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\u02b3\24\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\323"+
    "\13\3\1\323\6\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\20\3\1\u0115\10\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\350\27\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u02b4"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\u02b5\27\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\27\3\1\u0190\1\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u0107\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u02b6"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\14\3\1\u019b\14\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\u026a\23\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u02b7\27\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\14\3\1\u02b8"+
    "\14\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\3\3\1\u02b9\25\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\14\3\1\u02ba\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u0191\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\13\3\1\u02bb"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\6\3\1\u0247\22\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\11\3\1\u01f6\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\u02bc\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\5\3\1\u0221"+
    "\23\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\27\3\1\u02bd\1\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u02be\5\3\1\u02bf\7\3\1\u02c0"+
    "\11\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u02c1\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\14\3\1\u0115\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\305\24\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\5\3\1\u02c2"+
    "\23\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\3\3\1\u02c3\25\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\3\3\1\u0260\25\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\u02c4\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\u02c5"+
    "\3\3\1\70\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\u02c6\23\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\u0172\24\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u02c7"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\7\3\1\u02c8\21\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\4\3\1\u02c9\24\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\3\3\1\u02ca\25\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\13\3\1\u02cb"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\14\3\1\377\14\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u024c\27\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u0129\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\16\3\1\u02cc"+
    "\12\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\5\3\1\u0201\23\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\17\3\1\u02cd\11\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\u02ce\24\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\12\3\1\u02cf"+
    "\16\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\15\3\1\323\13\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\4\3\1\u02d0\24\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\u02d1\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u0102"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\3\3\1\u016c\7\3\1\u0189\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u02d2\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\15\3\1\u02d3"+
    "\13\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\u01d2\24\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\16\3\1\u02d4\12\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\26\3\1\350\2\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\30\3\1\u01a9"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\33\0\1\u02d5"+
    "\16\0\14\3\1\u0166\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u02d6\23\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\6\3\1\70\4\3"+
    "\1\u010d\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\u02d7\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\15\3\1\u02d8\13\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\6\3\1\377\22\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\6\3"+
    "\1\u02d9\22\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u02da\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\14\3\1\u024c\14\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\13\3\1\u02db\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\u01cf\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\u02dc\24\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\12\3\1\u02dd\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\u02de\23\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\u02df\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u02e0\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u021c\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\11\3\1\u02e1\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\27\3"+
    "\1\u02e2\1\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\u02e3\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u024c\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\12\3\1\u02e4\16\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\73\16\3\1\u0254\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\6\3\1\306\14\3\1\u0166\5\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\14\3\1\u02e5"+
    "\14\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\73\27\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\1\3\1\u02e6\27\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u02e7\27\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\13\3\1\u02e8"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u0115\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\16\3\1\u02e9\12\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u02ea\27\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\144"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u02eb\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\16\3\1\u02ec\12\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\3\3\1\313\4\3\1\u02ed"+
    "\20\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u02ee\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\13\3\1\u02ef\15\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\u02f0\24\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u02f1"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\3\3\1\u02f2\25\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\14\3\1\u0191\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\14\3\1\u02f3\14\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\3\3\1\u02f4"+
    "\25\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u02f5\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\u01cf\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u02f6\5\3\1\70"+
    "\7\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\20\3\1\u02f7\10\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\20\3\1\350\10\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\4\3\1\73\24\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u02f8"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\u02f9\24\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\21\3\1\115\7\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\u02fa\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\23\3\1\265"+
    "\5\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\11\3\1\u02fb\17\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\3\3\1\u02a5\25\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\15\3\1\u02fc\13\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\15\3\1\265"+
    "\13\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\u02bb\24\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\6\3\1\271\22\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\7\3\1\u02fd\21\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\13\3\1\u02fe"+
    "\15\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\14\3\1\u0108\14\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\u025d\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\21\3\1\70\6\3\1\312"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\12\3"+
    "\1\u0175\16\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u02ff\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\10\3\1\u0129\20\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\6\3\1\70\2\3"+
    "\1\u0300\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\23\3\1\323\5\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\14\3\1\u0301\14\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\332\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\12\3"+
    "\1\u0302\16\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u0303\27\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\u0304\25\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u02ff\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\u0305\27\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\u0306\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u0129\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\u0307\23\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\10\3"+
    "\1\375\20\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\6\3\1\u0308\22\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u0309\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u02cc\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\313\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\27\3\1\u030a\1\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u030b\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u016c\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u030c\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\u0172\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\30\3\1\u030d\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u030e\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u030f"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u0310\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\12\0\1\u0311\37\0\20\3\1\u024c\10\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u0312"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\30\3\1\u0313\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\70\1\3\1\u0314\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\312\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\u0315\6\3\1\u02ed\20\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u0316\23\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\13\3\1\u0317\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\15\3"+
    "\1\u0318\13\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\10\3\1\u0319\4\3\1\301\13\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u031a\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\u031b\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u031c\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u031d\4\3\1\323\16\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\7\3"+
    "\1\u031e\21\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u02ce\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\312\23\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\11\3\1\u031f\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\u0320\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\16\3\1\u0321\12\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u0322\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\12\3\1\u02e7\16\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\2\3"+
    "\1\323\25\3\1\u02e7\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\u0323\23\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u014b\7\3\1\73"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\70\10\3\1\70\13\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\6\3\1\u02c5\22\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\14\3\1\306"+
    "\14\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\14\3\1\305\14\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\12\3\1\u0324\16\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\312\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u0325"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\5\3\1\u024e\1\3\1\70\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\12\3\1\u0326\16\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\16\3\1\u0327"+
    "\12\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\5\3\1\u0328\23\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\10\3\1\u0329\20\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\u032a\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\22\3\1\u01f0"+
    "\6\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\27\3\1\u032b\1\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\15\3\1\u032c\13\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\12\3\1\u032d\16\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\5\3\1\u032e"+
    "\23\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\5\3\1\u032f\23\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\4\3\1\u0330\24\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\u014d\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u0331"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u0332\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\6\3\1\u0333\22\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\22\3\1\u0221\6\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\10\3\1\u0319"+
    "\20\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\u0334\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\30\3\1\u021c\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u0224\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\16\3\1\u0335\12\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\17\3"+
    "\1\u0336\11\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u01a9\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\13\0\1\u0337\36\0\3\3\1\u0338\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u0339\25\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u033a\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u033b\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u033c\25\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\27\3"+
    "\1\u033d\1\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\6\3\1\265\22\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u033e\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\27\3\1\u033f\1\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u0340\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u0221\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\7\3\1\313\3\3\1\u0341\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\u0342\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u0343\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\u0344\17\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u0345\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u0346\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\27\3\1\u0347\1\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\24\3\1\313\4\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\2\3\1\265\26\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\11\3"+
    "\1\u0348\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\4\3\1\u0349\24\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\20\3\1\u02f6\10\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\6\3\1\u034a\3\3"+
    "\1\u034b\1\3\1\332\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\27\3\1\u034c\1\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\11\3\1\312\1\3"+
    "\1\u010d\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u034d\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\11\3\1\70\1\3\1\u0189\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\16\3"+
    "\1\u019b\12\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\27\3\1\u034e\1\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\12\3\1\312\16\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\u02a9\21\3"+
    "\1\u02bd\1\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u034f\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u0350\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u0107\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\14\3"+
    "\1\u02ff\14\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\u0351\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\u027a\25\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\14\3\1\u0352\14\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\17\3"+
    "\1\u0353\11\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u0354\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u0355\1\u02d2\2\3\1\u0319"+
    "\4\3\1\u0115\12\3\1\u0356\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u0357\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\u01f0\23\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\27\3"+
    "\1\u0358\1\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\13\3\1\u0359\15\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u019b\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u035a\1\3"+
    "\1\u035b\1\3\1\u023b\21\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u035c\24\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\1\3\1\u0164\7\3"+
    "\1\70\17\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\12\3\1\u035d\16\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\1\3\1\u035e\27\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\3\3\1\u035a\2\3"+
    "\1\u035f\1\u023b\21\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\3\3\1\u0360\25\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\16\3\1\u0361\5\3\1\u0362"+
    "\4\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\6\3\1\u0252\22\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\14\3\1\u0363\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u0364\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\27\3\1\u0365"+
    "\1\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\10\3\1\u0366\20\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\20\3\1\246\10\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\3\3\1\105\25\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u0155"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u02f2\13\3\1\u0367\1\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u0368\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\u0369"+
    "\22\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\75\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\11\3\1\u036a\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\6\3\1\70\20\3\1\u036b"+
    "\1\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\24\3\1\u036c\4\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\5\3\1\u036d\23\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\31\3\1\0\1\3\1\u036e"+
    "\1\3\1\0\1\3\10\0\1\3\1\0\14\3\1\u036f"+
    "\14\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\13\3\1\u0370\15\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\3\3\1\u0371\25\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\u0372\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\70"+
    "\20\3\1\u032b\1\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\14\3\1\u0373\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\14\3\1\u0374\14\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\6\3\1\u0375"+
    "\1\u023b\21\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\14\3\1\u0376\14\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\5\3\1\u0184\23\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\31\3\1\0\1\u0104"+
    "\2\3\1\0\1\3\10\0\1\3\1\0\3\3\1\u0377"+
    "\2\3\1\u0378\5\3\1\332\1\3\1\u01c4\12\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u0379"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\1\3\1\u037a\27\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\u037b\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\6\3\1\u037c\20\3\1\u037d"+
    "\1\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\14\3\1\u0234\14\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\10\3\1\u016c\20\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\15\3\1\u037e\13\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\10\3\1\u02fa"+
    "\20\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\u037f\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\11\3\1\u0380\17\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\5\3\1\u0381\23\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\4\3\1\u0382"+
    "\24\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\30\3\1\u0383\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\16\3\1\u0384\12\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\7\3\1\u0385\21\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\6\3\1\u01c2\22\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\27\3"+
    "\1\u0386\1\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\1\3\1\u0387\27\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\27\3\1\u0388\1\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\5\3\1\u0389\23\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\5\3"+
    "\1\u038a\23\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\11\3\1\u038b\17\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\15\3\1\u038c\13\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\11\3\1\u038d\17\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\1\3"+
    "\1\70\27\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\3\3\1\61\25\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\4\3\1\u038e\5\3\1\u0111\16\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\12\3"+
    "\1\u019f\16\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\5\3\1\u038f\23\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\13\3\1\u0390\15\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\4\3\1\u0391\24\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\13\3"+
    "\1\u0392\15\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\12\3\1\u0393\16\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\3\3\1\u0394\25\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\21\3\1\u0395\7\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\3\3"+
    "\1\u0396\25\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\23\3\1\u0397\5\3\1\0\3\3\1\0\1\3"+
    "\10\0\1\3\1\0\14\3\1\u0398\14\3\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\13\3\1\u0399\15\3"+
    "\1\0\3\3\1\0\1\3\10\0\1\3\1\0\7\3"+
    "\1\u039a\21\3\1\0\3\3\1\0\1\3\10\0\1\3"+
    "\1\0\30\3\1\u039b\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\14\3\1\u039c\14\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\1\3\1\u039d\27\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\1\3\1\u039e"+
    "\27\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\17\3\1\u039f\11\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\u03a0\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\11\3\1\u038a\17\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\27\3\1\u03a1"+
    "\1\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\7\3\1\u03a2\21\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\7\3\1\u03a3\21\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u03a4\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u03a5"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\12\3\1\u01c4\16\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\27\3\1\u03a6\1\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\27\3\1\u03a7\1\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\12\3\1\u038a"+
    "\16\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\15\3\1\u03a8\13\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\12\3\1\u01c4\15\3\1\u03a9\1\0\3\3"+
    "\1\0\1\3\10\0\1\3\1\0\30\3\1\u03aa\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\27\3\1\u03ab"+
    "\1\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\4\3\1\u03ac\24\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\3\3\1\u03ad\25\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\2\3\1\u0242\26\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0\11\3\1\u03ae"+
    "\17\3\1\0\3\3\1\0\1\3\10\0\1\3\1\0"+
    "\6\3\1\u03af\22\3\1\0\3\3\1\0\1\3\10\0"+
    "\1\3\1\0\12\3\1\u0230\16\3\1\0\3\3\1\0"+
    "\1\3\10\0\1\3\1\0\13\3\1\u021c\15\3\1\0"+
    "\3\3\1\0\1\3\10\0\1\3\1\0";

  private static int [] yy_unpack_yytrans() {
    int [] result = new int[37638];
    int offset = 0;
    offset = yy_unpack_yytrans(yytrans_packed0, offset, result);
    return result;
  }

  private static int yy_unpack_yytrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int YY_UNKNOWN_ERROR = 0;
  private static final int YY_NO_MATCH = 1;
  private static final int YY_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] YY_ATTRIBUTE = yy_unpack_YY_ATTRIBUTE();

  private static final String YY_ATTRIBUTE_packed0 =
    "\1\1\1\0\27\1\1\11\5\1\1\11\1\1\1\11"+
    "\1\1\1\11\202\1\1\0\2\1\1\0\2\11\1\0"+
    "\323\1\1\0\121\1\1\0\235\1\1\0\143\1\1\0"+
    "\73\1\1\0\45\1\1\11\170\1";

  private static int [] yy_unpack_YY_ATTRIBUTE() {
    int [] result = new int[943];
    int offset = 0;
    offset = yy_unpack_YY_ATTRIBUTE(YY_ATTRIBUTE_packed0, offset, result);
    return result;
  }

  private static int yy_unpack_YY_ATTRIBUTE(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  //private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  //private boolean yy_atBOL = true;

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /* user code: */
    private int lastToken;
    private int nextState=YYINITIAL;
    //private StringBuffer commentBuffer = new StringBuffer();
    //private int commentNestCount = 0;
    //private int commentStartLine = 0;
    //private int commentStartChar = 0;

    /**
     * next Token method that allows you to control if whitespace and comments are
     * returned as tokens.
     */
    public Token getNextToken(boolean returnComments, boolean returnWhiteSpace)throws IOException{
        Token t = getNextToken();
        while (t != null && ((!returnWhiteSpace && t.isWhiteSpace()) || (!returnComments && t.isComment()))){
            t = getNextToken();
        }
        return (t);
    }

    /**
     * Prints out tokens from a file or System.in.
     * If no arguments are given, System.in will be used for input.
     * If more arguments are given, the first argument will be used as
     * the name of the file to use as input
     *
     * @param args program arguments, of which the first is a filename
     */
    public static void main(String[] args) {
        InputStream in;
        try {
            if (args.length > 0){
                File f = new File(args[0]);
                if (f.exists()){
                    if (f.canRead()){
                        in = new FileInputStream(f);
                    } else {
                        throw new IOException("Could not open " + args[0]);
                    }
                } else {
                    throw new IOException("Could not find " + args[0]);
                }
            } else {
                in = System.in;
            }
            SQLLexer shredder = new SQLLexer(in);
            Token t;
            while ((t = shredder.getNextToken()) != null) {
                if (t.getID() != SQLToken.WHITE_SPACE){
                    System.out.println(t);
                }
            }
        } catch (IOException e){
            System.out.println(e.getMessage());
        }
    }

    /**
     * Closes the current input stream, and resets the scanner to read from a new input stream.
     * All internal variables are reset, the old input stream  cannot be reused
     * (content of the internal buffer is discarded and lost).
     * The lexical state is set to the initial state.
     * Subsequent tokens read from the lexer will start with the line, char, and column
     * values given here.
     *
     * @param reader The new input.
     * @param yyline The line number of the first token.
     * @param yychar The position (relative to the start of the stream) of the first token.
     * @param yycolumn The position (relative to the line) of the first token.
     * @throws IOException if an IOExecption occurs while switching readers.
     */
    public void reset(java.io.Reader reader, int yyline, int yychar, int yycolumn) throws IOException{
        yyreset(reader);
        this.yyline = yyline;
        this.yychar = yychar;
        //this.yycolumn = yycolumn;
    }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public SQLLexer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public SQLLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   IOException  if any I/O-Error occurs
   */
  private boolean yy_refill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if (numRead < 0) {
      return true;
    }
    else {
      yy_endRead+= numRead;  
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) throws java.io.IOException {
    yy_reader = reader;
    //yy_atBOL  = true;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = 0;
    	//yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public Token getNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char [] yy_buffer_l = yy_buffer;
    char [] yycmap_l = yycmap;

    int [] yytrans_l = yytrans;
    int [] yy_rowMap_l = yy_rowMap;
    int [] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      yychar+= yy_markedPos_l-yy_startRead;

      boolean yy_r = false;
      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;
                                                             yy_currentPos_l++) {
        switch (yy_buffer_l[yy_currentPos_l]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yy_r = false;
          break;
        case '\r':
          yyline++;
          yy_r = true;
          break;
        case '\n':
          if (yy_r)
            yy_r = false;
          else {
            yyline++;
          }
          break;
        default:
          yy_r = false;
        }
      }

      if (yy_r) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean yy_peek;
        if (yy_markedPos_l < yy_endRead_l)
          yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        else if (yy_atEOF)
          yy_peek = false;
        else {
          boolean eof = yy_refill();
          yy_markedPos_l = yy_markedPos;
          yy_buffer_l = yy_buffer;
          if (eof) 
            yy_peek = false;
          else 
            yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        }
        if (yy_peek) yyline--;
      }
      yy_action = -1;

      yy_currentPos_l = yy_currentPos = yy_startRead = yy_markedPos_l;
  
      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {
    
          if (yy_currentPos_l < yy_endRead_l)
            yy_input = yy_buffer_l[yy_currentPos_l++];
          else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          }
          else {
            // store back cached positions
            yy_currentPos  = yy_currentPos_l;
            yy_markedPos   = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l  = yy_currentPos;
            yy_markedPos_l   = yy_markedPos;
            yy_buffer_l      = yy_buffer;
            yy_endRead_l     = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            }
            else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ( (yy_attributes & 1) == 1 ) {
            yy_action = yy_state; 
            yy_markedPos_l = yy_currentPos_l; 
            if ( (yy_attributes & 8) == 8 ) break yy_forAction;
          }

        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action < 0 ? yy_action : YY_ACTION[yy_action]) {
        case 5: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.OPERATOR;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 13: break;
        case 10: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.COMMENT_END_OF_LINE;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 14: break;
        case 4: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.ERROR;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 15: break;
        case 2: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.IDENTIFIER;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 16: break;
        case 7: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.SEPARATOR;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 17: break;
        case 8: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.DOT;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 18: break;
        case 9: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.QUALIFIER;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 19: break;
        case 11: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.RUNTIME_ARGUMENT;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 20: break;
        case 1: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.WHITE_SPACE;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 21: break;
        case 12: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.ERROR_UNCLOSED_STRING;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 22: break;
        case 3: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.RESERVED_WORD;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 23: break;
        case 6: 
          { nextState = YYINITIAL;
    lastToken = SQLToken.LITERAL;
    String text = yytext();
    SQLToken t = (new SQLToken(lastToken,text,yyline,yychar,yychar+text.length(),nextState));
    yybegin(nextState);
    return(t); }
        case 24: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            return null;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }


}

