/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.etl.ui.property;


import org.netbeans.modules.etl.ui.ETLDataObject;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;

import org.netbeans.modules.sql.framework.model.TargetTable;
import org.netbeans.modules.sql.framework.model.impl.SQLGroupByImpl;


/**
 *
 * @author Nithya R
 */
public class TargetTableNode extends AbstractNode {
    
    private TargetTable tgtTable;
    
    private SQLGroupByImpl grpby;
    
    private ETLDataObject mObj;
    
    public TargetTableNode(TargetTable obj) {
        super(Children.LEAF);
        tgtTable = (TargetTable) obj;
    }
    
    public TargetTableNode(TargetTable obj, ETLDataObject dObj) {
        super(Children.LEAF);
        mObj = dObj;
        tgtTable = obj;
    }
    
    @Override
    public boolean canCopy() {
        return false;
    }
    
    @Override
    public boolean canRename() {
        return false;
    }
    
    @Override
    public boolean canCut() {
        return false;
    }
    
    @Override
    public boolean canDestroy() {
        return true;
    }
    
    /** Creates a property sheet. */
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.createPropertiesSet();
        Sheet.Set expset = sheet.createExpertSet();
        set.setDisplayName("Basic");
        set.setExpert(false);
        expset.setDisplayName("Expert");
        expset.setExpert(true);
        try {
            PropertySupport.Reflection stmtTypeProp = new PropertySupport.Reflection(
                    this.tgtTable, String.class,
                    "getStrStatementType", "setStrStatementType");
            stmtTypeProp.setName("Statement Type");
            stmtTypeProp.setShortDescription("Select a Statement Type");
            stmtTypeProp.setPropertyEditorClass(
                    PropertyEditorManager.getPropertyEditor("TARGET_STMT_TYPE"));
            set.put(stmtTypeProp);
            
            PropertySupport.Reflection targetjoinConditionProp = new PropertySupport.Reflection(
                    this.tgtTable.getJoinCondition(), String.class,
                    "getConditionText", "setConditionText");
            targetjoinConditionProp.setName("Target Join Condition");
            targetjoinConditionProp.setShortDescription("Join Condition to join target with sources");
            targetjoinConditionProp.setPropertyEditorClass(
                    PropertyEditorManager.getPropertyEditor("TARGET_JOIN_CONDITION"));
            set.put(targetjoinConditionProp);
            
            PropertySupport.Reflection outerFilterConditionProp = new PropertySupport.Reflection(
                    this.tgtTable.getFilterCondition(), String.class,
                    "getConditionText", "setConditionText");
            outerFilterConditionProp.setName("Outer Filter Condition");
            outerFilterConditionProp.setShortDescription("Outer filter condition, for final filtering");
            outerFilterConditionProp.setPropertyEditorClass(
                    PropertyEditorManager.getPropertyEditor("OUTER_FILTER_CONDITION"));
            set.put(outerFilterConditionProp);
                          
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class, "getDisplayName",null);
            nameProp.setName("Target Table Name");
            nameProp.setShortDescription("Target Table Name");
            set.put(nameProp);
            
            PropertySupport.Reflection schemaProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class, "getSchema",null);
            schemaProp.setName("Schema Name");
            schemaProp.setShortDescription("Target Table Schema Name");
            set.put(schemaProp);
            
            PropertySupport.Reflection catalogProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class, "getCatalog",null);
            catalogProp.setName("Catalog Name");
            catalogProp.setShortDescription("Target Table Catalog Name");
            set.put(catalogProp);
            
            PropertySupport.Reflection databaseModelNameProp = new PropertySupport.Reflection(this.tgtTable.getParent(),
                    String.class, "getModelName",null);
            databaseModelNameProp.setName("Connection URL");
            databaseModelNameProp.setShortDescription("Target Table Connection URL");
            set.put(databaseModelNameProp);
            
            PropertySupport.Reflection aliasNameProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class,"getAliasName",null);
            aliasNameProp.setName("Table Alias Name");
            aliasNameProp.setShortDescription("Alias Name for the table");
            expset.put(aliasNameProp);
            
            PropertySupport.Reflection usrDefinedTableNameProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class,"getUserDefinedTableName" ,"setUserDefinedTableName");
            usrDefinedTableNameProp.setName("User Defined Table Name");
            usrDefinedTableNameProp.setShortDescription("Table Name to use In Generated SQL");
            expset.put(usrDefinedTableNameProp);
            
            PropertySupport.Reflection usrDefinedSchemaNameProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class,"getUserDefinedSchemaName" ,"setUserDefinedSchemaName");
            usrDefinedSchemaNameProp.setName("User Defined Schema Name");
            usrDefinedSchemaNameProp.setShortDescription("Schema Name to use In Generated SQL");
            expset.put(usrDefinedSchemaNameProp);
            
            PropertySupport.Reflection usrDefinedCatalogNameProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class,"getUserDefinedCatalogName" ,"setUserDefinedCatalogName");
            usrDefinedCatalogNameProp.setName("User Defined Catalog Name");
            usrDefinedCatalogNameProp.setShortDescription("Catalog Name to use In Generated SQL");
            expset.put(usrDefinedCatalogNameProp);
            
            PropertySupport.Reflection fullyQualifiedNameProp = new PropertySupport.Reflection(this.tgtTable,
                    Boolean.class,"isUsingFullyQualifiedName" ,"setUsingFullyQualifiedName");
            fullyQualifiedNameProp.setName("Use Fully Qualified Table Name");
            fullyQualifiedNameProp.setShortDescription("True to Append Catalog and Schema Names to Table Name");
            expset.put(fullyQualifiedNameProp);
            
            PropertySupport.Reflection targetTablePrefixProp = new PropertySupport.Reflection(this.tgtTable,
                    String.class,"getTablePrefix","setTablePrefix");
            targetTablePrefixProp.setName("Target Table Prefix");
            targetTablePrefixProp.setShortDescription("Prefix for the Target Table");
            expset.put(targetTablePrefixProp);
            
            PropertySupport.Reflection createTargetTableProp = new PropertySupport.Reflection(this.tgtTable,
                    Boolean.class,"isCreateTargetTable","setCreateTargetTable");
            createTargetTableProp.setName("Create Target Table");
            createTargetTableProp.setShortDescription("Create Target Table If Does Not Exist");
            expset.put(createTargetTableProp);
            
            PropertySupport.Reflection truncateBeforeLoadProp = new PropertySupport.Reflection(this.tgtTable,
                    Boolean.class,"isTruncateBeforeLoad","setTruncateBeforeLoad");
            truncateBeforeLoadProp.setName("Truncate Before Load");
            truncateBeforeLoadProp.setShortDescription("If true, truncate data before loading");
            expset.put(truncateBeforeLoadProp);
            
            PropertySupport.Reflection batchSizeProp = new PropertySupport.Reflection(this.tgtTable,
                    Integer.class,"getBatchSize" ,"setBatchSize");
            batchSizeProp.setName("Batch Size");
            batchSizeProp.setShortDescription("Batch Size for Committing Data to this table");
            expset.put(batchSizeProp);
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
        sheet.put(set);
        sheet.put(expset);
        return sheet;
    }
    
    public TargetTable getTargetTable() {
        return this.tgtTable;
    }
    
    public SQLGroupByImpl getGroupBy() {
        return this.grpby;
    }
    public ETLDataObject getETLDataObject() {
        return getLookup().lookup(ETLDataObject.class);
    }
}