/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.visitor;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.model.api.BpelEntity;

import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeTreePathBuilderVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.NodeHelper;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.view.expression.impl.PredicatesManager;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.XPathLocationPath;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.XPathVariableReference;
import org.netbeans.modules.xml.xpath.visitor.AbstractXPathVisitor;


import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;

/**
 *
 * @author radval
 *
 */
public class FindMapperTreeNodeVisitor extends AbstractXPathVisitor {
    
    private static final Logger LOGGER = Logger.getLogger(FindMapperTreeNodeVisitor.class.getName());
    
    private IMapperTreeView mMapperTreeView;
    private PredicatesManager mPredicatesManager;
    private VariableNode mVariableNode;
    private PartNode mPartNode;
    private IMapperTreeNode mMapperTreeNode;
    
    private BpelEntity mEntity;
    
    public FindMapperTreeNodeVisitor(
            IMapperTreeView treeView,
            PredicatesManager predicatesManager,
            VariableNode variableNode,
            PartNode partNode,
            BpelEntity holdingEntity) {
        
        this.mMapperTreeView = treeView;
        this.mPredicatesManager = predicatesManager;
        this.mVariableNode = variableNode;
        this.mPartNode = partNode;
        this.mEntity = holdingEntity;
    }
    
    public IMapperTreeNode getMapperTreeNode() {
        return this.mMapperTreeNode;
    }
    
    public void visit(XPathExpressionPath expressionPath) {
        XPathExpression rootExpression = expressionPath.getRootExpression();
        if (rootExpression instanceof XPathVariableReference) {
            LocationStep[] steps = expressionPath.getSteps();
            if (steps != null && steps.length != 0) {
                visitLocationSteps(steps);
            } else {
                if (this.mVariableNode != null && this.mPartNode != null) {
                    this.mMapperTreeNode = FindMapperTreeNodeWithoutQuery.findPartMapperTreeNode(this.mPartNode, this.mVariableNode, this.mMapperTreeView);
                } else if (this.mVariableNode != null) {
                    this.mMapperTreeNode = FindMapperTreeNodeWithoutQuery.findVariableMapperTreeNode(this.mVariableNode, this.mMapperTreeView);
                }
            }
        }
    }
    
    public void visit(XPathVariableReference vReference) {
        this.mMapperTreeNode = FindMapperTreeNodeWithoutQuery.findVariableMapperTreeNode(this.mVariableNode, this.mMapperTreeView);
    }
    
    public void visit(XPathLocationPath locationPath) {
        LocationStep[] steps = locationPath.getSteps();
        visitLocationSteps(steps);
    }
    
    private void visitLocationSteps(LocationStep[] steps) {
        TreeNode matchingNode = null;
        if (this.mPartNode != null) {
            matchingNode = this.mPartNode;
        } else {
            matchingNode = this.mVariableNode;
        }
        TreeNode nextTreeNode = null;
        
        for (int size = steps.length, i = 0; i < size; i++) {
            // if the query contains the axis and expression inside
            // it cannot be parsed at the moment.
            if (steps[i].getAxis() == 0) {
                break;
            }
            //check if we an attribute
            String s = steps[i].getString();
            if (i == (size - 1) && s.startsWith("@")) {
                s = s.substring(1);
            }
            
            //find the xsd element which matches given step
            nextTreeNode = NodeHelper.findSchemaNode(matchingNode, s, mEntity);
            
            // Begin of fix for issue 99028
            if (nextTreeNode == null) {
                matchingNode = null;
                break;
            }
            // End of fix for issue 99028
            
            XPathPredicateExpression[] predicates = steps[i].getPredicates();
            if (predicates != null && predicates.length > 0) {
                nextTreeNode = getLocationStepNode(matchingNode,
                        nextTreeNode,
                        this.mMapperTreeView.getTree(),
                        steps[i]);
            }
            matchingNode = nextTreeNode;
        }
        
        // Check to make sure that the location refers to an existant node.
        if (matchingNode != null) {
            NodeTreePathBuilderVisitor ntpBuilder = new NodeTreePathBuilderVisitor();
            matchingNode.accept(ntpBuilder);
        
            TreePath tPath = ntpBuilder.getTreePath();
            this.mMapperTreeNode = this.mMapperTreeView.getMapperTreeNode(tPath);
            if (this.mMapperTreeNode != null) {
                TreePath treePath = this.mMapperTreeNode.getPath();
                if (treePath != null) {
                    Object lastpathComponent = treePath.getLastPathComponent();
                    Node node = (Node) lastpathComponent;
                    Object dataObject = node.getDataObject();
                    if (dataObject != null) {
                        matchingNode.setMapperNode(this.mMapperTreeNode);
                        this.mMapperTreeNode.setNodeObject(matchingNode);
                    }
                }
            }
        }
    }
    
    private TreeNode getLocationStepNode(
            TreeNode parentNode,
            TreeNode sourceNode,
            JTree tree,
            LocationStep step)
    {
        TreeNode node = null;
        
        List children = parentNode.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Node child = (Node) it.next();
            if(child instanceof XPathLocationStepNode) {
                XPathLocationStepNode locationStepNode = (XPathLocationStepNode) child;
                LocationStep lStep = locationStepNode.getLocationStep();
                if(lStep != null && lStep.equals(step)) {
                    node = locationStepNode;
                    break;
                }
            }
        }
        
        if (node == null) {
            node = this.mPredicatesManager.createAndAddNewPredicate(parentNode,
                    sourceNode,
                    step,
                    tree);
        }
        
        return node;
    }
}
