/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathOperatorNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.xml.xpath.XPathOperationOrFuntion;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicAccumulatingMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import javax.swing.tree.TreePath;

/**
 *
 * @author radval
 *
 */
public class XPathOperatorNodeImpl extends AbstractCanvasNode implements XPathOperatorNode {

//    private Map mInputNodeToFieldNodeMap = new WeakHashMap();
    private XPathOperationOrFuntion mOperationOrFunction;
    private static OperandPlaceHolderNodeImpl operandNode = new OperandPlaceHolderNodeImpl();

    private Map<Node, Set<IFieldNode>> inputNodeToFeildsSetMap 
            = new HashMap<Node, Set<IFieldNode>>();

    public XPathOperatorNodeImpl(XPathOperationOrFuntion operation) {
        super(operation);
        this.mOperationOrFunction = operation;
    }


    public XPathOperationOrFuntion getOperationOrFuntion() {
        return this.mOperationOrFunction;
    }

    public void setMapperNode(IMapperNode node) {
        super.setMapperNode(node);
    }

    
    public IMapperNode getInputFieldNode(Node input) {
        IFieldNode[] fieldNodes = get(input);
        return (fieldNodes.length > 0) ? fieldNodes[0] : null; 
        // return (IMapperNode) inputNodeToFieldNodeMapGet(input);
    }
    
    
    public IMapperNode[] getInputFieldNodes(Node input) {
        return get(input);
    }
    
    
    public void addInput(Node input) {
        super.addInput(input);
        IMethoidNode operatorGuiNode = (IMethoidNode) getMapperNode();
        int lastAdded = getInputs().size() - 1;

        if (operatorGuiNode instanceof BasicAccumulatingMethoidNode) {
            BasicAccumulatingMethoidNode mapperNode = (BasicAccumulatingMethoidNode) operatorGuiNode;
            if (lastAdded >= mapperNode.getInputFieldNodes().size()) {
                mapperNode.getNextNewNode();
            }
        }

        IFieldNode inputFieldNode = (IFieldNode) operatorGuiNode.getInputFieldNodes().get(lastAdded);

        if (inputFieldNode != null) {
            put(input, inputFieldNode);
            // inputNodeToFieldNodeMapPut(input, inputFieldNode);
        }
    }

    public void addInput(int index, Node input) {
        List inputList = getInputs();
        int size = inputList.size();
        if (index == size) {
            inputList.add(input);
        } else {

            if (index > size) {
                int gap = index - size;
                int initialIndex = size;
                for (int i = 0; i < gap; i++) {
                    inputList.add(initialIndex, operandNode);
                    initialIndex++;
                }

                inputList.add(input);
            } else {
                inputList.remove(index);
                inputList.add(index, input);
            }
        }

        IMethoidNode operatorGuiNode = (IMethoidNode) getMapperNode();

        IFieldNode inputFieldNode = (IFieldNode) operatorGuiNode.getInputFieldNodes().get(index);
        if (inputFieldNode != null) {
            put(input, inputFieldNode);
            // inputNodeToFieldNodeMapPut(input, inputFieldNode);
        }
    }

    public void removeInput(Node input) {
        List inputList = getInputs();
        int inputIndex = getInputs().indexOf(input);
        if (inputIndex >= 0) {
            super.removeInput(input);
            //if removing any other operand then first one
            //we add dummy literal node so that xpath operator is complete
            inputList.add(inputIndex, operandNode);
        }
    }

    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    
    private void put(Node input, IFieldNode inputFieldNode) {
        Set<IFieldNode> fieldsSet = inputNodeToFeildsSetMap.get(input);
        if (fieldsSet == null) {
            fieldsSet = new HashSet<IFieldNode>();
            inputNodeToFeildsSetMap.put(input, fieldsSet);
        }
        fieldsSet.add(inputFieldNode);
    }
    
    
    private IFieldNode[] get(Node input) {
        Set<IFieldNode> fieldsSet = inputNodeToFeildsSetMap.get(input);
        return  (fieldsSet == null) 
                ? new IFieldNode[0]
                : fieldsSet.toArray(new IFieldNode[fieldsSet.size()]);
    }
    
    
//    private void inputNodeToFieldNodeMapPut(Node input, IFieldNode inputFieldNode) {
//        if ((input != null) && (input.getMapperNode() instanceof IMapperTreeNode)) {
//            NodeTreePathPairKey key = new NodeTreePathPairKey(input);
//
//            // Since mInputNodeToFieldNodeMap is a WeakHashMap, need to keep the
//            // key from being GC'd by keeping a hard reference to it from the
//            // value
//            NodeTreePathPairValue value = new NodeTreePathPairValue(key, inputFieldNode);
//
//            mInputNodeToFieldNodeMap.put(key, value);
//        } else {
//            mInputNodeToFieldNodeMap.put(input, inputFieldNode);
//        }
//    }
    
    
//    private IFieldNode inputNodeToFieldNodeMapGet(Node input) {
//        Object key = input;
//        if ((input != null) && (input.getMapperNode() instanceof IMapperTreeNode)) {
//            key = new NodeTreePathPairKey(input);
//        }
//        Object value = mInputNodeToFieldNodeMap.get(key);
//        if (value instanceof NodeTreePathPairValue) {
//            return ((NodeTreePathPairValue) value).getFieldNode();
//        }
//        return (IFieldNode) value;
//    }
    
    
    

//    private class NodeTreePathPairKey {
//
//        WeakReference<Node> mNodeWeakRef;
//
//        public NodeTreePathPairKey(Node n) {
//            mNodeWeakRef = new WeakReference<Node>(n);
//        }
//
//        /** {@inheritDoc}
//         */
//        public int hashCode() {
//            int hash = 1;
//            Node node = mNodeWeakRef.get();
//            if (node != null) {
//                hash = (hash * 31) + node.hashCode();
//                hash = (hash * 31) + hashCode(((IMapperTreeNode) node.getMapperNode()).getPath());
//            }
//            return hash;
//        }
//
//        /** {@inheritDoc}
//         */
//        public boolean equals(Object o) {
//            Node node = mNodeWeakRef.get();
//            if ((node != null) && (o instanceof NodeTreePathPairKey)) {
//                Node otherNode = ((NodeTreePathPairKey) o).getNode();
//                return node.equals(otherNode) && ((IMapperTreeNode) node.getMapperNode()).getPath().equals(((IMapperTreeNode) otherNode
//                                     .getMapperNode()).getPath());
//            }
//            return false;
//        }
//
//        /** Gets the node stored here.
//         *  @return Stored node.
//         */
//        public Node getNode() {
//            return mNodeWeakRef.get();
//        }
//
//        private int hashCode(TreePath tp) {
//            int hash = tp.hashCode();
//            Object[] comps = tp.getPath();
//            if (comps != null) {
//                hash = 1;
//                for (int i = 0; i < comps.length; i++) {
//                    if (comps[i] instanceof AbstractNode) {
//                        AbstractNode an = (AbstractNode) comps[i];
//                        hash = (hash * 31) + ((an.getName() != null) ? an.getName().hashCode() : 0);
//                    } else {
//                        hash = (hash * 31) + comps[i].hashCode();
//                    }
//                }
//            }
//            return hash;
//        }
//    }
//
//    private class NodeTreePathPairValue {
//
//        NodeTreePathPairKey mKey;
//        IFieldNode mField;
//
//        public NodeTreePathPairValue(NodeTreePathPairKey k, IFieldNode f) {
//            mKey = k;
//            mField = f;
//        }
//
//        /** Gets the field node stored here.
//         *  @return Stored field node.
//         */
//        public IFieldNode getFieldNode() {
//            return mField;
//        }
//    }
}
