/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.project.anttasks;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.bpel.model.spi.BpelModelFactory;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validation.ValidationType;
import org.netbeans.modules.xml.xam.spi.Validator.ResultItem;
import org.openide.util.lookup.Lookups;

public class TestValidation {
    public TestValidation() {
    }
    
    public Collection execute(File bpelFile ) {
            ArrayList errors = new ArrayList();
            
            URI bpelFileUri = bpelFile.toURI();
            BpelModel model = null;
            try {
                model = BPELCatalogModel.getDefault().getBPELModel(bpelFileUri);
            }catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException("FAIL:Error while trying to create BPEL Model ",ex);
            }
            //Validator validator = (Validator) Lookups.metaInfServices(getClass().getClassLoader()).lookup(Validator.class);
             Validation validation = new Validation();
             System.out.println("Calling  Validation ");
             validation.validate((org.netbeans.modules.xml.xam.Model)model,  ValidationType.COMPLETE);
             System.out.println("Done Validation");
            Collection col  =validation.getValidationResult();
             System.out.println("Got  Validation result");
            //Collection col = validation.getValidationResult();
            for (Iterator itr = col.iterator(); itr.hasNext();) {
               ResultItem resultItem = (ResultItem) itr.next();
               System.out.println("validation type: "+ resultItem.getType() +" description " + resultItem.getDescription());
               if(resultItem.getType() == Validator.ResultType.ERROR) {
                   errors.add(resultItem);
               }
            }
             
             System.out.println(" returning validation results");
            return errors;
    }
}
