/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.variable;

import java.util.List;
import org.netbeans.modules.bpel.debugger.api.variables.NamedValueHost;
import org.netbeans.modules.bpel.debugger.api.variables.SimpleVariable;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.WsdlMessageValue;
import org.netbeans.modules.bpel.debugger.api.variables.WsdlMessageVariable;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementVariable;
import org.netbeans.spi.viewmodel.Model;
import org.openide.util.NbBundle;

import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

/**
 *
 * @author Alexander Zgursky
 */
public class BpelVariableViewModel implements NodeModel, TableModel, Constants {
    private static final String VIEW_NAME = "BpelVariablesView";
    
    private static final String DEFAULT_VARIABLE_ICON =
      "org/netbeans/modules/debugger/resources/localsView/LocalVariable"; // NOI18N
    
    private static final String ICONS_ROOT =
            "org/netbeans/modules/bpel/debugger/ui/resources/image/variables/";
    
    private static final String WSDL_MESSAGE_VARIABLE_ICON =
            ICONS_ROOT + "VARIABLE_MESSAGE";
    
    private static final String WSDL_MESSAGE_PART_ICON =
            ICONS_ROOT + "MESSAGE_PART";

    private static final String XML_ELEMENT_VARIABLE_ICON =
            ICONS_ROOT + "VARIABLE_XML_ELEMENT";

    private static final String SIMPLE_VARIABLE_ICON =
            ICONS_ROOT + "VARIABLE_SIMPLE";

    ContextProvider myContextProvider;
    HelperViewModel myHelperViewModel;

    /**{@inheritDoc}*/
    public BpelVariableViewModel(ContextProvider contextProvider) {
        myContextProvider = contextProvider;
    }
    
    // NodeModel ----------------------------------------------------
    
    /**{@inheritDoc}*/
    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return NbBundle.getMessage(
                BpelVariableViewModel.class, "CTL_Variable_Column_Name"); // NOI18N
        } else if (object instanceof NamedValueHost) {
            return ((NamedValueHost)object).getName();
        } else {
            throw new UnknownTypeException(object);
        }
    }
    
    /**{@inheritDoc}*/
    public String getShortDescription(Object object) throws UnknownTypeException {
        return getDisplayName(object);
    }
    
    /**{@inheritDoc}*/
    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return DEFAULT_VARIABLE_ICON;
        } else if (object instanceof NamedValueHost) {
            if (object instanceof WsdlMessageVariable) {
                return WSDL_MESSAGE_VARIABLE_ICON;
            } else if (object instanceof WsdlMessageValue.Part) {
                return WSDL_MESSAGE_PART_ICON;
            } else if (object instanceof XmlElementVariable) {
                return XML_ELEMENT_VARIABLE_ICON;
            } else if (object instanceof SimpleVariable) {
                return SIMPLE_VARIABLE_ICON;
            } else {
                return DEFAULT_VARIABLE_ICON;
            }
        } else {
            throw new UnknownTypeException(object);
        }
    }
    
    // --------------------------------------------------------------
    
    /**{@inheritDoc}*/
    public void addModelListener(ModelListener listener) {}

    /**{@inheritDoc}*/
    public void removeModelListener(ModelListener listener) {}
    
    // TableModel ---------------------------------------------------
    
    /**{@inheritDoc}*/
    public Object getValueAt(Object object, String column)
        throws UnknownTypeException
    {
        
        if (object instanceof NamedValueHost) {
            Value value = ((NamedValueHost)object).getValue();
            if (value != null) {
                return getHelperViewModel().getValueAt(value, column);
            } else {
                return "";
            }
        }
        
        throw new UnknownTypeException(object);
    }
    
    
    /**{@inheritDoc}*/
    public void setValueAt(Object object, String column, Object value)
        throws UnknownTypeException
    {
        if (object instanceof NamedValueHost) {
            Value val = ((NamedValueHost)object).getValue();
            if (val != null) {
                getHelperViewModel().setValueAt(val, column, value);
            }
            return;
        }
        
        throw new UnknownTypeException(object);
    }
    
    /**{@inheritDoc}*/
    public boolean isReadOnly(Object object, String column)
        throws UnknownTypeException
    {
        if (object instanceof NamedValueHost) {
            Value value = ((NamedValueHost)object).getValue();
            if (value != null) {
                return getHelperViewModel().isReadOnly(value, column);
            } else {
                return true;
            }
        }
            
        throw new UnknownTypeException(object);
    }
    
    private HelperViewModel getHelperViewModel() {
        if (myHelperViewModel == null) {
            List models = myContextProvider.lookup(VIEW_NAME, Model.class);
            for (Object model : models) {
                if (model instanceof HelperViewModel) {
                    myHelperViewModel = (HelperViewModel)model;
                    break;
                }
            }
        }
        return myHelperViewModel;
    }
}
