/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.xam;

import java.util.concurrent.Callable;

import javax.xml.namespace.QName;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.BpelModelImpl;
import org.netbeans.modules.bpel.model.xam.BpelAttributes;

/**
 *
 * @author ads
 */
public class BpelEntityTest extends TestCase {
    
    public BpelEntityTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BpelEntityTest.class);
        
        return suite;
    }


    public void testGetUID() throws Exception {
        Util.createData();
        BpelModelImpl model = Util.loadModel(); 
        ExtendableActivity activity = model.getProcess().getActivity();
        
        assertNotNull( activity.getUID() );
    }
    
    public void testCut() throws Exception {
        Util.createData();
        BpelModelImpl model = Util.loadModel(); 
        
        ExtendableActivity activity = model.getProcess().getActivity();
        UniqueId id = activity.getUID();
        
        BpelEntity entity = activity.cut();
        assertTrue( id == entity.getUID() );
        
        assertTrue( entity instanceof ExtendableActivity );
        
        assertTrue( model.getEntity( id ) == entity );
    }
    
    /**
     * This is actually test for some service that move namespaces from 
     * current element to root after placing this element into some container. 
     */
    public void testNamespaceMovingUp() throws Exception {
        Util.createData();
        BpelModelImpl model = Util.loadModel(); 
        
        PartnerLink link = model.getProcess().getPartnerLinkContainer().
            getPartnerLink( 1 );
        link = (PartnerLink) link.copy( model.getProcess().getPartnerLinkContainer() );
        model.getProcess().getPartnerLinkContainer().addPartnerLink( link );
        final PartnerLink link1 = model.getProcess().getPartnerLinkContainer().getPartnerLink(2);
        model.invoke( new Callable() {
            public Object call( ) {
                //((BpelEntityImpl)link1).setAttribute( "" , new PrefixAttribute("xmlns:otherns"), null);
                ((BpelEntityImpl)link1).removePrefix("otherns");
                /*String str =  ((BpelEntityImpl)link1).getAttribute( BpelAttributes.NAME);
                Util.debug( str);*/
                //return str;
                return link1;
            }
        } , null );
        
        
        
        //StringBuilder builder = new StringBuilder();
        //Util.flush( model , builder );
        //Util.debug( builder.toString() );
    }
    
    public void testGetAttribute() throws Exception  {
        Util.createData();
        BpelModelImpl model = Util.loadModel(); 
        
        PartnerLink link = model.getProcess().getPartnerLinkContainer().
        getPartnerLink( 0 );
        String str = ((BpelEntityImpl )link).getAttribute( 
                BpelAttributes.NAME );
        Util.debug( str );
    }
    
}
