/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation.imports;

import java.util.ArrayList;
import java.util.Collection;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.bpel.model.validation.SimpleValidationVisitorImpl;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation.ValidationType;
import org.netbeans.modules.xml.xam.spi.Validator.ResultItem;
import org.netbeans.modules.xml.xam.spi.Validator.ResultType;
import org.openide.util.NbBundle;

/**
 * @author Praveen Savur
 */

public class BPELImportsVisitor extends SimpleValidationVisitorImpl {

    private BPELImportsValidator mValidator;

    static final String FIX_NOT_WELL_FORMED
        = "FIX_NotWellFormedImport";                        // NOI18N

    private Collection<Model> importedModels = new ArrayList<Model>();

    public BPELImportsVisitor( BPELImportsValidator validator ) {
        this.mValidator = validator;
        init();
    }

    @Override
    public void visit( Import imp )
    {
        Model importModel;

        // Validate the imported model.
        importModel = getModel(imp);

        // Check whether the imported model is valid.
        if (importModel == null )
        {
            addInvalidImportModelError(imp);
            return;
        }
        else {
            importedModels.add(importModel);
        }
    }

    public void validateImportedModels() {
        // vlv # 92427
        if (importedModels == null) {
          return;
        }
        for (Model importedModel : importedModels) {
            if (importedModel == null) {
              continue;
            }
            if (mValidator == null) {
              continue;
            }
            if (mValidator.getValidation() == null) {
              continue;
            }
            mValidator.getValidation().validate(importedModel, ValidationType.COMPLETE);
        }
    }

    private Model getModel( Import imp ) {
        Model importModel = ImportHelper.getWsdlModel( imp , false );
        if (importModel != null) {
            return importModel;
        }
        return ImportHelper.getSchemaModel( imp , false );
    }

    private void addInvalidImportModelError( BpelEntity bpelEntity ) {
        ResultItem resultItem = new ResultItem(mValidator, ResultType.WARNING,
                bpelEntity, NbBundle.getMessage(BPELImportsVisitor.class,
                        FIX_NOT_WELL_FORMED));
        getResultItems().add(resultItem);
    }
}
