/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.impl.services;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.OutOfModelEvent;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.impl.events.BuildEvent;

/**
 * This is service that dispatch BuildEvents. It set the name for entity based
 * on its proposed tag name and existed names .
 * 
 * @author ads
 */
public class DefaultNameService extends InnerEventDispatcherAdapter {

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel.xdm.spi.InnerEventDispatcher#isApplicable(org.netbeans.modules.soa.model.bpel20.api.events.ChangeEvent)
     */
    public boolean isApplicable( ChangeEvent event ) {
        return event.getClass().equals(BuildEvent.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel.xdm.spi.InnerEventDispatcher#postDispatch(org.netbeans.modules.soa.model.bpel20.api.events.ChangeEvent)
     */
    public void postDispatch( ChangeEvent event ) {
        int index = 0;
        OutOfModelEvent buildEvent = (OutOfModelEvent) event;
        BpelEntity entity = buildEvent.getOutOfModelEntity();
        String tagName = event.getName();
        String lowerCase = null;
        if (tagName != null) {
            tagName = Character.toUpperCase(tagName.charAt(0))
                    + tagName.substring(1);
            lowerCase = tagName.toLowerCase();
        }

        if (entity instanceof NamedElement) {
            assert tagName != null;
            IntWrapper wrapper = new IntWrapper();
            calculateNewIndex((BpelEntity) entity.getBpelModel()
                    .getProcess(), lowerCase, wrapper );
            try {
                index = wrapper.get();
                index++;
                ((NamedElement) entity).setName(tagName + index);
            }
            catch (VetoException e) {
                assert false;
            }
        }
    }

    private void calculateNewIndex( BpelEntity component,
            String lowerCaseName , IntWrapper wrapper  )
    {
        int index = wrapper.get();
        if (component instanceof NamedElement) {
            String name = ((NamedElement) component).getName();
            if (name != null) {
                name = name.toLowerCase();
                if (name.startsWith(lowerCaseName)) {
                    String postfix = name.substring(lowerCaseName.length());
                    try {
                        Integer number = Integer.parseInt(postfix);
                        if (number > index) {
                            index = number;
                        }
                    }
                    catch (NumberFormatException e) {
                        // postfix is not a number - we don't need it.
                    }
                }
            }
        }
        wrapper.set( index );
        for (BpelEntity child : component.getChildren()) {
            calculateNewIndex(child, lowerCaseName, wrapper );
        }
    }
    
    private static class IntWrapper {
        IntWrapper( ){
        }
        
        int get() {
            return myInt;
        }
        
        void set( int i ){
            myInt = i;
        }
        
        private int myInt; 
    }

}
