package org.netbeans.modules.apisupport.project.ui.wizard.glf;

import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;


public final class GLFTemplateVisualPanel2 extends JPanel {

    private GLFTemplateWizardPanel2 wizardPanel;
    
    /** Creates new form GLFTemplateVisualPanel2 */
    public GLFTemplateVisualPanel2 (GLFTemplateWizardPanel2 wizardPanel) {
        this.wizardPanel = wizardPanel;
        initComponents ();
        DocumentListener documentListener = new DocumentListener () {
            public void insertUpdate (DocumentEvent e) {
                update ();
            }

            public void removeUpdate (DocumentEvent e) {
                update ();
            }

            public void changedUpdate (DocumentEvent e) {
                update ();
            }
            
        };
        tfExtensions.getDocument ().addDocumentListener (documentListener);
        tfMimeType.getDocument ().addDocumentListener (documentListener);
        update ();
    }
    
    private void update () {
        if (getMimeType ().trim ().length () < 1) {
            wizardPanel.getIterator ().getWizardDescriptor ().putProperty (
                "WizardPanel_errorMessage",  // NOI18N
                NbBundle.getMessage(GLFTemplateVisualPanel2.class, "CTL_Invalid_Mime_Type"));
            wizardPanel.setValid (false);
            return;
        }
        if (getExtensions ().trim ().length () < 1) {
            wizardPanel.getIterator ().getWizardDescriptor ().putProperty (
                "WizardPanel_errorMessage",  // NOI18N
                NbBundle.getMessage(GLFTemplateVisualPanel2.class, "CTL_Invalid_Extensions"));
            wizardPanel.setValid (false);
            return;
        }
        wizardPanel.getIterator ().getWizardDescriptor ().putProperty (
            "WizardPanel_errorMessage",  // NOI18N
            null
        );
        wizardPanel.setValid (true);
    }
    
    public @Override String getName () {
        return NbBundle.getMessage(GLFTemplateVisualPanel2.class, "CTL_Step2");
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        lMimeType = new javax.swing.JLabel();
        tfMimeType = new javax.swing.JTextField();
        lExtensions = new javax.swing.JLabel();
        tfExtensions = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();

        lMimeType.setLabelFor(tfMimeType);
        org.openide.awt.Mnemonics.setLocalizedText(lMimeType, org.openide.util.NbBundle.getMessage(GLFTemplateVisualPanel2.class, "CTL_Mime_Type")); // NOI18N

        lExtensions.setLabelFor(tfExtensions);
        org.openide.awt.Mnemonics.setLocalizedText(lExtensions, org.openide.util.NbBundle.getMessage(GLFTemplateVisualPanel2.class, "CTL_Extensions")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(GLFTemplateVisualPanel2.class, "CTL_Extensions_Comment")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lMimeType)
                    .add(lExtensions))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(tfExtensions, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 318, Short.MAX_VALUE)
                    .add(tfMimeType, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 318, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lMimeType)
                    .add(tfMimeType, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lExtensions)
                    .add(tfExtensions, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel1)
                .addContainerGap(223, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel lExtensions;
    private javax.swing.JLabel lMimeType;
    private javax.swing.JTextField tfExtensions;
    private javax.swing.JTextField tfMimeType;
    // End of variables declaration//GEN-END:variables
    
    String getMimeType () {
        return tfMimeType.getText ();
    }
    
    String getExtensions () {
        return tfExtensions.getText ();
    }
}

