/*
 * Copyright 2006 Ricoh Corporation.
 * 
 * 
 * APACHE LICENSE VERSION 2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 
 * RICOH DEVELOPER PROGRAM SUPPORT:
 * 
 * Support for this software is available only to "Premier Plus" members
 * of the Ricoh Developer Program (RiDP).  You may find out more 
 * information about the Program at
 * 
 *      http://americas.ricoh-developer.com
 * 
 * Premier plus members may find answers and ask questions through the
 * RiDP customer help website at
 * 
 *      https://ridp.custhelp.com
 * 
 * Developers who are not RiDP members may still use this software as
 * stipulated in the license terms given above.
 *
 */ 


import java.util.ArrayList;
import java.util.List;

import jp.co.ricoh.dsdk.panel.Button;
import jp.co.ricoh.dsdk.panel.Button.Shape;
import jp.co.ricoh.dsdk.panel.Frame;
import jp.co.ricoh.dsdk.panel.Container;
import jp.co.ricoh.dsdk.panel.AttributeType;
import jp.co.ricoh.dsdk.panel.event.ActionEvent;
import jp.co.ricoh.dsdk.panel.event.ActionListener;


import jp.co.ricoh.dsdk.xlet.Xlet;
import jp.co.ricoh.dsdk.xlet.XletContext;
import jp.co.ricoh.dsdk.xlet.XletStateChangeException;
import jp.co.ricoh.dsdk.xlet.UnavailableContainerException;

/**
 * Example program which creates one button for each available button
 * shapes provided in the SDK/J;
 * Users may use this application to test how each button shape will appear 
 * in the display. Clicking on a button will toggle that button to its inverse state.
 */
public class ButtonTest implements Xlet 
{

	private XletContext context;	
	private Frame rootContainer;
	int numButtons = 7;
	int buttonWidth = 65;
	int buttonHeight = 25;
	int border = 8;
	
	public void initXlet(XletContext arg0) throws XletStateChangeException 
	{
		//load the context
		context = arg0;
		
		try 
	  	{
			Container parent = context.getContainer();
			while(!(parent instanceof Frame))
			{
				parent = parent.getParent();
				if(parent == null)
					break;
			}
			if(parent == null)
			{
				System.exit(0);
			}
			rootContainer = (Frame)parent;
	  	}catch (UnavailableContainerException ex) {
			throw new XletStateChangeException();
		}
	  	
		buildGUI();
	}


	private void buildGUI() 
	{
		int xPosition = border;
		int yPosition = border;
		
		//getShapes();
		
		Button button;
		
		List buttonTypes = Shape.BGB.family();
		
		for(int i =0; i < buttonTypes.size(); i++ )
		{
			button = new Button( buttonTypes.get(i).toString());
			button.setShape((Shape)buttonTypes.get(i));
			button.setBounds( xPosition, yPosition, buttonWidth, buttonHeight);
			button.setWink(false);
			
			yPosition += (buttonHeight + border);
			if((i+1)%6 == 0)
			{
				yPosition = border;
				xPosition += (buttonWidth + border);
			}
			
			button.addActionListener( 
				new ActionListener()
				{
					public void actionPerformed(ActionEvent arg0)
					{
						Button target = (Button)arg0.getSource();
						if(target.getAttributeType() == AttributeType.INVERSE)
							target.setAttributeType(AttributeType.NONE);
						else
							target.setAttributeType(AttributeType.INVERSE);

						target.repaint();
					}
				}
			);
			
			rootContainer.add(button);
		}
	}


	public void startXlet() throws XletStateChangeException 
	{
	}

	public void pauseXlet() 
	{
	}

	public void destroyXlet(boolean arg0) throws XletStateChangeException 
	{	
	}
}
