<%-- 
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
 --%>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@page contentType="text/html"%>

<fmt:setLocale value="en_US" />

<sql:setDataSource dataSource="jdbc/CatalogDB"/>

<table border="0" width="100%" cellspacing="0">
<c:choose>
  <c:when test="${cart.departureFlight != null}">
<sql:query var="departureFlight"> 
 select name, carrier, description, price,imageuri from transportation where transportationid =  ? and locale = ?
 <sql:param>${cart.departureFlight}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>
  <tr><td colspan="4" align="left"><h2>Departing Flight</h2></td></tr>
  <tr>
   <td>
     <c:url var="imageURL" value="images/${departureFlight.rows[0].imageuri}"/>
     <image src="${imageURL}" alt="${departureFlight.rows[0].carrier} ${departureFlight.rows[0].name} Image">
   </td>
    <td align="left" colspan="2" >    
      <br>
      <b>${departureFlight.rows[0].carrier} ${departureFlight.rows[0].name}</b>
      <br>${departureFlight.rows[0].description}
      <br><b>Price Per Person:</b><fmt:formatNumber value="${departureFlight.rows[0].price}" type="currency" />
      <br><b>Number of People:</b> ${cart.headCount}
   </td>
   <td align="right">
    <form action="cart.do" method="POST">
     <input type="HIDDEN" name ="target_action" value="cancel_departure_flight">
     <input type="HIDDEN" name="tab" value="${param.tab}">
     <input type="SUBMIT" value="Cancel This Flight" name="Cancel This Flight">
    </form>
   </td>
  </tr>
  </c:when>
 </c:choose>

<c:choose>
  <c:when test="${cart.returnFlight != null}">
<sql:query var="returnFlight"> 
 select name, description, price,imageuri from transportation where transportationid =  ? and locale = ?
 <sql:param>${cart.returnFlight}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>
  <tr><td colspan="4" align="center"><hr width="90%" noshade="true"/></td></tr>
  <tr><td colspan="4" align="left"><h2>Return Flight</h2></td></tr>
  <tr>
   <td>
     <c:url var="imageURL" value="images/${returnFlight.rows[0].imageuri}"/>
     <image src="${imageURL}" alt="${departureFlight.rows[0].carrier} ${returnFlight.rows[0].name} Image">
   </td>
   <td colspan="2">
      <b>${departureFlight.rows[0].carrier} ${returnFlight.rows[0].name}</b>
      <br>${returnFlight.rows[0].description}
      <br><b>Price Per Person:</b><fmt:formatNumber value="${returnFlight.rows[0].price}" type="currency" />
      <br><b>Number of People:</b> ${cart.headCount}
   </td>
   <td align="right">
    <form action="cart.do" method="POST">
     <input type="HIDDEN" name ="target_action" value="cancel_return_flight">
     <input type="HIDDEN" name="tab" value="${param.tab}">
     <input type="SUBMIT" value="Cancel This Flight" name="Cancel This Flight">
    </form>
   </td>
  </tr>
  </c:when>
 </c:choose>
 <c:choose>
  <c:when test="${cart.returnFlight != null ||  cart.departureFlight != null}">
  <tr><td colspan="4"><hr width="100%" noshade="true"/></td></tr>
  <tr>
   <td colspan="2">
    <h2>Flight Total:</h2>
    </td>
   <td/>
   <td align="right">
     <b><fmt:formatNumber value="${cartBean.transportationTotal}" type="currency" /></b>
    </td>
  </tr>
  <tr>
   <td colspan="4" align="right">
    <form method="POST" action="searchtransport.do" >
     <input type="HIDDEN" name="tab" value="${param.tab}">
     <input type="SUBMIT" value="Change Transportation">
    </form>
   </td>
  </tr>
  </c:when>
  <c:when test="${cart.returnFlight == null && cart.departureFlight == null}">
   <sql:setDataSource dataSource="jdbc/CatalogDB"/>
   <sql:query var="flightOrigins"> 
     select distinct origin from transportation where locale = 'en_US'  and destination = ?
    <sql:param>${cart.destination}</sql:param>
   </sql:query>
  <tr>
   <td colspan="4">
    You have not selected any flights.
    </td>
  <tr> <td><label for="origin_flight_id">Origin</label> :</td>
   <td>
    <form method="POST"  action="searchtransport.do" >
     <input type="HIDDEN" name="tab" value="${param.tab}">
     <select name="origin" id="origin_flight_id">
     <c:forEach var="flightOrigin" begin="0" items="${flightOrigins.rows}">
       <option>${flightOrigin.origin}</option>
     </c:forEach> 
     </select>
  </td>
  </tr>
  <tr><td>Destination :</td>
   <td> 
       ${cart.destination} 
   </td>
  </tr> 
   <td colspan="2" align="right">
       <input type="SUBMIT" value="Search Available Transportation" name="Search Available Transportation">
     </form>
    </td>
  </tr>
 </c:when>
  </c:choose>
</table>
