/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.snmp.JdmkEngineFactory;
import com.sun.management.snmp.SnmpAckPdu;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduFactoryBER;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.manager.SnmpEventReportHandler;
import com.sun.management.snmp.manager.SnmpInformListener;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpTrapListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SnmpEventReportDispatcher
implements Runnable {
    private int snmpInTraps = 0;
    private int snmpInInforms = 0;
    private int snmpInPkts = 0;
    private int snmpInASNParseErrs = 0;
    private int snmpInBadVersions = 0;
    private int snmpInvalidMsgs = 0;
    private int snmpUnknownSecurityModels = 0;
    private int port = 162;
    private final DatagramSocket dSocket;
    private final ObjectList trapListeners = new ObjectList();
    private final ObjectList informListeners = new ObjectList();
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private SnmpEngineImpl engine = null;
    private boolean enabled = true;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    String dbgTag = "SnmpEventReportDispatcher";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", (class$com$sun$management$snmp$manager$SnmpEventReportDispatcher == null ? (class$com$sun$management$snmp$manager$SnmpEventReportDispatcher = SnmpEventReportDispatcher.class$("com.sun.management.snmp.manager.SnmpEventReportDispatcher")) : class$com$sun$management$snmp$manager$SnmpEventReportDispatcher).getName());
    static /* synthetic */ Class class$com$sun$management$snmp$manager$SnmpEventReportDispatcher;

    public SnmpEventReportDispatcher() throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), 162, null);
    }

    public SnmpEventReportDispatcher(int n) throws SocketException, IllegalArgumentException {
        this(new SnmpEngineParameters(), new JdmkEngineFactory(), n, null);
    }

    public SnmpEventReportDispatcher(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, int n) throws SocketException, IllegalArgumentException {
        this(SnmpEventReportDispatcher.createEngine(snmpEngineParameters, snmpEngineFactory), n, null);
    }

    public SnmpEventReportDispatcher(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, int n, InetAddress inetAddress) throws SocketException, IllegalArgumentException {
        this(SnmpEventReportDispatcher.createEngine(snmpEngineParameters, snmpEngineFactory), n, inetAddress);
    }

    public SnmpEventReportDispatcher(SnmpEngine snmpEngine, int n) throws SocketException, IllegalArgumentException {
        this(snmpEngine, n, null);
    }

    public SnmpEventReportDispatcher(SnmpEngine snmpEngine, int n, InetAddress inetAddress) throws SocketException, IllegalArgumentException {
        if (snmpEngine == null) {
            throw new IllegalArgumentException("Engine can't be null");
        }
        this.engine = (SnmpEngineImpl)snmpEngine;
        this.port = n;
        this.dSocket = inetAddress != null ? new DatagramSocket(this.port, inetAddress) : new DatagramSocket(this.port);
    }

    public Long getSnmpInTraps() {
        return new Long(this.snmpInTraps);
    }

    public Long getSnmpInInforms() {
        return new Long(this.snmpInInforms);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpInvalidMsgs() {
        return new Long(this.snmpInvalidMsgs);
    }

    public Long getSnmpUnknownSecurityModels() {
        return new Long(this.snmpUnknownSecurityModels);
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public SnmpEngineId getEngineId() {
        return this.engine.getEngineId();
    }

    public void close() throws IOException {
        this.enabled(false);
        if (this.dSocket != null) {
            this.dSocket.close();
        }
    }

    private synchronized void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    private synchronized void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    private synchronized void incSnmpInPkts(int n) {
        this.snmpInPkts += n;
    }

    private synchronized void incSnmpInInforms(int n) {
        this.snmpInInforms += n;
    }

    private synchronized void incSnmpInTraps(int n) {
        this.snmpInTraps += n;
    }

    private synchronized void incSnmpInvalidMsgs(int n) {
        this.snmpInvalidMsgs += n;
    }

    private synchronized void incSnmpUnknownSecurityModels(int n) {
        this.snmpUnknownSecurityModels += n;
    }

    private synchronized boolean enabled() {
        return this.enabled;
    }

    private synchronized boolean enabled(boolean bl) {
        this.enabled = bl;
        return bl;
    }

    private static SnmpEngine createEngine(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory) throws IllegalArgumentException {
        SnmpEngine snmpEngine;
        if (snmpEngineFactory == null) {
            snmpEngineFactory = new JdmkEngineFactory();
        }
        if (snmpEngineParameters == null) {
            snmpEngineParameters = new SnmpEngineParameters();
        }
        if ((snmpEngine = snmpEngineFactory.createEngine(snmpEngineParameters)) == null) {
            throw new IllegalArgumentException("The factory returned a null lengine. SnmpEventReportDispatcher initilization failed");
        }
        return snmpEngine;
    }

    private final SnmpIncomingRequest getIncomingReq(int n, DatagramPacket datagramPacket) throws SnmpStatusException, SnmpUnknownMsgProcModelException {
        SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = this.engine.getMsgProcessingSubSystem();
        return snmpMsgProcessingSubSystem.getIncomingRequest(n, this.pduFactory);
    }

    private final SnmpPdu decodePdu(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket) throws SnmpStatusException, SnmpUnknownSecModelException, SnmpBadSecurityLevelException {
        snmpIncomingRequest.decodeMessage(datagramPacket.getData(), datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort());
        SnmpPdu snmpPdu = null;
        if (!snmpIncomingRequest.isReport()) {
            snmpPdu = snmpIncomingRequest.decodeSnmpPdu();
        }
        return snmpPdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleTrap(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        SnmpPdu snmpPdu2 = snmpPdu;
        this.incSnmpInTraps(1);
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            int n2 = this.trapListeners.size;
            Object[] objectArray = this.trapListeners.list;
            for (int i = 0; i < n2; ++i) {
                SnmpTrapListener snmpTrapListener = (SnmpTrapListener)objectArray[i];
                SnmpEventReportHandler snmpEventReportHandler = new SnmpEventReportHandler(snmpTrapListener, snmpPdu2);
                this.handleCallback(snmpEventReportHandler);
            }
        }
    }

    private final void acknowledgeInform(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        DatagramPacket datagramPacket2 = this.makeResponsePacket(snmpIncomingRequest, datagramPacket, snmpPdu);
        if (datagramPacket2 == null) {
            return;
        }
        this.sendPacket(datagramPacket2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInform(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        SnmpPdu snmpPdu2 = snmpPdu;
        this.incSnmpInInforms(1);
        this.acknowledgeInform(n, snmpIncomingRequest, datagramPacket, snmpPdu);
        snmpPdu2.type = 166;
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            int n2 = this.informListeners.size;
            Object[] objectArray = this.informListeners.list;
            for (int i = 0; i < n2; ++i) {
                SnmpInformListener snmpInformListener = (SnmpInformListener)objectArray[i];
                SnmpEventReportHandler snmpEventReportHandler = new SnmpEventReportHandler(snmpInformListener, snmpPdu2);
                this.handleCallback(snmpEventReportHandler);
            }
        }
    }

    private final void sendPacket(DatagramPacket datagramPacket) {
        block10: {
            if (datagramPacket == null) {
                return;
            }
            try {
                if (logger.finerOn()) {
                    logger.finer("run", "Response packet to be sent:\n" + SnmpMsg.dumpHexBuffer(datagramPacket.getData(), 0, datagramPacket.getLength()));
                }
                this.dSocket.send(datagramPacket);
            }
            catch (SocketException socketException) {
                if (logger.finestOn()) {
                    if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                        logger.finest("run", "interrupted");
                    } else {
                        logger.finest("run", "i/o exception");
                        logger.finest("run", socketException);
                    }
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (logger.finestOn()) {
                    logger.finest("run", "interrupted");
                }
            }
            catch (Exception exception) {
                if (!logger.finestOn()) break block10;
                logger.finest("run", "failure when sending response");
                logger.finest("run", exception);
            }
        }
    }

    private final void handleV3GetRequest(int n, SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        DatagramPacket datagramPacket2;
        if (!snmpIncomingRequest.isReport() && logger.finestOn()) {
            logger.finest("run", "trashed the packet:  no report to send back to received request.");
        }
        if (logger.finestOn()) {
            logger.finest("run", "Received a getRequest, send back the report");
        }
        if ((datagramPacket2 = this.makeResponsePacket(snmpIncomingRequest, datagramPacket, snmpPdu)) == null) {
            return;
        }
        this.sendPacket(datagramPacket2);
    }

    protected void handleCallback(Runnable runnable) {
        runnable.run();
    }

    protected void handlePacket(Runnable runnable) {
        new Thread(runnable).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doHandlePacket(int n, DatagramPacket datagramPacket) {
        boolean bl = logger.finestOn();
        boolean bl2 = bl ? true : logger.finerOn();
        try {
            SnmpPdu snmpPdu;
            SnmpIncomingRequest snmpIncomingRequest;
            block26: {
                block25: {
                    snmpIncomingRequest = this.getIncomingReq(n, datagramPacket);
                    try {
                        snmpPdu = this.decodePdu(n, snmpIncomingRequest, datagramPacket);
                    }
                    catch (SnmpStatusException snmpStatusException) {
                        if (bl) {
                            logger.finest("handlePacket", "Rejecting trap : " + snmpStatusException);
                        }
                        this.incSnmpInASNParseErrs(1);
                        return;
                    }
                    if (snmpIncomingRequest.isReport()) {
                        DatagramPacket datagramPacket2;
                        if (bl) {
                            logger.finest("handlePacket", "Report to send back");
                        }
                        if ((datagramPacket2 = this.makeResponsePacket(snmpIncomingRequest, datagramPacket, null)) == null) {
                            return;
                        }
                        this.sendPacket(datagramPacket2);
                        return;
                    }
                    if (snmpPdu.type == 164) break block25;
                    if (snmpPdu.type != 167) break block26;
                }
                if (bl2) {
                    if (snmpPdu.type == 164) {
                        logger.finer("run", "Received an SNMP trap V1");
                    } else {
                        logger.finer("run", "Received an SNMP trap V2 or V3");
                    }
                }
                this.handleTrap(n, snmpIncomingRequest, datagramPacket, snmpPdu);
                return;
            }
            if (snmpPdu.type == 166) {
                if (bl2) {
                    logger.finer("run", "Received an Inform Request");
                }
                this.handleInform(n, snmpIncomingRequest, datagramPacket, snmpPdu);
                return;
            }
            if (snmpPdu.type == 160 && n == 3) {
                if (bl2) {
                    logger.finer("run", "Received a V3 Get Request (timeliness discovery)");
                }
                this.handleV3GetRequest(n, snmpIncomingRequest, datagramPacket, snmpPdu);
                return;
            }
            if (bl2) {
                logger.finer("run", "trashed the packet: bad PDU type.");
            }
            if (!bl) return;
            logger.finest("run", "trashed the packet because it's not an SNMP event report or get request (timeliness discovery)");
            return;
        }
        catch (SnmpStatusException snmpStatusException) {
            if (!bl) return;
            logger.finest("run", "Response packet encoding failed " + snmpStatusException);
            return;
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (bl) {
                logger.finest("run", "packet decoding failed " + snmpUnknownSecModelException);
            }
            this.incSnmpUnknownSecurityModels(1);
            return;
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (bl) {
                logger.finest("run", "Unknown Msg processing model " + snmpUnknownMsgProcModelException);
            }
            this.incSnmpInBadVersions(1);
            return;
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (bl) {
                logger.finest("run", "Invalid msg, bad security level " + snmpBadSecurityLevelException);
            }
            this.incSnmpInvalidMsgs(1);
        }
    }

    public void run() {
        while (this.enabled()) {
            try {
                byte[] byArray = new byte[SnmpPeer.defaultSnmpRequestPktSize];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, SnmpPeer.defaultSnmpRequestPktSize);
                this.dSocket.setSoTimeout(0);
                if (logger.finerOn()) {
                    logger.finer("run", "Now waiting for event reports...");
                }
                this.dSocket.receive(datagramPacket);
                if (logger.finerOn()) {
                    logger.finer("run", "Received a packet from : " + datagramPacket.getAddress().toString() + ", Length = " + datagramPacket.getLength());
                }
                this.incSnmpInPkts(1);
                int n = SnmpMsg.getProtocolVersion(datagramPacket.getData());
                this.handlePacket(new PacketHandler(n, datagramPacket));
            }
            catch (SnmpStatusException snmpStatusException) {
                if (logger.finestOn()) {
                    logger.finest("run", "packet decoding failed");
                }
                this.incSnmpInASNParseErrs(1);
            }
            catch (Exception exception) {
                if (!logger.finestOn()) continue;
                logger.finest("run", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            this.trapListeners.add(snmpTrapListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            this.informListeners.add(snmpInformListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            this.trapListeners.remove(snmpTrapListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            this.informListeners.remove(snmpInformListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTrapListener(SnmpTrapListener snmpTrapListener) {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            return this.trapListeners.contains(snmpTrapListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInformListener(SnmpInformListener snmpInformListener) {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            return this.informListeners.contains(snmpInformListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getTrapListeners() {
        ObjectList objectList = this.trapListeners;
        synchronized (objectList) {
            return this.trapListeners.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInformListeners() {
        ObjectList objectList = this.informListeners;
        synchronized (objectList) {
            return this.informListeners.elements();
        }
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(SnmpPduFactory snmpPduFactory) {
        if (snmpPduFactory == null) {
            snmpPduFactory = new SnmpPduFactoryBER();
        }
        this.pduFactory = snmpPduFactory;
    }

    private DatagramPacket makeResponsePacket(SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        DatagramPacket datagramPacket2;
        block7: {
            datagramPacket2 = null;
            SnmpMsg snmpMsg = this.makeResponseMessage(snmpIncomingRequest, datagramPacket, snmpPdu);
            try {
                if (snmpIncomingRequest.isReport() || snmpMsg != null) {
                    datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (logger.finestOn()) {
                    logger.finest("makeResponsePacket", "response message is too big");
                }
                try {
                    SnmpPdu snmpPdu2 = this.newTooBigPdu(snmpPdu);
                    snmpMsg = snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, datagramPacket.getData().length);
                    datagramPacket.setLength(snmpIncomingRequest.encodeMessage(datagramPacket.getData()));
                    datagramPacket2 = datagramPacket;
                }
                catch (SnmpStatusException snmpStatusException) {
                    throw new InternalError();
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (!logger.finestOn()) break block7;
                    logger.finest("makeResponsePacket", "'too big' is 'too big' !!!");
                }
            }
        }
        return datagramPacket2;
    }

    private SnmpMsg makeResponseMessage(SnmpIncomingRequest snmpIncomingRequest, DatagramPacket datagramPacket, SnmpPdu snmpPdu) {
        SnmpMsg snmpMsg = null;
        SnmpPdu snmpPdu2 = null;
        if (!snmpIncomingRequest.isReport() && snmpPdu != null) {
            snmpPdu2 = this.makeResponsePdu(snmpPdu);
        }
        if (snmpPdu2 != null) {
            try {
                snmpMsg = snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, datagramPacket.getData().length);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (logger.finestOn()) {
                    logger.finest("makeResponseMessage", "failure when encoding the response message");
                    logger.finest("makeResponseMessage", snmpStatusException);
                }
                snmpMsg = null;
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (logger.finestOn()) {
                    logger.finest("makeResponseMessage", "response message is too big");
                }
                try {
                    snmpPdu2 = this.newTooBigPdu(snmpPdu);
                    snmpMsg = snmpIncomingRequest.encodeSnmpPdu(snmpPdu2, datagramPacket.getData().length);
                }
                catch (SnmpTooBigException snmpTooBigException2) {
                    if (logger.finestOn()) {
                        logger.finest("makeResponseMessage", "'too big' is 'too big' !!!");
                    }
                    snmpMsg = null;
                }
                catch (Exception exception) {
                    snmpMsg = null;
                }
            }
        }
        return snmpMsg;
    }

    private SnmpPdu makeResponsePdu(SnmpPdu snmpPdu) {
        SnmpPdu snmpPdu2 = null;
        if (this.checkPduType(snmpPdu)) {
            snmpPdu2 = snmpPdu;
            snmpPdu2.type = 162;
        }
        return snmpPdu2;
    }

    private boolean checkPduType(SnmpPdu snmpPdu) {
        if (snmpPdu.type == 166) {
            return true;
        }
        if (logger.finestOn()) {
            logger.finest("checkPduType", "cannot respond to this kind of PDU");
        }
        return false;
    }

    private SnmpPdu newTooBigPdu(SnmpPdu snmpPdu) {
        SnmpAckPdu snmpAckPdu = (SnmpAckPdu)((Object)snmpPdu);
        SnmpPdu snmpPdu2 = snmpAckPdu.getResponsePdu();
        snmpPdu2.varBindList = null;
        SnmpPduRequestType snmpPduRequestType = (SnmpPduRequestType)((Object)snmpPdu2);
        snmpPduRequestType.setErrorStatus(1);
        snmpPduRequestType.setErrorIndex(0);
        return snmpPdu2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PacketHandler
    implements Runnable {
        private final int version;
        private final DatagramPacket packet;

        PacketHandler(int n, DatagramPacket datagramPacket) {
            this.version = n;
            this.packet = datagramPacket;
        }

        public void run() {
            block2: {
                try {
                    SnmpEventReportDispatcher.this.doHandlePacket(this.version, this.packet);
                }
                catch (Exception exception) {
                    if (!logger.finestOn()) break block2;
                    logger.finest("Unexpected exception, failed to handle packet: ", exception);
                }
            }
        }
    }

    private static class ObjectList {
        public static int DEFAULT_CAPACITY = 10;
        public static int DEFAULT_INCREMENT = 10;
        private final int DELTA;
        private int size = 0;
        public Object[] list;

        ObjectList() {
            this(DEFAULT_CAPACITY, DEFAULT_INCREMENT);
        }

        ObjectList(int n) {
            this(n, DEFAULT_INCREMENT);
        }

        ObjectList(int n, int n2) {
            this.DELTA = n2;
            this.list = this.allocate(n);
        }

        public final int size() {
            return this.size;
        }

        public final boolean add(Object object) {
            if (object == null) {
                return false;
            }
            if (this.size >= this.list.length) {
                this.resize();
            }
            this.list[this.size++] = object;
            return true;
        }

        public final void add(int n, Object object) {
            if (n > this.size) {
                throw new IndexOutOfBoundsException();
            }
            if (n >= this.list.length) {
                this.resize();
            }
            if (n == this.size) {
                this.list[this.size++] = object;
                return;
            }
            System.arraycopy(this.list, n, this.list, n + 1, this.size - n);
            this.list[n] = object;
            ++this.size;
        }

        public final boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            int n = this.size;
            Object[] objectArray = this.list;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != object) continue;
                this.remove(i);
                return true;
            }
            return false;
        }

        public final Object remove(int n) {
            if (n >= this.size) {
                return null;
            }
            Object object = this.list[n];
            this.list[n] = null;
            if (n == --this.size) {
                return object;
            }
            System.arraycopy(this.list, n + 1, this.list, n, this.size - n);
            return object;
        }

        public final int indexOf(Object object) {
            if (object == null) {
                return -1;
            }
            int n = this.size;
            Object[] objectArray = this.list;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != object) continue;
                return i;
            }
            return -1;
        }

        public final boolean contains(Object object) {
            return this.indexOf(object) > -1;
        }

        public final java.util.Enumeration elements() {
            return new Enumeration();
        }

        private final void resize() {
            Object[] objectArray = this.allocate(this.list.length + this.DELTA);
            System.arraycopy(this.list, 0, objectArray, 0, this.size);
            this.list = objectArray;
        }

        private final Object[] allocate(int n) {
            return new Object[n];
        }

        private final class Enumeration
        implements java.util.Enumeration {
            private int next = 0;

            private Enumeration() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasMoreElements() {
                ObjectList objectList = ObjectList.this;
                synchronized (objectList) {
                    return this.next < ObjectList.this.size();
                }
            }

            public Object nextElement() {
                ObjectList objectList = ObjectList.this;
                synchronized (objectList) {
                    if (this.next < ObjectList.this.size()) {
                        return ObjectList.this.list[this.next++];
                    }
                    throw new NoSuchElementException();
                }
            }
        }
    }
}

