/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpOidRecord;
import com.sun.management.snmp.SnmpOidTable;
import com.sun.management.snmp.SnmpStatusException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpOidTableSupport
implements SnmpOidTable {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpOidTableSupport");
    String dbgTag = "SnmpOidTableSupport";
    private Hashtable oidStore = new Hashtable();
    private String myName;

    public SnmpOidTableSupport(String string) {
        this.myName = string;
    }

    public SnmpOidRecord resolveVarName(String string) throws SnmpStatusException {
        SnmpOidRecord snmpOidRecord = (SnmpOidRecord)this.oidStore.get(string);
        if (snmpOidRecord != null) {
            return snmpOidRecord;
        }
        throw new SnmpStatusException("Variable name <" + string + "> not found in Oid repository");
    }

    public SnmpOidRecord resolveVarOid(String string) throws SnmpStatusException {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new SnmpStatusException("Variable oid <" + string + "> not found in Oid repository");
        }
        if (n == 0) {
            string = string.substring(1, string.length());
        }
        Enumeration enumeration = this.oidStore.elements();
        while (enumeration.hasMoreElements()) {
            SnmpOidRecord snmpOidRecord = (SnmpOidRecord)enumeration.nextElement();
            if (!snmpOidRecord.getOid().equals(string)) continue;
            return snmpOidRecord;
        }
        throw new SnmpStatusException("Variable oid <" + string + "> not found in Oid repository");
    }

    public Vector getAllEntries() {
        Vector vector = new Vector();
        Enumeration enumeration = this.oidStore.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public synchronized void loadMib(SnmpOidRecord[] snmpOidRecordArray) {
        try {
            int n = 0;
            while (true) {
                SnmpOidRecord snmpOidRecord = snmpOidRecordArray[n];
                if (logger.finerOn()) {
                    logger.finer("loadMib", "load " + snmpOidRecord.getName());
                }
                this.oidStore.put(snmpOidRecord.getName(), snmpOidRecord);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpOidTableSupport)) {
            return false;
        }
        SnmpOidTableSupport snmpOidTableSupport = (SnmpOidTableSupport)object;
        return this.myName.equals(snmpOidTableSupport.getName());
    }

    public String getName() {
        return this.myName;
    }
}

