/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.remote.cascading.BasicMBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ReconnectMBeanServerConnectionFactory
extends BasicMBeanServerConnectionFactory
implements Runnable,
Serializable {
    private static final long serialVersionUID = -5764359043690071419L;
    private long envelopTime;
    private long period;
    private boolean stop = false;
    private transient boolean failed = false;
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private JMXServiceURL url;
    private Map map;
    private String currentConnectionId;
    private transient JMXConnector connector = null;
    private transient MBeanServerConnection connection = null;
    private final NotificationListener listener;

    public ReconnectMBeanServerConnectionFactory(JMXServiceURL jMXServiceURL, Map map, long l, long l2) throws IOException {
        super(null, null);
        this.url = jMXServiceURL;
        this.map = map;
        this.envelopTime = l;
        this.period = l2;
        this.listener = new NotificationListener(){

            public void handleNotification(Notification notification, Object object) {
                ReconnectMBeanServerConnectionFactory.this.handleConnectionNotification(notification, object);
            }
        };
        if (this.getJMXConnector() == null) {
            if (l == 0L) {
                throw new IOException("Unable to connect to " + jMXServiceURL);
            }
            this.reconnect();
        } else {
            this.currentConnectionId = this.getConnectionId();
        }
    }

    public JMXServiceURL getURL() {
        return this.url;
    }

    private static JMXConnector makeConnector(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        JMXConnector jMXConnector = null;
        try {
            jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return jMXConnector;
    }

    public synchronized void stopReconnection() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = System.currentTimeMillis();
        JMXConnector jMXConnector = this.getJMXConnector();
        String string = null;
        while (true) {
            try {
                JMXConnector jMXConnector2 = ReconnectMBeanServerConnectionFactory.makeConnector(this.url, this.map);
                if (jMXConnector2 == null) {
                    throw new Exception("Not connected");
                }
                jMXConnector2.addConnectionNotificationListener(this.listener, null, null);
                Serializable serializable = this;
                synchronized (serializable) {
                    this.connector = jMXConnector2;
                    this.connection = null;
                }
                string = jMXConnector2.getConnectionId();
                serializable = new JMXConnectionNotification("jmx.remote.connection.open", "", string, 0L, "", "");
                this.broadcaster.sendNotification((Notification)serializable);
                return;
            }
            catch (Exception exception) {
                long l2;
                try {
                    Thread.sleep(this.period);
                    continue;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if ((l2 = System.currentTimeMillis()) - l < this.envelopTime && !this.stop) continue;
                if (!this.stop) {
                    if (this.currentConnectionId == null) {
                        this.currentConnectionId = "NeverConnectedConnection";
                    }
                    JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.failed", "", this.currentConnectionId, 0L, "", "");
                    this.broadcaster.sendNotification(jMXConnectionNotification);
                    try {
                        this.currentConnectionId = this.getConnectionId();
                    }
                    catch (Exception exception3) {
                        this.currentConnectionId = null;
                    }
                }
                return;
            }
            break;
        }
    }

    private void reconnect() {
        if (this.envelopTime > 0L) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void handleConnectionNotification(Notification notification, Object object) {
        if (notification.getType().equals("jmx.remote.connection.failed")) {
            try {
                this.getJMXConnector().removeConnectionNotificationListener(this.listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reconnect();
        } else {
            this.broadcaster.sendNotification(notification);
        }
    }

    public void addConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener);
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    public static MBeanServerConnectionFactory newInstance(JMXServiceURL jMXServiceURL, Map map, long l, long l2) throws IOException {
        return new ReconnectMBeanServerConnectionFactory(jMXServiceURL, map, l, l2);
    }

    public synchronized JMXConnector getJMXConnector() {
        try {
            if (this.connector == null) {
                this.connector = ReconnectMBeanServerConnectionFactory.makeConnector(this.url, this.map);
                this.connector.addConnectionNotificationListener(this.listener, null, this.connector);
                this.connection = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connector;
    }

    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        if (this.failed) {
            throw new IOException("connection already failed");
        }
        if (this.getJMXConnector() == null) {
            throw new IOException("Unable to connect");
        }
        if (this.connection == null) {
            this.connection = this.getJMXConnector().getMBeanServerConnection(this.getDelegationSubject());
        }
        return this.connection;
    }
}

