/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.internal.ClassLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;

abstract class GenericHttpNotificationForwarder
extends GenericHttpConnectorClient
implements NotificationBackConnector {
    private static final int BUFFER_SIZE = 256;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm", "GenericHttpNotificationForwarder");
    private transient boolean connected = false;

    public GenericHttpNotificationForwarder(GenericHttpConnectorAddress genericHttpConnectorAddress) {
        this.httpConnAddr = genericHttpConnectorAddress;
        this.factory = this.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] sendHttp(Object[] objectArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            objectOutputStream.writeObject(objectArray[i]);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Socket socket = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        try {
            int n;
            socket = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
            OutputStream outputStream = socket.getOutputStream();
            if (byArray.length != 0) {
                outputStream.write(byArray);
            }
            outputStream.flush();
            InputStream inputStream = socket.getInputStream();
            byte[] byArray2 = new byte[256];
            byteArrayOutputStream2 = new ByteArrayOutputStream(256);
            while ((n = inputStream.read(byArray2, 0, 256)) != -1) {
                byteArrayOutputStream2.write(byArray2, 0, n);
            }
            Object var13_14 = null;
            if (socket == null) return byteArrayOutputStream2.toByteArray();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (socket == null) throw throwable;
            try {
                try {
                    socket.close();
                    socket = null;
                    throw throwable;
                }
                catch (IOException iOException) {
                    socket = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                socket = null;
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            socket = null;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            socket = null;
            return byteArrayOutputStream2.toByteArray();
        }
        socket.close();
        socket = null;
        return byteArrayOutputStream2.toByteArray();
    }

    public String connect() {
        if (logger.finerOn()) {
            logger.finer("connect", "connect");
        }
        this.connected = true;
        return null;
    }

    public void disconnect() {
        if (logger.finerOn()) {
            logger.finer("disconnect", "disconnect");
        }
        if (this.connected) {
            this.httpConnAddr = null;
            this.connected = false;
        }
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        if (logger.finerOn()) {
            logger.finer("remoteRequest", "remoteRequest");
        }
        if (!this.connected) {
            throw new CommunicationException("NotificationForwarder not connected");
        }
        Object[] objectArray2 = new Object[]{"remoteRequest", new Integer(n), objectArray};
        try {
            byte[] byArray = this.sendHttp(objectArray2);
            if (byArray.length == 0) {
                throw new IllegalAccessException("Entity Body in HTTP Response is empty");
            }
            Object object = this.readObjectValue(byArray);
            if (object instanceof Exception) {
                throw (Exception)object;
            }
            return (Object[])object;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            if (logger.finestOn()) {
                logger.finest("remoteRequest", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(iOException);
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("remoteRequest", "Unexpected exception");
            }
            throw new CommunicationException(exception);
        }
    }

    private Object readObjectValue(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        String string = (String)objectInputStream.readObject();
        if (logger.finestOn()) {
            logger.finest("readObjectValue", "Received object of type " + string);
        }
        return objectInputStream.readObject();
    }
}

